/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.protocol;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.celeborn.common.protocol.PbStorageInfo;

public class StorageInfo
implements Serializable {
    public static Map<Integer, Type> typesMap = new HashMap<Integer, Type>();
    public static Set<String> typeNames = new HashSet<String>();
    public static final int MEMORY_MASK = 1;
    public static final int LOCAL_DISK_MASK = 2;
    public static final int HDFS_MASK = 4;
    public static final int OSS_MASK = 8;
    public static final int ALL_TYPES_AVAILABLE_MASK = 0;
    private Type type = Type.MEMORY;
    private String mountPoint = "";
    private boolean finalResult = false;
    private String filePath;
    public int availableStorageTypes = 0;

    public StorageInfo() {
    }

    public StorageInfo(Type type, boolean isFinal, String filePath) {
        this.type = type;
        this.finalResult = isFinal;
        this.filePath = filePath;
    }

    public StorageInfo(String mountPoint, Type type, int availableStorageTypes) {
        this.mountPoint = mountPoint;
        this.type = type;
        this.availableStorageTypes = availableStorageTypes;
    }

    public StorageInfo(Type type, String mountPoint, boolean finalResult, String filePath, int availableStorageTypes) {
        this.type = type;
        this.mountPoint = mountPoint;
        this.finalResult = finalResult;
        this.filePath = filePath;
        this.availableStorageTypes = availableStorageTypes;
    }

    public boolean isFinalResult() {
        return this.finalResult;
    }

    public void setFinalResult(boolean finalResult) {
        this.finalResult = finalResult;
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public void setMountPoint(String mountPoint) {
        this.mountPoint = mountPoint;
    }

    public Type getType() {
        return this.type;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String toString() {
        return "StorageInfo{type=" + (Object)((Object)this.type) + ", mountPoint='" + this.mountPoint + '\'' + ", finalResult=" + this.finalResult + ", filePath=" + this.filePath + '}';
    }

    public static boolean localDiskAvailable(int availableStorageTypes) {
        return availableStorageTypes == 0 || (availableStorageTypes & 2) > 0;
    }

    public boolean localDiskAvailable() {
        return StorageInfo.localDiskAvailable(this.availableStorageTypes);
    }

    public static boolean HDFSAvailable(int availableStorageTypes) {
        return availableStorageTypes == 0 || (availableStorageTypes & 4) > 0;
    }

    public boolean HDFSAvailable() {
        return StorageInfo.HDFSAvailable(this.availableStorageTypes);
    }

    public static boolean HDFSOnly(int availableStorageTypes) {
        return availableStorageTypes == 4;
    }

    public boolean HDFSOnly() {
        return StorageInfo.HDFSOnly(this.availableStorageTypes);
    }

    public static boolean OSSAvailable(int availableStorageTypes) {
        return availableStorageTypes == 0 || (availableStorageTypes & 8) > 0;
    }

    public boolean OSSAvailable() {
        return StorageInfo.OSSAvailable(this.availableStorageTypes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageInfo that = (StorageInfo)o;
        return this.finalResult == that.finalResult && this.availableStorageTypes == that.availableStorageTypes && this.type == that.type && Objects.equals(this.mountPoint, that.mountPoint) && Objects.equals(this.filePath, that.filePath);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.mountPoint, this.finalResult, this.filePath, this.availableStorageTypes});
    }

    public static final boolean validate(String typeStr) {
        return typeNames.contains(typeStr);
    }

    public static PbStorageInfo toPb(StorageInfo storageInfo) {
        String filePath = storageInfo.getFilePath();
        PbStorageInfo.Builder builder = PbStorageInfo.newBuilder();
        builder.setType(storageInfo.type.value).setFinalResult(storageInfo.finalResult).setMountPoint(storageInfo.mountPoint).setAvailableStorageTypes(storageInfo.availableStorageTypes);
        if (filePath != null) {
            builder.setFilePath(filePath);
        }
        return builder.build();
    }

    public static StorageInfo fromPb(PbStorageInfo pbStorageInfo) {
        return new StorageInfo(typesMap.get(pbStorageInfo.getType()), pbStorageInfo.getMountPoint(), pbStorageInfo.getFinalResult(), pbStorageInfo.getFilePath(), pbStorageInfo.getAvailableStorageTypes());
    }

    public static int getAvailableTypes(List<Type> types) {
        int ava = 0;
        for (Type type : types) {
            switch (type) {
                case MEMORY: {
                    ava |= 1;
                    break;
                }
                case HDD: 
                case SSD: {
                    ava |= 2;
                    break;
                }
                case HDFS: {
                    ava |= 4;
                    break;
                }
                case OSS: {
                    ava |= 8;
                }
            }
        }
        return ava;
    }

    static {
        for (Type type : Type.values()) {
            typesMap.put(type.value, type);
            typeNames.add(type.name());
        }
    }

    public static enum Type {
        MEMORY(0),
        HDD(1),
        SSD(2),
        HDFS(3),
        OSS(4);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

