/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.util.ThreadUtils;
import org.apache.celeborn.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShutdownHookManager {
    private static final Logger LOG = LoggerFactory.getLogger(ShutdownHookManager.class);
    private static final ShutdownHookManager MGR = new ShutdownHookManager();
    public static final long TIMEOUT_MINIMUM = 1000L;
    public static final TimeUnit TIME_UNIT_DEFAULT = TimeUnit.MILLISECONDS;
    private static final ExecutorService EXECUTOR = ThreadUtils.newDaemonSingleThreadExecutor("celeborn-shutdown-hook-%01d");
    private final Set<HookEntry> hooks = Collections.synchronizedSet(new HashSet());
    private AtomicBoolean shutdownInProgress = new AtomicBoolean(false);

    static int executeShutdown() {
        int timeouts = 0;
        for (HookEntry entry : MGR.getShutdownHooksInOrder()) {
            Future<?> future = EXECUTOR.submit(entry.getHook());
            try {
                LOG.info("timeout {}", (Object)Utils.msDurationToString(entry.getTimeUnit().convert(entry.getTimeout(), TimeUnit.MILLISECONDS)));
                future.get(entry.getTimeout(), entry.getTimeUnit());
            }
            catch (TimeoutException ex) {
                ++timeouts;
                future.cancel(true);
                LOG.warn("ShutdownHook '{}' timeout", (Object)entry.getHook().getClass().getSimpleName(), (Object)ex);
            }
            catch (Throwable ex) {
                LOG.warn("ShutdownHook '{}' failed", (Object)entry.getHook().getClass().getSimpleName(), (Object)ex);
            }
        }
        return timeouts;
    }

    private static void shutdownExecutor(CelebornConf conf) {
        try {
            EXECUTOR.shutdown();
            long shutdownTimeout = ShutdownHookManager.getShutdownTimeout(conf);
            if (!EXECUTOR.awaitTermination(shutdownTimeout, TIME_UNIT_DEFAULT)) {
                LOG.error("ShutdownHookManger shutdown forcefully after {} ms.", (Object)shutdownTimeout);
                EXECUTOR.shutdownNow();
            }
            LOG.debug("ShutdownHookManger completed shutdown.");
        }
        catch (InterruptedException ex) {
            LOG.error("ShutdownHookManger interrupted while waiting for termination.", (Throwable)ex);
            EXECUTOR.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static ShutdownHookManager get() {
        return MGR;
    }

    static long getShutdownTimeout(CelebornConf conf) {
        long duration = conf.workerGracefulShutdownTimeoutMs();
        if (duration < 1000L) {
            duration = 1000L;
        }
        return duration;
    }

    private ShutdownHookManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<HookEntry> getShutdownHooksInOrder() {
        ArrayList<HookEntry> list;
        Set<HookEntry> set = ShutdownHookManager.MGR.hooks;
        synchronized (set) {
            list = new ArrayList<HookEntry>(ShutdownHookManager.MGR.hooks);
        }
        Collections.sort(list, new Comparator<HookEntry>(){

            @Override
            public int compare(HookEntry o1, HookEntry o2) {
                return o2.priority - o1.priority;
            }
        });
        return list;
    }

    public void addShutdownHook(Runnable shutdownHook, int priority) {
        if (shutdownHook == null) {
            throw new IllegalArgumentException("shutdownHook cannot be NULL");
        }
        if (this.shutdownInProgress.get()) {
            throw new IllegalStateException("Shutdown in progress, cannot add a shutdownHook");
        }
        this.hooks.add(new HookEntry(shutdownHook, priority));
    }

    public void addShutdownHook(Runnable shutdownHook, int priority, long timeout, TimeUnit unit) {
        if (shutdownHook == null) {
            throw new IllegalArgumentException("shutdownHook cannot be NULL");
        }
        if (this.shutdownInProgress.get()) {
            throw new IllegalStateException("Shutdown in progress, cannot add a shutdownHook");
        }
        this.hooks.add(new HookEntry(shutdownHook, priority, timeout, unit));
    }

    public void updateTimeout(long timeout, TimeUnit unit) {
        this.hooks.forEach(hook -> hook.setTimeout(timeout, unit));
    }

    public boolean removeShutdownHook(Runnable shutdownHook) {
        if (this.shutdownInProgress.get()) {
            throw new IllegalStateException("Shutdown in progress, cannot remove a shutdownHook");
        }
        return this.hooks.remove(new HookEntry(shutdownHook, 0));
    }

    public boolean hasShutdownHook(Runnable shutdownHook) {
        return this.hooks.contains(new HookEntry(shutdownHook, 0));
    }

    public boolean isShutdownInProgress() {
        return this.shutdownInProgress.get();
    }

    public void clearShutdownHooks() {
        this.hooks.clear();
    }

    static {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (MGR.shutdownInProgress.getAndSet(true)) {
                        LOG.info("Shutdown process invoked a second time: ignoring");
                        return;
                    }
                    long started = System.currentTimeMillis();
                    int timeoutCount = ShutdownHookManager.executeShutdown();
                    long ended = System.currentTimeMillis();
                    LOG.debug(String.format("Completed shutdown in %.3f seconds; Timeouts: %d", (double)(ended - started) / 1000.0, timeoutCount));
                    ShutdownHookManager.shutdownExecutor(new CelebornConf());
                }
            });
        }
        catch (IllegalStateException ex) {
            LOG.warn("Failed to add the ShutdownHook", (Throwable)ex);
        }
    }

    static class HookEntry {
        private final Runnable hook;
        private final int priority;
        private long timeout;
        private TimeUnit unit;

        HookEntry(Runnable hook, int priority) {
            this(hook, priority, ShutdownHookManager.getShutdownTimeout(new CelebornConf()), TIME_UNIT_DEFAULT);
        }

        HookEntry(Runnable hook, int priority, long timeout, TimeUnit unit) {
            this.hook = hook;
            this.priority = priority;
            this.timeout = timeout;
            this.unit = unit;
        }

        public int hashCode() {
            return this.hook.hashCode();
        }

        public boolean equals(Object obj) {
            boolean eq2 = false;
            if (obj != null && obj instanceof HookEntry) {
                eq2 = this.hook == ((HookEntry)obj).hook;
            }
            return eq2;
        }

        Runnable getHook() {
            return this.hook;
        }

        int getPriority() {
            return this.priority;
        }

        long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(long timeout, TimeUnit unit) {
            this.timeout = timeout;
            this.unit = unit;
        }

        TimeUnit getTimeUnit() {
            return this.unit;
        }
    }
}

