/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.write;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.write.DataBatches;
import org.apache.celeborn.common.write.InFlightRequestTracker;
import org.apache.celeborn.shaded.org.apache.commons.lang3.tuple.Pair;

public class PushState {
    private final int pushBufferMaxSize;
    public AtomicReference<IOException> exception = new AtomicReference();
    private final InFlightRequestTracker inFlightRequestTracker;
    public final ConcurrentHashMap<Pair<String, String>, DataBatches> batchesMap = JavaUtils.newConcurrentHashMap();

    public PushState(CelebornConf conf) {
        this.pushBufferMaxSize = conf.clientPushBufferMaxSize();
        this.inFlightRequestTracker = new InFlightRequestTracker(conf, this);
    }

    public void cleanup() {
        this.inFlightRequestTracker.cleanup();
    }

    public boolean addBatchData(Pair<String, String> addressPair, PartitionLocation loc, int batchId, byte[] body) {
        DataBatches batches = this.batchesMap.computeIfAbsent(addressPair, s -> new DataBatches());
        batches.addDataBatch(loc, batchId, body);
        return batches.getTotalSize() > this.pushBufferMaxSize;
    }

    public DataBatches takeDataBatches(Pair<String, String> addressPair) {
        return this.batchesMap.remove(addressPair);
    }

    public int nextBatchId() {
        return this.inFlightRequestTracker.nextBatchId();
    }

    public void addBatch(int batchId, String hostAndPushPort) {
        this.inFlightRequestTracker.addBatch(batchId, hostAndPushPort);
    }

    public void removeBatch(int batchId, String hostAndPushPort) {
        this.inFlightRequestTracker.removeBatch(batchId, hostAndPushPort);
    }

    public void onSuccess(String hostAndPushPort) {
        this.inFlightRequestTracker.onSuccess(hostAndPushPort);
    }

    public void onCongestControl(String hostAndPushPort) {
        this.inFlightRequestTracker.onCongestControl(hostAndPushPort);
    }

    public boolean limitMaxInFlight(String hostAndPushPort) throws IOException {
        return this.inFlightRequestTracker.limitMaxInFlight(hostAndPushPort);
    }

    public boolean limitZeroInFlight() throws IOException {
        return this.inFlightRequestTracker.limitZeroInFlight();
    }

    public int remainingAllowPushes(String hostAndPushPort) {
        return this.inFlightRequestTracker.remainingAllowPushes(hostAndPushPort);
    }
}

