/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import java.util.concurrent.atomic.LongAdder;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.reflect.DynConstructors;
import org.apache.celeborn.reflect.DynFields;
import org.apache.celeborn.reflect.DynMethods;
import org.apache.spark.BarrierTaskContext;
import org.apache.spark.MapOutputTrackerMaster;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.MapStatus$;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.shuffle.ShuffleReadMetricsReporter;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.shuffle.celeborn.CelebornShuffleHandle;
import org.apache.spark.shuffle.celeborn.CelebornShuffleReader;
import org.apache.spark.shuffle.celeborn.ExecutorShuffleIdTracker;
import org.apache.spark.shuffle.celeborn.HashBasedShuffleWriter;
import org.apache.spark.shuffle.celeborn.SendBufferPool;
import org.apache.spark.shuffle.sort.SortShuffleManager;
import org.apache.spark.sql.execution.UnsafeRowSerializer;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.storage.BlockManagerId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SparkUtils.class);
    public static final String FETCH_FAILURE_ERROR_MSG = "Celeborn FetchFailure appShuffleId/shuffleId: ";
    private static final DynFields.UnboundField<SQLMetric> DATA_SIZE_METRIC_FIELD = DynFields.builder().hiddenImpl(UnsafeRowSerializer.class, "dataSize").defaultAlwaysNull().build();
    private static final DynMethods.UnboundMethod GET_READER_METHOD = DynMethods.builder("getReader").impl(SortShuffleManager.class, ShuffleHandle.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, TaskContext.class, ShuffleReadMetricsReporter.class).orNoop().build();
    private static final DynMethods.UnboundMethod LEGACY_GET_READER_METHOD = DynMethods.builder("getReader").impl(SortShuffleManager.class, ShuffleHandle.class, Integer.TYPE, Integer.TYPE, TaskContext.class, ShuffleReadMetricsReporter.class).orNoop().build();
    public static final String COLUMNAR_HASH_BASED_SHUFFLE_WRITER_CLASS = "org.apache.spark.shuffle.celeborn.ColumnarHashBasedShuffleWriter";
    static final DynConstructors.Builder COLUMNAR_HASH_BASED_SHUFFLE_WRITER_CONSTRUCTOR_BUILDER = DynConstructors.builder().impl("org.apache.spark.shuffle.celeborn.ColumnarHashBasedShuffleWriter", Integer.TYPE, CelebornShuffleHandle.class, TaskContext.class, CelebornConf.class, ShuffleClient.class, ShuffleWriteMetricsReporter.class, SendBufferPool.class);
    public static final String COLUMNAR_SHUFFLE_READER_CLASS = "org.apache.spark.shuffle.celeborn.CelebornColumnarShuffleReader";
    static final DynConstructors.Builder COLUMNAR_SHUFFLE_READER_CONSTRUCTOR_BUILDER = DynConstructors.builder().impl("org.apache.spark.shuffle.celeborn.CelebornColumnarShuffleReader", CelebornShuffleHandle.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, TaskContext.class, CelebornConf.class, ShuffleReadMetricsReporter.class, ExecutorShuffleIdTracker.class);
    private static final DynMethods.UnboundMethod UnregisterAllMapAndMergeOutput_METHOD = DynMethods.builder("unregisterAllMapAndMergeOutput").impl(MapOutputTrackerMaster.class, Integer.TYPE).orNoop().build();
    private static final DynMethods.UnboundMethod UnregisterAllMapOutput_METHOD = DynMethods.builder("unregisterAllMapOutput").impl(MapOutputTrackerMaster.class, Integer.TYPE).orNoop().build();

    public static MapStatus createMapStatus(BlockManagerId loc, long[] uncompressedSizes, long mapTaskId) {
        return MapStatus$.MODULE$.apply(loc, uncompressedSizes, mapTaskId);
    }

    public static SQLMetric getDataSize(UnsafeRowSerializer serializer) {
        SQLMetric dataSizeMetric = DATA_SIZE_METRIC_FIELD.get(serializer);
        if (dataSizeMetric == null) {
            LOG.warn("Failed to get dataSize metric, AQE won't work properly.");
        }
        return dataSizeMetric;
    }

    public static long[] unwrap(LongAdder[] adders) {
        int adderCounter = adders.length;
        long[] res = new long[adderCounter];
        for (int i = 0; i < adderCounter; ++i) {
            res[i] = adders[i].longValue();
        }
        return res;
    }

    public static CelebornConf fromSparkConf(SparkConf conf) {
        CelebornConf tmpCelebornConf = new CelebornConf();
        for (Tuple2 kv : conf.getAll()) {
            if (!((String)kv._1).startsWith("spark.celeborn.")) continue;
            tmpCelebornConf.set(((String)kv._1).substring("spark.".length()), (String)kv._2);
        }
        return tmpCelebornConf;
    }

    public static String appUniqueId(SparkContext context) {
        return (String)context.applicationAttemptId().map(id -> context.applicationId() + "_" + id).getOrElse(() -> ((SparkContext)context).applicationId());
    }

    public static String getAppShuffleIdentifier(int appShuffleId, TaskContext context) {
        return appShuffleId + "-" + context.stageId() + "-" + context.stageAttemptNumber();
    }

    public static int celebornShuffleId(ShuffleClient client, CelebornShuffleHandle<?, ?, ?> handle, TaskContext context, Boolean isWriter) {
        if (handle.throwsFetchFailure()) {
            String appShuffleIdentifier = SparkUtils.getAppShuffleIdentifier(handle.shuffleId(), context);
            return client.getShuffleId(handle.shuffleId(), appShuffleIdentifier, isWriter, context instanceof BarrierTaskContext);
        }
        return handle.shuffleId();
    }

    public static <T> T instantiateClass(String className, SparkConf conf, Boolean isDriver) {
        DynConstructors.Ctor dynConstructor = DynConstructors.builder().impl(className, SparkConf.class, Boolean.TYPE).impl(className, SparkConf.class).impl(className, new Class[0]).build();
        return (T)dynConstructor.newInstance(conf, isDriver);
    }

    public static <K, C> ShuffleReader<K, C> getReader(SortShuffleManager sortShuffleManager, ShuffleHandle handle, Integer startPartition, Integer endPartition, Integer startMapIndex, Integer endMapIndex, TaskContext context, ShuffleReadMetricsReporter metrics) {
        ShuffleReader shuffleReader = (ShuffleReader)GET_READER_METHOD.bind(sortShuffleManager).invoke(handle, startMapIndex, endMapIndex, startPartition, endPartition, context, metrics);
        if (shuffleReader != null) {
            return shuffleReader;
        }
        shuffleReader = (ShuffleReader)LEGACY_GET_READER_METHOD.bind(sortShuffleManager).invoke(handle, startPartition, endPartition, context, metrics);
        assert (shuffleReader != null);
        return shuffleReader;
    }

    public static <K, V, C> HashBasedShuffleWriter<K, V, C> createColumnarHashBasedShuffleWriter(int shuffleId, CelebornShuffleHandle<K, V, C> handle, TaskContext taskContext, CelebornConf conf, ShuffleClient client, ShuffleWriteMetricsReporter metrics, SendBufferPool sendBufferPool) {
        return (HashBasedShuffleWriter)((Object)COLUMNAR_HASH_BASED_SHUFFLE_WRITER_CONSTRUCTOR_BUILDER.build().invoke(null, new Object[]{shuffleId, handle, taskContext, conf, client, metrics, sendBufferPool}));
    }

    public static <K, C> CelebornShuffleReader<K, C> createColumnarShuffleReader(CelebornShuffleHandle<K, ?, C> handle, int startPartition, int endPartition, int startMapIndex, int endMapIndex, TaskContext context, CelebornConf conf, ShuffleReadMetricsReporter metrics, ExecutorShuffleIdTracker shuffleIdTracker) {
        return (CelebornShuffleReader)COLUMNAR_SHUFFLE_READER_CONSTRUCTOR_BUILDER.build().invoke(null, new Object[]{handle, startPartition, endPartition, startMapIndex, endMapIndex, context, conf, metrics, shuffleIdTracker});
    }

    public static void unregisterAllMapOutput(MapOutputTrackerMaster mapOutputTracker, int shuffleId) {
        if (!UnregisterAllMapAndMergeOutput_METHOD.isNoop()) {
            UnregisterAllMapAndMergeOutput_METHOD.bind(mapOutputTracker).invoke(shuffleId);
            return;
        }
        if (!UnregisterAllMapOutput_METHOD.isNoop()) {
            UnregisterAllMapOutput_METHOD.bind(mapOutputTracker).invoke(shuffleId);
            return;
        }
        throw new UnsupportedOperationException("unexpected! neither methods unregisterAllMapAndMergeOutput/unregisterAllMapOutput are found in MapOutputTrackerMaster");
    }

    public static void addFailureListenerIfBarrierTask(ShuffleClient shuffleClient, TaskContext taskContext, CelebornShuffleHandle<?, ?, ?> handle) {
        if (!(taskContext instanceof BarrierTaskContext)) {
            return;
        }
        int appShuffleId = handle.shuffleId();
        String appShuffleIdentifier = SparkUtils.getAppShuffleIdentifier(appShuffleId, taskContext);
        BarrierTaskContext barrierContext = (BarrierTaskContext)taskContext;
        barrierContext.addTaskFailureListener((context, error) -> shuffleClient.reportBarrierTaskFailure(appShuffleId, appShuffleIdentifier));
    }
}

