/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.meta;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.WorkerInfo$;
import org.apache.celeborn.common.meta.WorkerStatus;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.quota.ResourceConsumption;
import org.apache.celeborn.common.quota.ResourceConsumption$;
import org.apache.celeborn.common.rpc.RpcEndpointRef;
import org.apache.celeborn.common.rpc.netty.NettyRpcEndpointRef;
import org.apache.celeborn.common.util.JavaUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tme\u0001B!C\u00015C\u0001\"\u0018\u0001\u0003\u0006\u0004%\tA\u0018\u0005\tU\u0002\u0011\t\u0011)A\u0005?\"A1\u000e\u0001BC\u0002\u0013\u0005A\u000e\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003n\u0011!\t\bA!b\u0001\n\u0003a\u0007\u0002\u0003:\u0001\u0005\u0003\u0005\u000b\u0011B7\t\u0011M\u0004!Q1A\u0005\u00021D\u0001\u0002\u001e\u0001\u0003\u0002\u0003\u0006I!\u001c\u0005\tk\u0002\u0011)\u0019!C\u0001Y\"Aa\u000f\u0001B\u0001B\u0003%Q\u000e\u0003\u0005x\u0001\t\u0015\r\u0011\"\u0001m\u0011!A\bA!A!\u0002\u0013i\u0007\u0002C=\u0001\u0005\u0003\u0005\u000b\u0011\u0002>\t\u0015\u00055\u0001A!A!\u0002\u0013\ty\u0001C\u0004\u0002*\u0001!\t!a\u000b\t\u0013\u0005}\u0002\u00011A\u0005\u0002\u0005\u0005\u0003\"CA'\u0001\u0001\u0007I\u0011AA(\u0011!\tY\u0006\u0001Q!\n\u0005\r\u0003\"CA/\u0001\u0001\u0007I\u0011AA0\u0011%\t9\u0007\u0001a\u0001\n\u0003\tI\u0007\u0003\u0005\u0002n\u0001\u0001\u000b\u0015BA1\u0011%\ty\u0007\u0001a\u0001\n\u0003\t\t\bC\u0005\u0002z\u0001\u0001\r\u0011\"\u0001\u0002|!A\u0011q\u0010\u0001!B\u0013\t\u0019\bC\u0005\u0002\u0002\u0002\u0011\r\u0011\"\u0001\u0002\u0004\"A\u0011\u0011\u0013\u0001!\u0002\u0013\t)\tC\u0005\u0002\u0014\u0002\u0011\r\u0011\"\u0001\u0002\u0016\"A\u0011\u0011\u0014\u0001!\u0002\u0013\t9\nC\u0005\u0002\u001c\u0002\u0001\r\u0011\"\u0001\u0002\u001e\"I\u00111\u0016\u0001A\u0002\u0013\u0005\u0011Q\u0016\u0005\t\u0003c\u0003\u0001\u0015)\u0003\u0002 \"9\u0011\u0011\u0006\u0001\u0005\u0002\u0005M\u0006bBA\u0015\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0003\u001b\u0004A\u0011AAh\u0011\u001d\t9\u000e\u0001C\u0001\u00033Dq!a7\u0001\t\u0003\ti\u000eC\u0004\u0002p\u0002!\t!!=\t\u000f\u0005=\b\u0001\"\u0001\u0002z\"9\u0011Q \u0001\u0005\u0002\u0005}\bb\u0002B\u0004\u0001\u0011\u0005\u0011q \u0005\b\u0005\u0013\u0001A\u0011\u0001B\u0006\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0005'AqA!\u0007\u0001\t\u0003\u0011Y\u0002C\u0004\u0003\u001e\u0001!\tAa\u0007\t\u000f\t}\u0001\u0001\"\u0001\u0003\"!9!1\u0005\u0001\u0005\u0002\u0005e\u0007b\u0002B\u0013\u0001\u0011\u0005!q\u0005\u0005\b\u0005S\u0001A\u0011\u0001B\u0016\u0011\u001d\u0011y\u0003\u0001C\u0001\u0005cAqAa\u000e\u0001\t\u0003\tI\u000eC\u0004\u0003:\u0001!\t!!7\t\u000f\tm\u0002\u0001\"\u0001\u0002Z\"9!Q\b\u0001\u0005\u0002\t}\u0002\"\u0003B'\u0001E\u0005I\u0011\u0001B(\u0011\u001d\u0011)\u0007\u0001C\u0001\u0005OBqA!\u001c\u0001\t\u0003\u0012Y\u0002C\u0004\u0003p\u0001!\tE!\u001d\t\u000f\tm\u0004\u0001\"\u0011\u0003~!9!q\u0010\u0001\u0005\u0002\t\u0005ra\u0002BA\u0005\"\u0005!1\u0011\u0004\u0007\u0003\nC\tA!\"\t\u000f\u0005%R\b\"\u0001\u0003\b\"9!\u0011R\u001f\u0005\u0002\t-\u0005\"\u0003BI{\u0005\u0005I\u0011\u0002BJ\u0005)9vN]6fe&sgm\u001c\u0006\u0003\u0007\u0012\u000bA!\\3uC*\u0011QIR\u0001\u0007G>lWn\u001c8\u000b\u0005\u001dC\u0015\u0001C2fY\u0016\u0014wN\u001d8\u000b\u0005%S\u0015AB1qC\u000eDWMC\u0001L\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\nV,\u0011\u0005=\u0013V\"\u0001)\u000b\u0003E\u000bQa]2bY\u0006L!a\u0015)\u0003\r\u0005s\u0017PU3g!\tyU+\u0003\u0002W!\na1+\u001a:jC2L'0\u00192mKB\u0011\u0001lW\u0007\u00023*\u0011!\fR\u0001\tS:$XM\u001d8bY&\u0011A,\u0017\u0002\b\u0019><w-\u001b8h\u0003\u0011Awn\u001d;\u0016\u0003}\u0003\"\u0001Y4\u000f\u0005\u0005,\u0007C\u00012Q\u001b\u0005\u0019'B\u00013M\u0003\u0019a$o\\8u}%\u0011a\rU\u0001\u0007!J,G-\u001a4\n\u0005!L'AB*ue&twM\u0003\u0002g!\u0006)\u0001n\\:uA\u00059!\u000f]2Q_J$X#A7\u0011\u0005=s\u0017BA8Q\u0005\rIe\u000e^\u0001\teB\u001c\u0007k\u001c:uA\u0005A\u0001/^:i!>\u0014H/A\u0005qkND\u0007k\u001c:uA\u0005Ia-\u001a;dQB{'\u000f^\u0001\u000bM\u0016$8\r\u001b)peR\u0004\u0013!\u0004:fa2L7-\u0019;f!>\u0014H/\u0001\bsKBd\u0017nY1uKB{'\u000f\u001e\u0011\u0002\u0019%tG/\u001a:oC2\u0004vN\u001d;\u0002\u001b%tG/\u001a:oC2\u0004vN\u001d;!\u0003)yF-[:l\u0013:4wn\u001d\t\u0007w\u0006\u0005q,!\u0002\u000e\u0003qT!! @\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u007f\u0006!!.\u0019<b\u0013\r\t\u0019\u0001 \u0002\u0004\u001b\u0006\u0004\b\u0003BA\u0004\u0003\u0013i\u0011AQ\u0005\u0004\u0003\u0017\u0011%\u0001\u0003#jg.LeNZ8\u00021}+8/\u001a:SKN|WO]2f\u0007>t7/^7qi&|g\u000eE\u0004|\u0003\u0003\t\t\"!\b\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006E\u0003!IG-\u001a8uSRL\u0018\u0002BA\u000e\u0003+\u0011a\"V:fe&#WM\u001c;jM&,'\u000f\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019\u0003R\u0001\u0006cV|G/Y\u0005\u0005\u0003O\t\tCA\nSKN|WO]2f\u0007>t7/^7qi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0013\u0003[\ty#!\r\u00024\u0005U\u0012qGA\u001d\u0003w\ti\u0004E\u0002\u0002\b\u0001AQ!X\bA\u0002}CQa[\bA\u00025DQ!]\bA\u00025DQa]\bA\u00025DQ!^\bA\u00025DQa^\bA\u00025DQ!_\bA\u0002iDq!!\u0004\u0010\u0001\u0004\ty!A\boKR<xN]6M_\u000e\fG/[8o+\t\t\u0019\u0005\u0005\u0003\u0002F\u0005-SBAA$\u0015\r\tIE`\u0001\u0005Y\u0006tw-C\u0002i\u0003\u000f\n1C\\3uo>\u00148\u000eT8dCRLwN\\0%KF$B!!\u0015\u0002XA\u0019q*a\u0015\n\u0007\u0005U\u0003K\u0001\u0003V]&$\b\"CA-#\u0005\u0005\t\u0019AA\"\u0003\rAH%M\u0001\u0011]\u0016$xo\u001c:l\u0019>\u001c\u0017\r^5p]\u0002\nQ\u0002\\1ti\"+\u0017M\u001d;cK\u0006$XCAA1!\ry\u00151M\u0005\u0004\u0003K\u0002&\u0001\u0002'p]\u001e\f\u0011\u0003\\1ti\"+\u0017M\u001d;cK\u0006$x\fJ3r)\u0011\t\t&a\u001b\t\u0013\u0005eC#!AA\u0002\u0005\u0005\u0014A\u00047bgRDU-\u0019:uE\u0016\fG\u000fI\u0001\ro>\u00148.\u001a:Ti\u0006$Xo]\u000b\u0003\u0003g\u0002B!a\u0002\u0002v%\u0019\u0011q\u000f\"\u0003\u0019]{'o[3s'R\fG/^:\u0002!]|'o[3s'R\fG/^:`I\u0015\fH\u0003BA)\u0003{B\u0011\"!\u0017\u0018\u0003\u0003\u0005\r!a\u001d\u0002\u001b]|'o[3s'R\fG/^:!\u0003%!\u0017n]6J]\u001a|7/\u0006\u0002\u0002\u0006B9\u0011qQAG?\u0006\u0015QBAAE\u0015\r\tY\t`\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BAH\u0003\u0013\u0013\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q\u0003)!\u0017n]6J]\u001a|7\u000fI\u0001\u0018kN,'OU3t_V\u00148-Z\"p]N,X\u000e\u001d;j_:,\"!a&\u0011\u0011\u0005\u001d\u0015QRA\t\u0003;\t\u0001$^:feJ+7o\\;sG\u0016\u001cuN\\:v[B$\u0018n\u001c8!\u0003!)g\u000e\u001a9pS:$XCAAP!\u0011\t\t+a*\u000e\u0005\u0005\r&bAAS\t\u0006\u0019!\u000f]2\n\t\u0005%\u00161\u0015\u0002\u000f%B\u001cWI\u001c3q_&tGOU3g\u00031)g\u000e\u001a9pS:$x\fJ3r)\u0011\t\t&a,\t\u0013\u0005ec$!AA\u0002\u0005}\u0015!C3oIB|\u0017N\u001c;!)1\ti#!.\u00028\u0006e\u00161XA_\u0011\u0015i\u0006\u00051\u0001`\u0011\u0015Y\u0007\u00051\u0001n\u0011\u0015\t\b\u00051\u0001n\u0011\u0015\u0019\b\u00051\u0001n\u0011\u0015)\b\u00051\u0001n)9\ti#!1\u0002D\u0006\u0015\u0017qYAe\u0003\u0017DQ!X\u0011A\u0002}CQa[\u0011A\u00025DQ!]\u0011A\u00025DQa]\u0011A\u00025DQ!^\u0011A\u00025DQa^\u0011A\u00025\f\u0001\"[:BGRLg/Z\u000b\u0003\u0003#\u00042aTAj\u0013\r\t)\u000e\u0015\u0002\b\u0005>|G.Z1o\u0003%)8/\u001a3TY>$8\u000f\u0006\u0002\u0002b\u0005i\u0011\r\u001c7pG\u0006$Xm\u00157piN$b!!\u0015\u0002`\u0006\r\bBBAqI\u0001\u0007q,\u0001\u0006tQV4g\r\\3LKfDq!!:%\u0001\u0004\t9/\u0001\u0007tY>$8\u000fU3s\t&\u001c8\u000e\u0005\u0004|\u0003\u0003y\u0016\u0011\u001e\t\u0005\u0003\u000b\nY/\u0003\u0003\u0002n\u0006\u001d#aB%oi\u0016<WM]\u0001\re\u0016dW-Y:f'2|Go\u001d\u000b\u0007\u0003#\n\u00190!>\t\r\u0005\u0005X\u00051\u0001`\u0011\u001d\t90\na\u0001\u0003O\fQa\u001d7piN$B!!\u0015\u0002|\"1\u0011\u0011\u001d\u0014A\u0002}\u000b\u0001cZ3u'\",hM\u001a7f\u0017\u0016L8+\u001a;\u0016\u0005\t\u0005\u0001\u0003B>\u0003\u0004}K1A!\u0002}\u0005\u001dA\u0015m\u001d5TKR\f1cZ3u\u0003B\u0004H.[2bi&|g.\u00133TKR\fq\u0002[1t'\u0006lW-\u00138g_^KG\u000f\u001b\u000b\u0005\u0003#\u0014i\u0001C\u0004\u0003\u0010%\u0002\r!!\f\u0002\u000b=$\b.\u001a:\u0002\u001bM,G/\u001e9F]\u0012\u0004x.\u001b8u)\u0011\t\tF!\u0006\t\u000f\t]!\u00061\u0001\u0002 \u0006YQM\u001c3q_&tGOU3g\u0003=\u0011X-\u00193bE2,\u0017\t\u001a3sKN\u001cH#A0\u0002\u0015Q|WK\\5rk\u0016LE-A\u0007tY>$\u0018I^1jY\u0006\u0014G.\u001a\u000b\u0003\u0003#\fQbZ3u)>$\u0018\r\\*m_R\u001c\u0018aD4fi^{'o[3s'R\fG/^:\u0015\u0005\u0005M\u0014aD:fi^{'o[3s'R\fG/^:\u0015\t\u0005E#Q\u0006\u0005\b\u0003_\u0002\u0004\u0019AA:\u0003I)\b\u000fZ1uK\u0012K7o['bqNcw\u000e^:\u0015\t\u0005E#1\u0007\u0005\b\u0005k\t\u0004\u0019AA1\u0003Y)7\u000f^5nCR,G\rU1si&$\u0018n\u001c8TSj,\u0017a\u0005;pi\u0006d\u0017I^1jY\u0006\u0014G.Z*m_R\u001c\u0018A\u0003;pi\u0006d7\u000b]1dK\u00061Bo\u001c;bY\u0006\u001bG/^1m+N\f'\r\\3Ta\u0006\u001cW-\u0001\fva\u0012\fG/\u001a+iK:<U\r\u001e#jg.LeNZ8t)\u0015Q(\u0011\tB#\u0011\u0019\u0011\u0019%\u000ea\u0001u\u0006aa.Z<ESN\\\u0017J\u001c4pg\"I!QG\u001b\u0011\u0002\u0003\u0007!q\t\t\u0006\u001f\n%\u0013\u0011M\u0005\u0004\u0005\u0017\u0002&AB(qi&|g.\u0001\u0011va\u0012\fG/\u001a+iK:<U\r\u001e#jg.LeNZ8tI\u0011,g-Y;mi\u0012\u0012TC\u0001B)U\u0011\u00119Ea\u0015,\u0005\tU\u0003\u0003\u0002B,\u0005Cj!A!\u0017\u000b\t\tm#QL\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0018Q\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005G\u0012IFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fA%\u001e9eCR,G\u000b[3o\u000f\u0016$Xk]3s%\u0016\u001cx.\u001e:dK\u000e{gn];naRLwN\u001c\u000b\u0005\u0003\u001f\u0011I\u0007C\u0004\u0003l]\u0002\r!a\u0004\u0002)I,7o\\;sG\u0016\u001cuN\\:v[B$\u0018n\u001c8t\u0003!!xn\u0015;sS:<\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002R\nM\u0004b\u0002B\bs\u0001\u0007!Q\u000f\t\u0004\u001f\n]\u0014b\u0001B=!\n\u0019\u0011I\\=\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012!\\\u0001\tQ\u00064X\rR5tW\u0006Qqk\u001c:lKJLeNZ8\u0011\u0007\u0005\u001dQhE\u0002>\u001dR#\"Aa!\u0002\u0019\u0019\u0014x.\\+oSF,X-\u00133\u0015\t\u00055\"Q\u0012\u0005\u0007\u0005\u001f{\u0004\u0019A0\u0002\u0005%$\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!&\u0011\t\u0005\u0015#qS\u0005\u0005\u00053\u000b9E\u0001\u0004PE*,7\r\u001e")
public class WorkerInfo
implements scala.Serializable,
Logging {
    private final String host;
    private final int rpcPort;
    private final int pushPort;
    private final int fetchPort;
    private final int replicatePort;
    private final int internalPort;
    private String networkLocation;
    private long lastHeartbeat;
    private WorkerStatus workerStatus;
    private final ConcurrentHashMap<String, DiskInfo> diskInfos;
    private final ConcurrentHashMap<UserIdentifier, ResourceConsumption> userResourceConsumption;
    private RpcEndpointRef endpoint;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public static WorkerInfo fromUniqueId(String string) {
        return WorkerInfo$.MODULE$.fromUniqueId(string);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        WorkerInfo workerInfo = this;
        synchronized (workerInfo) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public String host() {
        return this.host;
    }

    public int rpcPort() {
        return this.rpcPort;
    }

    public int pushPort() {
        return this.pushPort;
    }

    public int fetchPort() {
        return this.fetchPort;
    }

    public int replicatePort() {
        return this.replicatePort;
    }

    public int internalPort() {
        return this.internalPort;
    }

    public String networkLocation() {
        return this.networkLocation;
    }

    public void networkLocation_$eq(String x$1) {
        this.networkLocation = x$1;
    }

    public long lastHeartbeat() {
        return this.lastHeartbeat;
    }

    public void lastHeartbeat_$eq(long x$1) {
        this.lastHeartbeat = x$1;
    }

    public WorkerStatus workerStatus() {
        return this.workerStatus;
    }

    public void workerStatus_$eq(WorkerStatus x$1) {
        this.workerStatus = x$1;
    }

    public ConcurrentHashMap<String, DiskInfo> diskInfos() {
        return this.diskInfos;
    }

    public ConcurrentHashMap<UserIdentifier, ResourceConsumption> userResourceConsumption() {
        return this.userResourceConsumption;
    }

    public RpcEndpointRef endpoint() {
        return this.endpoint;
    }

    public void endpoint_$eq(RpcEndpointRef x$1) {
        this.endpoint = x$1;
    }

    public boolean isActive() {
        return ((NettyRpcEndpointRef)this.endpoint()).client().isActive();
    }

    public synchronized long usedSlots() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)WorkerInfo.$anonfun$usedSlots$1(x$1)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public void allocateSlots(String shuffleKey, Map<String, Integer> slotsPerDisk) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Shuffle ").append(shuffleKey).append(", allocations ").append(slotsPerDisk).toString());
        WorkerInfo workerInfo = this;
        synchronized (workerInfo) {
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(slotsPerDisk).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                WorkerInfo.$anonfun$allocateSlots$2(this, shuffleKey, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public synchronized void releaseSlots(String shuffleKey, Map<String, Integer> slots) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(slots).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            WorkerInfo.$anonfun$releaseSlots$1(this, shuffleKey, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void releaseSlots(String shuffleKey) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            WorkerInfo.$anonfun$releaseSlots$2(shuffleKey, x$2);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized HashSet<String> getShuffleKeySet() {
        HashSet<String> shuffleKeySet = new HashSet<String>();
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.diskInfos().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)diskInfo -> BoxesRunTime.boxToBoolean((boolean)shuffleKeySet.addAll(diskInfo.getShuffleKeySet())));
        return shuffleKeySet;
    }

    public synchronized HashSet<String> getApplicationIdSet() {
        HashSet<String> applicationIdSet = new HashSet<String>();
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.diskInfos().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)diskInfo -> BoxesRunTime.boxToBoolean((boolean)applicationIdSet.addAll(diskInfo.getApplicationIdSet())));
        return applicationIdSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasSameInfoWith(WorkerInfo other) {
        if (this.rpcPort() != other.rpcPort()) return false;
        if (this.pushPort() != other.pushPort()) return false;
        String string = this.host();
        String string2 = other.host();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.fetchPort() != other.fetchPort()) return false;
        if (this.replicatePort() != other.replicatePort()) return false;
        return true;
    }

    public void setupEndpoint(RpcEndpointRef endpointRef) {
        if (this.endpoint() == null) {
            this.endpoint_$eq(endpointRef);
            return;
        }
    }

    public String readableAddress() {
        return new StringBuilder(50).append("Host:").append(this.host()).append(":RpcPort:").append(this.rpcPort()).append(":PushPort:").append(this.pushPort()).append(":").append("FetchPort:").append(this.fetchPort()).append(":ReplicatePort:").append(this.replicatePort()).append((Object)(this.internalPort() > 0 ? new StringBuilder(14).append(":InternalPort:").append(this.internalPort()).toString() : "")).toString();
    }

    public String toUniqueId() {
        return new StringBuilder(4).append(this.host()).append(":").append(this.rpcPort()).append(":").append(this.pushPort()).append(":").append(this.fetchPort()).append(":").append(this.replicatePort()).toString();
    }

    public synchronized boolean slotAvailable() {
        return ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)WorkerInfo.$anonfun$slotAvailable$1(x0$1)));
    }

    public synchronized long getTotalSlots() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)WorkerInfo.$anonfun$getTotalSlots$1(x$3)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public WorkerStatus getWorkerStatus() {
        return this.workerStatus();
    }

    public void setWorkerStatus(WorkerStatus workerStatus) {
        this.workerStatus_$eq(workerStatus);
    }

    public synchronized void updateDiskMaxSlots(long estimatedPartitionSize) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            WorkerInfo.$anonfun$updateDiskMaxSlots$1(estimatedPartitionSize, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized long totalAvailableSlots() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)WorkerInfo.$anonfun$totalAvailableSlots$1(x$4)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public synchronized long totalSpace() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)WorkerInfo.$anonfun$totalSpace$1(x$5)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public synchronized long totalActualUsableSpace() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)WorkerInfo.$anonfun$totalActualUsableSpace$1(x$6)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public synchronized Map<String, DiskInfo> updateThenGetDiskInfos(Map<String, DiskInfo> newDiskInfos, Option<Object> estimatedPartitionSize) {
        block0: {
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(newDiskInfos.values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)newDisk -> {
                String mountPoint;
                block4: {
                    mountPoint = newDisk.mountPoint();
                    DiskInfo curDisk = this.diskInfos().get(mountPoint);
                    if (curDisk != null) {
                        curDisk.actualUsableSpace_$eq(newDisk.actualUsableSpace());
                        curDisk.totalSpace_$eq(newDisk.totalSpace());
                        curDisk.activeSlots_$eq(newDisk.activeSlots());
                        curDisk.avgFlushTime_$eq(newDisk.avgFlushTime());
                        curDisk.avgFetchTime_$eq(newDisk.avgFetchTime());
                        if (estimatedPartitionSize.nonEmpty()) {
                            StorageInfo.Type type = curDisk.storageType();
                            StorageInfo.Type type2 = StorageInfo.Type.HDFS;
                            if (type == null ? type2 != null : !((Object)((Object)type)).equals((Object)type2)) {
                                curDisk.maxSlots_$eq(curDisk.actualUsableSpace() / BoxesRunTime.unboxToLong((Object)estimatedPartitionSize.get()));
                            }
                        }
                        return curDisk.setStatus(newDisk.status());
                    }
                    if (!estimatedPartitionSize.nonEmpty()) break block4;
                    StorageInfo.Type type = newDisk.storageType();
                    StorageInfo.Type type3 = StorageInfo.Type.HDFS;
                    if (type == null ? type3 != null : !((Object)((Object)type)).equals((Object)type3)) {
                        newDisk.maxSlots_$eq(newDisk.actualUsableSpace() / BoxesRunTime.unboxToLong((Object)estimatedPartitionSize.get()));
                    }
                }
                return this.diskInfos().put(mountPoint, (DiskInfo)newDisk);
            });
            HashSet nonExistsMountPoints = new HashSet();
            nonExistsMountPoints.addAll(this.diskInfos().keySet());
            nonExistsMountPoints.removeAll(newDiskInfos.keySet());
            if (nonExistsMountPoints.isEmpty()) break block0;
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(nonExistsMountPoints).asScala()).foreach((Function1 & Serializable & scala.Serializable)nonExistsMountPoint -> this.diskInfos().remove(nonExistsMountPoint));
        }
        return JavaUtils.newConcurrentHashMap(this.diskInfos());
    }

    public Option<Object> updateThenGetDiskInfos$default$2() {
        return None$.MODULE$;
    }

    public Map<UserIdentifier, ResourceConsumption> updateThenGetUserResourceConsumption(Map<UserIdentifier, ResourceConsumption> resourceConsumptions) {
        ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(this.userResourceConsumption().keys()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)resourceConsumptions.containsKey(x$1))).foreach((Function1 & Serializable & scala.Serializable)identifier -> this.userResourceConsumption().put((UserIdentifier)identifier, new ResourceConsumption(0L, 0L, 0L, 0L, ResourceConsumption$.MODULE$.apply$default$5())));
        this.userResourceConsumption().putAll(resourceConsumptions);
        return this.userResourceConsumption();
    }

    public String toString() {
        Tuple2 tuple2;
        Tuple2 tuple22;
        if (this.diskInfos() == null || this.diskInfos().isEmpty()) {
            tuple22 = new Tuple2((Object)"empty", (Object)BoxesRunTime.boxToInteger((int)0));
        } else if (this.diskInfos() != null) {
            String str = ((TraversableOnce)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.diskInfos().values()).asScala()).zipWithIndex(scala.collection.Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    DiskInfo diskInfo = (DiskInfo)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    return new StringBuilder(13).append("\n  DiskInfo").append(index).append(": ").append(diskInfo).toString();
                }
                throw new MatchError((Object)tuple2);
            }, scala.collection.Iterable$.MODULE$.canBuildFrom())).mkString("");
            tuple22 = new Tuple2((Object)str, (Object)BoxesRunTime.boxToLong((long)this.usedSlots()));
        } else {
            tuple22 = tuple2 = BoxedUnit.UNIT;
        }
        if (!(tuple2 instanceof Tuple2)) {
            throw new MatchError((Object)tuple2);
        }
        Tuple2 tuple23 = tuple2;
        Object diskInfosString = tuple23._1();
        Object slots = tuple23._2();
        Tuple2 tuple24 = new Tuple2(diskInfosString, slots);
        Object diskInfosString2 = tuple24._1();
        Object slots2 = tuple24._2();
        String userResourceConsumptionString = this.userResourceConsumption() == null || this.userResourceConsumption().isEmpty() ? "empty" : (this.userResourceConsumption() != null ? ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.userResourceConsumption()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                UserIdentifier userIdentifier = (UserIdentifier)tuple2._1();
                ResourceConsumption resourceConsumption = (ResourceConsumption)tuple2._2();
                return new StringBuilder(42).append("\n  UserIdentifier: ").append(userIdentifier).append(", ResourceConsumption: ").append(resourceConsumption).toString();
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).mkString("") : BoxedUnit.UNIT);
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(325).append("\n       |Host: ").append(this.host()).append("\n       |RpcPort: ").append(this.rpcPort()).append("\n       |PushPort: ").append(this.pushPort()).append("\n       |FetchPort: ").append(this.fetchPort()).append("\n       |ReplicatePort: ").append(this.replicatePort()).append("\n       |InternalPort: ").append(this.internalPort()).append("\n       |SlotsUsed: ").append(slots2).append("\n       |LastHeartbeat: ").append(this.lastHeartbeat()).append("\n       |HeartbeatElapsedSeconds: ").append(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.lastHeartbeat())).append("\n       |Disks: ").append(diskInfosString2).append("\n       |UserResourceConsumption: ").append((Object)userResourceConsumptionString).append("\n       |WorkerRef: ").append(this.endpoint()).append("\n       |WorkerStatus: ").append(this.workerStatus()).append("\n       |NetworkLocation: ").append(this.networkLocation()).append("\n       |").toString())).stripMargin();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof WorkerInfo)) return false;
        WorkerInfo workerInfo = (WorkerInfo)object;
        String string = this.host();
        String string2 = workerInfo.host();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.rpcPort() != workerInfo.rpcPort()) return false;
        if (this.pushPort() != workerInfo.pushPort()) return false;
        if (this.fetchPort() != workerInfo.fetchPort()) return false;
        if (this.replicatePort() != workerInfo.replicatePort()) return false;
        return true;
    }

    public int hashCode() {
        int result = this.host().hashCode();
        result = 31 * result + Integer.hashCode(this.rpcPort());
        result = 31 * result + Integer.hashCode(this.pushPort());
        result = 31 * result + Integer.hashCode(this.fetchPort());
        result = 31 * result + Integer.hashCode(this.replicatePort());
        return result;
    }

    public boolean haveDisk() {
        return ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.diskInfos().values()).asScala()).exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)WorkerInfo.$anonfun$haveDisk$1(p)));
    }

    public static final /* synthetic */ long $anonfun$usedSlots$1(Tuple2 x$1) {
        return ((DiskInfo)x$1._2()).activeSlots();
    }

    public static final /* synthetic */ void $anonfun$allocateSlots$2(WorkerInfo $this, String shuffleKey$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String disk = (String)tuple2._1();
            Integer slots = (Integer)tuple2._2();
            DiskInfo diskInfo = $this.diskInfos().get(disk);
            if (diskInfo == null) {
                $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Unknown disk ").append(disk).append(" when allocateSlots").toString());
                return;
            }
            diskInfo.allocateSlots(shuffleKey$1, Predef$.MODULE$.Integer2int(slots));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$releaseSlots$1(WorkerInfo $this, String shuffleKey$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String disk = (String)tuple2._1();
            Integer slot = (Integer)tuple2._2();
            if ($this.diskInfos().containsKey(disk)) {
                $this.diskInfos().get(disk).releaseSlots(shuffleKey$2, Predef$.MODULE$.Integer2int(slot));
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$releaseSlots$2(String shuffleKey$3, Tuple2 x$2) {
        ((DiskInfo)x$2._2()).releaseSlots(shuffleKey$3);
    }

    public static final /* synthetic */ boolean $anonfun$slotAvailable$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            DiskInfo disk = (DiskInfo)tuple2._2();
            return disk.maxSlots() - disk.activeSlots() > 0L;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$getTotalSlots$1(Tuple2 x$3) {
        return ((DiskInfo)x$3._2()).maxSlots();
    }

    public static final /* synthetic */ void $anonfun$updateDiskMaxSlots$1(long estimatedPartitionSize$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            DiskInfo disk = (DiskInfo)tuple2._2();
            disk.maxSlots_$eq(disk.actualUsableSpace() / estimatedPartitionSize$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$totalAvailableSlots$1(Tuple2 x$4) {
        return ((DiskInfo)x$4._2()).availableSlots();
    }

    public static final /* synthetic */ long $anonfun$totalSpace$1(Tuple2 x$5) {
        return ((DiskInfo)x$5._2()).totalSpace();
    }

    public static final /* synthetic */ long $anonfun$totalActualUsableSpace$1(Tuple2 x$6) {
        return ((DiskInfo)x$6._2()).actualUsableSpace();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$haveDisk$1(DiskInfo p) {
        StorageInfo.Type type = p.storageType();
        StorageInfo.Type type2 = StorageInfo.Type.SSD;
        if (type == null) {
            if (type2 == null) return true;
        } else if (((Object)((Object)type)).equals((Object)type2)) return true;
        StorageInfo.Type type3 = p.storageType();
        StorageInfo.Type type4 = StorageInfo.Type.HDD;
        if (type3 != null) {
            if (!((Object)((Object)type3)).equals((Object)type4)) return false;
            return true;
        }
        if (type4 == null) return true;
        return false;
    }

    public WorkerInfo(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, int internalPort, Map<String, DiskInfo> _diskInfos, Map<UserIdentifier, ResourceConsumption> _userResourceConsumption) {
        this.host = host;
        this.rpcPort = rpcPort;
        this.pushPort = pushPort;
        this.fetchPort = fetchPort;
        this.replicatePort = replicatePort;
        this.internalPort = internalPort;
        Logging.$init$(this);
        this.networkLocation = "/default-rack";
        this.lastHeartbeat = 0L;
        this.workerStatus = WorkerStatus.normalWorkerStatus();
        this.diskInfos = _diskInfos != null ? JavaUtils.newConcurrentHashMap(_diskInfos) : null;
        this.userResourceConsumption = _userResourceConsumption != null ? JavaUtils.newConcurrentHashMap(_userResourceConsumption) : null;
        this.endpoint = null;
    }

    public WorkerInfo(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort) {
        this(host, rpcPort, pushPort, fetchPort, replicatePort, -1, new HashMap<String, DiskInfo>(), new HashMap<UserIdentifier, ResourceConsumption>());
    }

    public WorkerInfo(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, int internalPort) {
        this(host, rpcPort, pushPort, fetchPort, replicatePort, internalPort, new HashMap<String, DiskInfo>(), new HashMap<UserIdentifier, ResourceConsumption>());
    }
}

