/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.plugin.flink.ShuffleResourceDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleTaskInfo {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleTaskInfo.class);
    private int currentShuffleIndex = 0;
    private ConcurrentHashMap<Integer, ConcurrentHashMap<Integer, AtomicInteger>> shuffleIdMapAttemptIdIndex = JavaUtils.newConcurrentHashMap();
    private ConcurrentHashMap<String, Integer> taskShuffleIdToShuffleId = JavaUtils.newConcurrentHashMap();
    private ConcurrentHashMap<Integer, String> shuffleIdToTaskShuffleId = JavaUtils.newConcurrentHashMap();
    private ConcurrentHashMap<Integer, AtomicInteger> shuffleIdPartitionIdIndex = JavaUtils.newConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getShuffleId(String taskShuffleId) {
        ConcurrentHashMap<String, Integer> concurrentHashMap = this.taskShuffleIdToShuffleId;
        synchronized (concurrentHashMap) {
            if (this.taskShuffleIdToShuffleId.containsKey(taskShuffleId)) {
                return this.taskShuffleIdToShuffleId.get(taskShuffleId);
            }
            this.taskShuffleIdToShuffleId.put(taskShuffleId, this.currentShuffleIndex);
            this.shuffleIdToTaskShuffleId.put(this.currentShuffleIndex, taskShuffleId);
            this.shuffleIdMapAttemptIdIndex.put(this.currentShuffleIndex, JavaUtils.newConcurrentHashMap());
            this.shuffleIdPartitionIdIndex.put(this.currentShuffleIndex, new AtomicInteger(0));
            int tempShuffleIndex = this.currentShuffleIndex++;
            return tempShuffleIndex;
        }
    }

    public int genAttemptId(int shuffleId, int mapId) {
        AtomicInteger currentAttemptIndex = this.shuffleIdMapAttemptIdIndex.get(shuffleId).computeIfAbsent(mapId, id -> new AtomicInteger(0));
        return currentAttemptIndex.getAndIncrement();
    }

    public int genPartitionId(int shuffleId) {
        return this.shuffleIdPartitionIdIndex.get(shuffleId).getAndIncrement();
    }

    public void removeExpiredShuffle(int shuffleId) {
        if (this.shuffleIdToTaskShuffleId.containsKey(shuffleId)) {
            this.shuffleIdPartitionIdIndex.remove(shuffleId);
            this.shuffleIdMapAttemptIdIndex.remove(shuffleId);
            String taskShuffleId = this.shuffleIdToTaskShuffleId.remove(shuffleId);
            this.taskShuffleIdToShuffleId.remove(taskShuffleId);
        }
    }

    public ShuffleResourceDescriptor genShuffleResourceDescriptor(String taskShuffleId, int mapId, String taskAttemptId) {
        int shuffleId = this.getShuffleId(taskShuffleId);
        int attemptId = this.genAttemptId(shuffleId, mapId);
        int partitionId = this.genPartitionId(shuffleId);
        LOG.info("Assign for ({}, {}, {}) resource ({}, {}, {}, {})", new Object[]{taskShuffleId, mapId, taskAttemptId, shuffleId, mapId, attemptId, partitionId});
        return new ShuffleResourceDescriptor(shuffleId, mapId, attemptId, partitionId);
    }
}

