/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.lang.management.ManagementFactory;
import java.util.function.Supplier;
import javax.management.JMException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxRegister {
    static final Logger LOG = LoggerFactory.getLogger(JmxRegister.class);
    private ObjectName registeredName;

    static ObjectName tryRegister(String name, Object mBean) {
        ObjectName objectName;
        try {
            objectName = new ObjectName(name);
            ManagementFactory.getPlatformMBeanServer().registerMBean(mBean, objectName);
        }
        catch (Exception e) {
            LOG.error("Failed to register JMX Bean with name " + name, (Throwable)e);
            return null;
        }
        LOG.info("Successfully registered JMX Bean with object name " + objectName);
        return objectName;
    }

    public synchronized String register(Object mBean, Iterable<Supplier<String>> names) {
        if (this.registeredName == null) {
            for (Supplier<String> supplier : names) {
                String name = supplier.get();
                this.registeredName = JmxRegister.tryRegister(name, mBean);
                if (this.registeredName == null) continue;
                return name;
            }
        }
        return null;
    }

    public synchronized boolean unregister() throws JMException {
        if (this.registeredName == null) {
            return false;
        }
        ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.registeredName);
        LOG.info("Successfully un-registered JMX Bean with object name " + this.registeredName);
        this.registeredName = null;
        return true;
    }
}

