/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink;

import java.io.IOException;
import java.util.function.Consumer;
import org.apache.celeborn.common.network.protocol.BacklogAnnouncement;
import org.apache.celeborn.common.network.protocol.BufferStreamEnd;
import org.apache.celeborn.common.network.protocol.RequestMessage;
import org.apache.celeborn.common.network.protocol.TransportableError;
import org.apache.celeborn.common.network.util.NettyUtils;
import org.apache.celeborn.common.protocol.PbReadAddCredit;
import org.apache.celeborn.plugin.flink.ShuffleResourceDescriptor;
import org.apache.celeborn.plugin.flink.buffer.CreditListener;
import org.apache.celeborn.plugin.flink.buffer.TransferBufferPool;
import org.apache.celeborn.plugin.flink.protocol.ReadData;
import org.apache.celeborn.plugin.flink.readclient.CelebornBufferStream;
import org.apache.celeborn.plugin.flink.readclient.FlinkShuffleClientImpl;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteBufferStreamReader
extends CreditListener {
    private static Logger logger = LoggerFactory.getLogger(RemoteBufferStreamReader.class);
    private TransferBufferPool bufferPool;
    private FlinkShuffleClientImpl client;
    private int shuffleId;
    private int partitionId;
    private int subPartitionIndexStart;
    private int subPartitionIndexEnd;
    private boolean isOpened;
    private Consumer<ByteBuf> dataListener;
    private Consumer<Throwable> failureListener;
    private CelebornBufferStream bufferStream;
    private volatile boolean closed = false;
    private Consumer<RequestMessage> messageConsumer;

    public RemoteBufferStreamReader(FlinkShuffleClientImpl client, ShuffleResourceDescriptor shuffleDescriptor, int startSubIdx, int endSubIdx, TransferBufferPool bufferPool, Consumer<ByteBuf> dataListener, Consumer<Throwable> failureListener) {
        this.client = client;
        this.shuffleId = shuffleDescriptor.getShuffleId();
        this.partitionId = shuffleDescriptor.getPartitionId();
        this.bufferPool = bufferPool;
        this.subPartitionIndexStart = startSubIdx;
        this.subPartitionIndexEnd = endSubIdx;
        this.dataListener = dataListener;
        this.failureListener = failureListener;
        this.messageConsumer = requestMessage -> {
            if (requestMessage instanceof ReadData) {
                this.dataReceived((ReadData)requestMessage);
            } else if (requestMessage instanceof BacklogAnnouncement) {
                this.backlogReceived(((BacklogAnnouncement)requestMessage).getBacklog());
            } else if (requestMessage instanceof TransportableError) {
                this.errorReceived(((TransportableError)requestMessage).getErrorMessage());
            } else if (requestMessage instanceof BufferStreamEnd) {
                this.onStreamEnd((BufferStreamEnd)requestMessage);
            }
        };
    }

    public void open(int initialCredit) {
        try {
            this.bufferStream = this.client.readBufferedPartition(this.shuffleId, this.partitionId, this.subPartitionIndexStart, this.subPartitionIndexEnd);
            this.bufferStream.open(this::requestBuffer, initialCredit, this.messageConsumer);
        }
        catch (Exception e) {
            logger.warn("Failed to open stream and report to flink framework. ", (Throwable)e);
            this.messageConsumer.accept(new TransportableError(0L, e));
        }
        this.isOpened = true;
    }

    public void close() {
        this.closed = true;
        if (this.bufferStream != null) {
            logger.debug("Close bufferStream currentStreamId:{}", (Object)this.bufferStream.getStreamId());
            this.bufferStream.close();
        } else {
            logger.warn("bufferStream is null when closed, shuffleId: {}, partitionId: {}", (Object)this.shuffleId, (Object)this.partitionId);
        }
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    @Override
    public void notifyAvailableCredits(int numCredits) {
        if (!this.closed) {
            this.bufferStream.addCredit(PbReadAddCredit.newBuilder().setStreamId(this.bufferStream.getStreamId()).setCredit(numCredits).build());
        }
    }

    public ByteBuf requestBuffer() {
        return this.bufferPool.requestBuffer();
    }

    public void backlogReceived(int backlog) {
        if (!this.closed) {
            this.bufferPool.reserveBuffers(this, backlog);
        }
    }

    public void errorReceived(String errorMsg) {
        if (!this.closed) {
            this.closed = true;
            if (this.bufferStream != null && this.bufferStream.getClient() != null) {
                logger.error("Received error from {} message {}", (Object)NettyUtils.getRemoteAddress(this.bufferStream.getClient().getChannel()), (Object)errorMsg);
            }
            this.failureListener.accept(new IOException(errorMsg));
        }
    }

    public void dataReceived(ReadData readData) {
        logger.debug("Remote buffer stream reader get stream id {} received readable bytes {}.", (Object)readData.getStreamId(), (Object)readData.getFlinkBuffer().readableBytes());
        this.dataListener.accept(readData.getFlinkBuffer());
    }

    public void onStreamEnd(BufferStreamEnd streamEnd) {
        long streamId = streamEnd.getStreamId();
        logger.debug("Buffer stream reader get stream end for {}", (Object)streamId);
        this.bufferStream.moveToNextPartitionIfPossible(streamId);
    }
}

