/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutExecutor;
import org.apache.ratis.util.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BatchLogger {
    private static final Logger LOG = LoggerFactory.getLogger(BatchLogger.class);
    private static final TimeoutExecutor SCHEDULER = TimeoutExecutor.getInstance();
    private static final ConcurrentMap<UniqueId, BatchedLogEntry> LOG_CACHE = new ConcurrentHashMap<UniqueId, BatchedLogEntry>();

    private BatchLogger() {
    }

    public static void warn(Key key, String name, Consumer<String> op, TimeDuration batchDuration) {
        BatchLogger.warn(key, name, op, batchDuration, true);
    }

    public static void warn(Key key, String name, Consumer<String> op, TimeDuration batchDuration, boolean shouldBatch) {
        if (!shouldBatch || batchDuration.isNonPositive()) {
            op.accept("");
            return;
        }
        UniqueId id = new UniqueId(key, name);
        BatchedLogEntry entry = LOG_CACHE.computeIfAbsent(id, k -> new BatchedLogEntry());
        if (entry.tryStartBatch(op)) {
            op.accept("");
            SCHEDULER.onTimeout(batchDuration, () -> Optional.ofNullable(LOG_CACHE.remove(id)).ifPresent(rec$ -> ((BatchedLogEntry)rec$).execute()), LOG, () -> "print batched exception failed on " + op);
        }
    }

    private static final class BatchedLogEntry {
        private Consumer<String> logOp;
        private Timestamp startTime = Timestamp.currentTime();
        private int count = 0;

        private BatchedLogEntry() {
        }

        private synchronized void execute() {
            if (this.count <= 1) {
                return;
            }
            this.logOp.accept(String.format(" (Repeated %d times in the last %s)", this.count, this.startTime.elapsedTime().toString(TimeUnit.SECONDS, 3)));
            this.startTime = null;
        }

        private synchronized boolean tryStartBatch(Consumer<String> op) {
            if (this.startTime == null) {
                op.accept("");
                return false;
            }
            this.logOp = op;
            ++this.count;
            return this.count == 1;
        }
    }

    private static final class UniqueId {
        private final Key key;
        private final String name;

        private UniqueId(Key key, String name) {
            this.key = Objects.requireNonNull(key, "key == null");
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof UniqueId)) {
                return false;
            }
            UniqueId that = (UniqueId)obj;
            return Objects.equals(this.key, that.key) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.name.hashCode();
        }
    }

    public static interface Key {
    }
}

