/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import org.apache.celeborn.client.LifecycleManager;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.CelebornConf$;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.internal.Logging$class;
import org.apache.celeborn.common.protocol.FallbackPolicy;
import org.apache.celeborn.common.protocol.PbCheckWorkersAvailableResponse;
import org.apache.celeborn.common.protocol.message.ControlMessages;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0001\u0002\u0001\u001b\t\u00193)\u001a7fE>\u0014hn\u00155vM\u001adWMR1mY\n\f7m\u001b)pY&\u001c\u0017PU;o]\u0016\u0014(BA\u0002\u0005\u0003!\u0019W\r\\3c_Jt'BA\u0003\u0007\u0003\u001d\u0019\b.\u001e4gY\u0016T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UYR\"\u0001\f\u000b\u0005]A\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005eQ\u0012AB2p[6|gN\u0003\u0002\u0004\u0011%\u0011AD\u0006\u0002\b\u0019><w-\u001b8h\u0011!q\u0002A!A!\u0002\u0013y\u0012\u0001B2p]\u001a\u0004\"\u0001I\u0011\u000e\u0003aI!A\t\r\u0003\u0019\r+G.\u001a2pe:\u001cuN\u001c4\t\u000b\u0011\u0002A\u0011A\u0013\u0002\rqJg.\u001b;?)\t1\u0003\u0006\u0005\u0002(\u00015\t!\u0001C\u0003\u001fG\u0001\u0007q\u0004C\u0004+\u0001\t\u0007I\u0011B\u0016\u0002+MDWO\u001a4mK\u001a\u000bG\u000e\u001c2bG.\u0004v\u000e\\5dsV\tA\u0006\u0005\u0002.a5\taF\u0003\u000201\u0005A\u0001O]8u_\u000e|G.\u0003\u00022]\tqa)\u00197mE\u0006\u001c7\u000eU8mS\u000eL\bBB\u001a\u0001A\u0003%A&\u0001\ftQV4g\r\\3GC2d'-Y2l!>d\u0017nY=!\u0011\u001d)\u0004A1A\u0005\nY\n!c\u00195fG.<vN]6fe\u0016s\u0017M\u00197fIV\tq\u0007\u0005\u0002\u0010q%\u0011\u0011\b\u0005\u0002\b\u0005>|G.Z1o\u0011\u0019Y\u0004\u0001)A\u0005o\u0005\u00192\r[3dW^{'o[3s\u000b:\f'\r\\3eA!9Q\b\u0001b\u0001\n\u00131\u0014\u0001D9v_R\fWI\\1cY\u0016$\u0007BB \u0001A\u0003%q'A\u0007rk>$\u0018-\u00128bE2,G\r\t\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003C\u0003YqW/\u001c)beRLG/[8ogRC'/Z:i_2$W#A\"\u0011\u0005=!\u0015BA#\u0011\u0005\u0011auN\\4\t\r\u001d\u0003\u0001\u0015!\u0003D\u0003]qW/\u001c)beRLG/[8ogRC'/Z:i_2$\u0007\u0005C\u0003J\u0001\u0011\u0005!*\u0001\fbaBd\u00170\u00117m\r\u0006dGNY1dWB{G.[2z)\r94j\u0015\u0005\u0006\u0019\"\u0003\r!T\u0001\u0011Y&4WmY=dY\u0016l\u0015M\\1hKJ\u0004\"AT)\u000e\u0003=S!\u0001\u0015\u000e\u0002\r\rd\u0017.\u001a8u\u0013\t\u0011vJ\u0001\tMS\u001a,7-_2mK6\u000bg.Y4fe\")A\u000b\u0013a\u0001+\u0006ia.^7QCJ$\u0018\u000e^5p]N\u0004\"a\u0004,\n\u0005]\u0003\"aA%oi\")\u0011\f\u0001C\u00015\u0006A\u0012\r\u001d9ms\u001a{'oY3GC2d'-Y2l!>d\u0017nY=\u0015\u0003]BQ\u0001\u0018\u0001\u0005\u0002u\u000bA%\u00199qYf\u001c\u0006.\u001e4gY\u0016\u0004\u0016M\u001d;ji&|gn\u001d$bY2\u0014\u0017mY6Q_2L7-\u001f\u000b\u0003oyCQ\u0001V.A\u0002UCQ\u0001\u0019\u0001\u0005\u0002\u0005\f!b\u00195fG.\fVo\u001c;b)\t9$\rC\u0003M?\u0002\u0007Q\nC\u0003e\u0001\u0011\u0005Q-A\u000bdQ\u0016\u001c7nV8sW\u0016\u00148/\u0011<bS2\f'\r\\3\u0015\u0005]2\u0007\"\u0002'd\u0001\u0004i\u0005")
public class CelebornShuffleFallbackPolicyRunner
implements Logging {
    private final FallbackPolicy shuffleFallbackPolicy;
    private final boolean checkWorkerEnabled;
    private final boolean quotaEnabled;
    private final long org$apache$spark$shuffle$celeborn$CelebornShuffleFallbackPolicyRunner$$numPartitionsThreshold;
    private final transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    private Logger log$lzycompute() {
        CelebornShuffleFallbackPolicyRunner celebornShuffleFallbackPolicyRunner = this;
        synchronized (celebornShuffleFallbackPolicyRunner) {
            if (!this.bitmap$trans$0) {
                this.log = Logging$class.log(this);
                this.bitmap$trans$0 = true;
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$trans$0 ? this.log : this.log$lzycompute();
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    private FallbackPolicy shuffleFallbackPolicy() {
        return this.shuffleFallbackPolicy;
    }

    private boolean checkWorkerEnabled() {
        return this.checkWorkerEnabled;
    }

    private boolean quotaEnabled() {
        return this.quotaEnabled;
    }

    public long org$apache$spark$shuffle$celeborn$CelebornShuffleFallbackPolicyRunner$$numPartitionsThreshold() {
        return this.org$apache$spark$shuffle$celeborn$CelebornShuffleFallbackPolicyRunner$$numPartitionsThreshold;
    }

    /*
     * WARNING - void declaration
     */
    public boolean applyAllFallbackPolicy(LifecycleManager lifecycleManager, int numPartitions) {
        void var3_3;
        boolean needFallback;
        boolean bl = needFallback = this.applyForceFallbackPolicy() || this.applyShufflePartitionsFallbackPolicy(numPartitions) || !this.checkQuota(lifecycleManager) || !this.checkWorkersAvailable(lifecycleManager);
        if (needFallback && FallbackPolicy.NEVER.equals((Object)this.shuffleFallbackPolicy())) {
            throw new CelebornIOException("Fallback to spark built-in shuffle implementation is prohibited.");
        }
        return (boolean)var3_3;
    }

    public boolean applyForceFallbackPolicy() {
        if (FallbackPolicy.ALWAYS.equals((Object)this.shuffleFallbackPolicy())) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CelebornConf$.MODULE$.SPARK_SHUFFLE_FALLBACK_POLICY().key(), FallbackPolicy.ALWAYS.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"forcibly fallback to spark built-in shuffle implementation."})).s((Seq)Nil$.MODULE$)).toString();
                }
            });
        }
        return FallbackPolicy.ALWAYS.equals((Object)this.shuffleFallbackPolicy());
    }

    /*
     * WARNING - void declaration
     */
    public boolean applyShufflePartitionsFallbackPolicy(int numPartitions) {
        void var2_2;
        boolean needFallback;
        boolean bl = needFallback = (long)numPartitions >= this.org$apache$spark$shuffle$celeborn$CelebornShuffleFallbackPolicyRunner$$numPartitionsThreshold();
        if (needFallback) {
            this.logWarning((Function0<String>)new Serializable(this, numPartitions){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CelebornShuffleFallbackPolicyRunner $outer;
                private final int numPartitions$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Shuffle partition number: ", " exceeds threshold: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numPartitions$1), BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$shuffle$celeborn$CelebornShuffleFallbackPolicyRunner$$numPartitionsThreshold())}))).append((Object)"need to fallback to spark built-in shuffle implementation.").toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.numPartitions$1 = numPartitions$1;
                }
            });
        }
        return (boolean)var2_2;
    }

    public boolean checkQuota(LifecycleManager lifecycleManager) {
        if (this.quotaEnabled()) {
            ControlMessages.CheckQuotaResponse resp = lifecycleManager.checkQuota();
            if (!resp.isAvailable()) {
                this.logWarning((Function0<String>)new Serializable(this, lifecycleManager, resp){
                    public static final long serialVersionUID = 0L;
                    private final LifecycleManager lifecycleManager$1;
                    private final ControlMessages.CheckQuotaResponse resp$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Quota exceed for current user ", ". Because: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.lifecycleManager$1.getUserIdentifier(), this.resp$1.reason()}));
                    }
                    {
                        this.lifecycleManager$1 = lifecycleManager$1;
                        this.resp$1 = resp$1;
                    }
                });
            }
            return resp.isAvailable();
        }
        return true;
    }

    public boolean checkWorkersAvailable(LifecycleManager lifecycleManager) {
        if (this.checkWorkerEnabled()) {
            PbCheckWorkersAvailableResponse resp = lifecycleManager.checkWorkersAvailable();
            if (!resp.getAvailable()) {
                this.logWarning((Function0<String>)new Serializable(this, lifecycleManager){
                    public static final long serialVersionUID = 0L;
                    private final LifecycleManager lifecycleManager$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No celeborn workers available for current user ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.lifecycleManager$2.getUserIdentifier()}));
                    }
                    {
                        this.lifecycleManager$2 = lifecycleManager$2;
                    }
                });
            }
            return resp.getAvailable();
        }
        return true;
    }

    public CelebornShuffleFallbackPolicyRunner(CelebornConf conf) {
        Logging$class.$init$(this);
        this.shuffleFallbackPolicy = conf.shuffleFallbackPolicy();
        this.checkWorkerEnabled = conf.checkWorkerEnabled();
        this.quotaEnabled = conf.quotaEnabled();
        this.org$apache$spark$shuffle$celeborn$CelebornShuffleFallbackPolicyRunner$$numPartitionsThreshold = conf.shuffleFallbackPartitionThreshold();
    }
}

