/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;

public class PendingRequest
implements Comparable<PendingRequest> {
    private final long index;
    private final RaftClientRequest request;
    private final TransactionContext entry;
    private final CompletableFuture<RaftClientReply> futureToComplete = new CompletableFuture();
    private final CompletableFuture<RaftClientReply> futureToReturn;

    PendingRequest(long index, RaftClientRequest request, TransactionContext entry) {
        this.index = index;
        this.request = request;
        this.entry = entry;
        this.futureToReturn = request.is(RaftProtos.RaftClientRequestProto.TypeCase.FORWARD) ? this.futureToComplete.thenApply(reply -> this.convert(request, (RaftClientReply)reply)) : this.futureToComplete;
    }

    PendingRequest(SetConfigurationRequest request) {
        this(-1L, (RaftClientRequest)request, null);
    }

    RaftClientReply convert(RaftClientRequest q, RaftClientReply p) {
        return RaftClientReply.newBuilder().setRequest(q).setCommitInfos(p.getCommitInfos()).setLogIndex(p.getLogIndex()).setMessage(p.getMessage()).setException(p.getException()).setSuccess(p.isSuccess()).build();
    }

    long getIndex() {
        return this.index;
    }

    RaftClientRequest getRequest() {
        return this.request;
    }

    public CompletableFuture<RaftClientReply> getFuture() {
        return this.futureToReturn;
    }

    TransactionContext getEntry() {
        return this.entry;
    }

    synchronized void setException(Throwable e) {
        Preconditions.assertTrue((e != null ? 1 : 0) != 0);
        this.futureToComplete.completeExceptionally(e);
    }

    synchronized void setReply(RaftClientReply r) {
        Preconditions.assertTrue((r != null ? 1 : 0) != 0);
        this.futureToComplete.complete(r);
    }

    TransactionContext setNotLeaderException(NotLeaderException nle, Collection<RaftProtos.CommitInfoProto> commitInfos) {
        this.setReply(RaftClientReply.newBuilder().setRequest(this.getRequest()).setException((RaftException)nle).setCommitInfos(commitInfos).build());
        return this.getEntry();
    }

    @Override
    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
    public int compareTo(PendingRequest that) {
        return Long.compare(this.index, that.index);
    }

    public String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + ":index=" + this.index + ", request=" + this.request;
    }
}

