/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.util;

import java.io.File;
import org.apache.celeborn.common.CelebornConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportConf {
    private static final Logger logger = LoggerFactory.getLogger(TransportConf.class);
    private final CelebornConf celebornConf;
    private final String module;

    public TransportConf(String module, CelebornConf celebornConf) {
        this.module = module;
        this.celebornConf = celebornConf;
    }

    public String getModuleName() {
        return this.module;
    }

    public String ioMode() {
        return this.celebornConf.networkIoMode(this.module);
    }

    public boolean preferDirectBufs() {
        return this.celebornConf.networkIoPreferDirectBufs(this.module);
    }

    public int connectTimeoutMs() {
        return this.celebornConf.networkIoConnectTimeoutMs(this.module);
    }

    public int connectionTimeoutMs() {
        return this.celebornConf.networkIoConnectionTimeoutMs(this.module);
    }

    public int numConnectionsPerPeer() {
        return this.celebornConf.networkIoNumConnectionsPerPeer(this.module);
    }

    public int backLog() {
        return this.celebornConf.networkIoBacklog(this.module);
    }

    public int serverThreads() {
        return this.celebornConf.networkIoServerThreads(this.module);
    }

    public int clientThreads() {
        return this.celebornConf.networkIoClientThreads(this.module);
    }

    public boolean conflictAvoidChooserEnable() {
        return this.celebornConf.networkIoConflictAvoidChooserEnable(this.module);
    }

    public int receiveBuf() {
        return this.celebornConf.networkIoReceiveBuf(this.module);
    }

    public int sendBuf() {
        return this.celebornConf.networkIoSendBuf(this.module);
    }

    public int maxIORetries() {
        return this.celebornConf.networkIoMaxRetries(this.module);
    }

    public int ioRetryWaitTimeMs() {
        return this.celebornConf.networkIoRetryWaitMs(this.module);
    }

    public int memoryMapBytes() {
        return this.celebornConf.networkIoMemoryMapBytes(this.module);
    }

    public boolean lazyFileDescriptor() {
        return this.celebornConf.networkIoLazyFileDescriptor(this.module);
    }

    public boolean verboseMetrics() {
        return this.celebornConf.networkIoVerboseMetrics(this.module);
    }

    public CelebornConf getCelebornConf() {
        return this.celebornConf;
    }

    public int pushDataTimeoutCheckerThreads() {
        return this.celebornConf.pushDataTimeoutCheckerThreads(this.module);
    }

    public long pushDataTimeoutCheckIntervalMs() {
        return this.celebornConf.pushDataTimeoutCheckInterval(this.module);
    }

    public int fetchDataTimeoutCheckerThreads() {
        return this.celebornConf.fetchDataTimeoutCheckerThreads(this.module);
    }

    public long fetchDataTimeoutCheckIntervalMs() {
        return this.celebornConf.fetchDataTimeoutCheckInterval(this.module);
    }

    public long clientHeartbeatInterval() {
        return this.celebornConf.clientHeartbeatInterval(this.module);
    }

    public int saslTimeoutMs() {
        return this.celebornConf.networkIoSaslTimoutMs(this.module);
    }

    public boolean authEnabled() {
        return this.celebornConf.authEnabled();
    }

    public boolean sslEnabled() {
        return this.celebornConf.sslEnabled(this.module);
    }

    public String sslProtocol() {
        return this.celebornConf.sslProtocol(this.module);
    }

    public String[] sslRequestedCiphers() {
        return this.celebornConf.sslRequestedCiphers(this.module);
    }

    public File sslKeyStore() {
        return this.celebornConf.sslKeyStore(this.module);
    }

    public String sslKeyStorePassword() {
        return this.celebornConf.sslKeyStorePassword(this.module);
    }

    public File sslTrustStore() {
        return this.celebornConf.sslTrustStore(this.module);
    }

    public String sslTrustStorePassword() {
        return this.celebornConf.sslTrustStorePassword(this.module);
    }

    public boolean sslTrustStoreReloadingEnabled() {
        return this.celebornConf.sslTrustStoreReloadingEnabled(this.module);
    }

    public int sslTrustStoreReloadIntervalMs() {
        return this.celebornConf.sslTrustStoreReloadIntervalMs(this.module);
    }

    public int maxSslEncryptedBlockSize() {
        return this.celebornConf.maxSslEncryptedBlockSize(this.module);
    }

    public int sslHandshakeTimeoutMs() {
        return this.celebornConf.sslHandshakeTimeoutMs(this.module);
    }

    public boolean sslEnabledAndKeysAreValid() {
        if (!this.sslEnabled()) {
            return false;
        }
        File keyStore = this.sslKeyStore();
        return keyStore == null || keyStore.exists();
    }

    public boolean autoSslEnabled() {
        boolean shouldAutoSslEnabled;
        if (!"rpc_app_lifecyclemanager".equals(this.module)) {
            return false;
        }
        boolean autoSslEnabled = this.celebornConf.isAutoSslEnabled(this.module);
        if (!autoSslEnabled) {
            return false;
        }
        File keystore = this.celebornConf.sslKeyStore(this.module);
        File truststore = this.celebornConf.sslTrustStore(this.module);
        boolean bl = shouldAutoSslEnabled = null == keystore && null == truststore;
        if (!shouldAutoSslEnabled) {
            logger.warn("Auto ssl for {} disabled as keystore = {} or truststore = {} was configured", new Object[]{this.module, null != keystore ? keystore.getPath() : null, null != truststore ? truststore.getPath() : null});
        }
        return shouldAutoSslEnabled;
    }
}

