/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh.peer;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.shell.cli.RaftUtils;
import org.apache.ratis.shell.cli.sh.command.AbstractRatisCommand;
import org.apache.ratis.shell.cli.sh.command.Context;

public class AddCommand
extends AbstractRatisCommand {
    public static final String ADDRESS_OPTION_NAME = "address";
    public static final String PEER_ID_OPTION_NAME = "peerId";

    public AddCommand(Context context) {
        super(context);
    }

    @Override
    public String getCommandName() {
        return "add";
    }

    @Override
    public int run(CommandLine cl) throws IOException {
        List<Object> ids;
        super.run(cl);
        HashMap peersInfo = new HashMap();
        if (cl.hasOption(ADDRESS_OPTION_NAME) && cl.hasOption(PEER_ID_OPTION_NAME)) {
            ids = Arrays.stream(cl.getOptionValue(PEER_ID_OPTION_NAME).split(",")).map(RaftPeerId::getRaftPeerId).collect(Collectors.toList());
            List addresses = Arrays.stream(cl.getOptionValue(ADDRESS_OPTION_NAME).split(",")).map(s -> AddCommand.parseInetSocketAddress(s)).collect(Collectors.toList());
            assert (ids.size() == addresses.size());
            for (int i = 0; i < ids.size(); ++i) {
                peersInfo.put(ids.get(i), addresses.get(i));
            }
        } else if (cl.hasOption(ADDRESS_OPTION_NAME)) {
            ids = this.getIds(cl.getOptionValue(ADDRESS_OPTION_NAME).split(","), peersInfo::put);
        } else {
            throw new IllegalArgumentException("Both peerId and address options are missing.");
        }
        try (RaftClient client = RaftUtils.createClient(this.getRaftGroup());){
            Stream<RaftPeer> remaining = this.getPeerStream(RaftProtos.RaftPeerRole.FOLLOWER);
            Stream<RaftPeer> adding = ids.stream().map(raftPeerId -> RaftPeer.newBuilder().setId(raftPeerId).setAddress((InetSocketAddress)peersInfo.get(raftPeerId)).setPriority(0).build());
            List peers = Stream.concat(remaining, adding).collect(Collectors.toList());
            List listeners = this.getPeerStream(RaftProtos.RaftPeerRole.LISTENER).collect(Collectors.toList());
            System.out.println("New peer list: " + peers);
            System.out.println("New listener list:  " + listeners);
            RaftClientReply reply = client.admin().setConfiguration(peers, listeners);
            this.processReply(reply, () -> "Failed to change raft peer");
        }
        return 0;
    }

    @Override
    public String getUsage() {
        return String.format("%s -%s <PEER0_HOST:PEER0_PORT,PEER1_HOST:PEER1_PORT,PEER2_HOST:PEER2_PORT> [-%s <RAFT_GROUP_ID>] <[-%s <PEER0_HOST:PEER0_PORT>]|[-%s <peerId>]>", this.getCommandName(), "peers", "groupid", ADDRESS_OPTION_NAME, PEER_ID_OPTION_NAME);
    }

    @Override
    public String getDescription() {
        return AddCommand.description();
    }

    @Override
    public Options getOptions() {
        return super.getOptions().addOption(Option.builder().option(ADDRESS_OPTION_NAME).hasArg().desc("The address information of ratis peers").build()).addOption(Option.builder().option(PEER_ID_OPTION_NAME).hasArg().desc("The peer id of ratis peers").build());
    }

    public static String description() {
        return "Add peers to a ratis group";
    }
}

