/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.columnar.CelebornColumnStats;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00114QAD\b\u0003\u001fmA\u0001B\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tW\u0001\u0011\t\u0011)A\u0005Q!)A\u0006\u0001C\u0001[!)A\u0006\u0001C\u0001c!I!\b\u0001a\u0001\u0002\u0004%\tb\u000f\u0005\n\u007f\u0001\u0001\r\u00111A\u0005\u0012\u0001C\u0011B\u0012\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u001f\t\u0013\u001d\u0003\u0001\u0019!a\u0001\n#Y\u0004\"\u0003%\u0001\u0001\u0004\u0005\r\u0011\"\u0005J\u0011%Y\u0005\u00011A\u0001B\u0003&A\bC\u0003M\u0001\u0011\u0005S\nC\u0003Y\u0001\u0011\u0005\u0011\fC\u0003]\u0001\u0011\u0005SL\u0001\u000eDK2,'m\u001c:o\t\u0016\u001c\u0017.\\1m\u0007>dW/\u001c8Ti\u0006$8O\u0003\u0002\u0011#\u0005A1m\u001c7v[:\f'O\u0003\u0002\u0013'\u0005IQ\r_3dkRLwN\u001c\u0006\u0003)U\t1a]9m\u0015\t1r#A\u0003ta\u0006\u00148N\u0003\u0002\u00193\u00051\u0011\r]1dQ\u0016T\u0011AG\u0001\u0004_J<7c\u0001\u0001\u001dEA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\u0004\"a\t\u0013\u000e\u0003=I!!J\b\u0003'\r+G.\u001a2pe:\u001cu\u000e\\;n]N#\u0018\r^:\u0002\u0013A\u0014XmY5tS>t7\u0001\u0001\t\u0003;%J!A\u000b\u0010\u0003\u0007%sG/A\u0003tG\u0006dW-\u0001\u0004=S:LGO\u0010\u000b\u0004]=\u0002\u0004CA\u0012\u0001\u0011\u001513\u00011\u0001)\u0011\u0015Y3\u00011\u0001))\tq#\u0007C\u00034\t\u0001\u0007A'\u0001\u0002eiB\u0011Q\u0007O\u0007\u0002m)\u0011qgE\u0001\u0006if\u0004Xm]\u0005\u0003sY\u00121\u0002R3dS6\fG\u000eV=qK\u0006)Q\u000f\u001d9feV\tA\b\u0005\u00026{%\u0011aH\u000e\u0002\b\t\u0016\u001c\u0017.\\1m\u0003%)\b\u000f]3s?\u0012*\u0017\u000f\u0006\u0002B\tB\u0011QDQ\u0005\u0003\u0007z\u0011A!\u00168ji\"9QIBA\u0001\u0002\u0004a\u0014a\u0001=%c\u00051Q\u000f\u001d9fe\u0002\nQ\u0001\\8xKJ\f\u0011\u0002\\8xKJ|F%Z9\u0015\u0005\u0005S\u0005bB#\n\u0003\u0003\u0005\r\u0001P\u0001\u0007Y><XM\u001d\u0011\u0002\u0017\u001d\fG\u000f[3s'R\fGo\u001d\u000b\u0004\u0003:3\u0006\"B(\f\u0001\u0004\u0001\u0016a\u0001:poB\u0011\u0011\u000bV\u0007\u0002%*\u00111kE\u0001\tG\u0006$\u0018\r\\=ti&\u0011QK\u0015\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0003X\u0017\u0001\u0007\u0001&A\u0004pe\u0012Lg.\u00197\u0002!\u001d\fG\u000f[3s-\u0006dW/Z*uCR\u001cHCA![\u0011\u0015YF\u00021\u0001=\u0003\u00151\u0018\r\\;f\u0003M\u0019w\u000e\u001c7fGR,Gm\u0015;bi&\u001cH/[2t+\u0005q\u0006cA\u000f`C&\u0011\u0001M\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003;\tL!a\u0019\u0010\u0003\u0007\u0005s\u0017\u0010")
public final class CelebornDecimalColumnStats
implements CelebornColumnStats {
    private final int precision;
    private final int scale;
    private Decimal upper;
    private Decimal lower;
    private int count;
    private int nullCount;
    private long sizeInBytes;

    @Override
    public void gatherNullStats() {
        CelebornColumnStats.gatherNullStats$(this);
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public void count_$eq(int x$1) {
        this.count = x$1;
    }

    @Override
    public int nullCount() {
        return this.nullCount;
    }

    @Override
    public void nullCount_$eq(int x$1) {
        this.nullCount = x$1;
    }

    @Override
    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public void sizeInBytes_$eq(long x$1) {
        this.sizeInBytes = x$1;
    }

    public Decimal upper() {
        return this.upper;
    }

    public void upper_$eq(Decimal x$1) {
        this.upper = x$1;
    }

    public Decimal lower() {
        return this.lower;
    }

    public void lower_$eq(Decimal x$1) {
        this.lower = x$1;
    }

    @Override
    public void gatherStats(InternalRow row, int ordinal) {
        if (!row.isNullAt(ordinal)) {
            Decimal value = row.getDecimal(ordinal, this.precision, this.scale);
            this.gatherValueStats(value);
            return;
        }
        this.gatherNullStats();
    }

    public void gatherValueStats(Decimal value) {
        if (this.upper() == null || value.compareTo((Object)this.upper()) > 0) {
            this.upper_$eq(value);
        }
        if (this.lower() == null || value.compareTo((Object)this.lower()) < 0) {
            this.lower_$eq(value);
        }
        if (this.precision <= Decimal$.MODULE$.MAX_INT_DIGITS()) {
            this.sizeInBytes_$eq(this.sizeInBytes() + 4L);
        } else if (this.precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            this.sizeInBytes_$eq(this.sizeInBytes() + 8L);
        } else {
            this.sizeInBytes_$eq(this.sizeInBytes() + (long)(4 + value.toJavaBigDecimal().unscaledValue().bitLength() / 8 + 1));
        }
        this.count_$eq(this.count() + 1);
    }

    @Override
    public Object[] collectedStatistics() {
        return new Object[]{this.lower(), this.upper(), BoxesRunTime.boxToInteger((int)this.nullCount()), BoxesRunTime.boxToInteger((int)this.count()), BoxesRunTime.boxToLong((long)this.sizeInBytes())};
    }

    public CelebornDecimalColumnStats(int precision, int scale) {
        this.precision = precision;
        this.scale = scale;
        CelebornColumnStats.$init$(this);
    }

    public CelebornDecimalColumnStats(DecimalType dt) {
        this(dt.precision(), dt.scale());
    }
}

