/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.tiered;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.celeborn.client.LifecycleManager;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.ThreadUtils;
import org.apache.celeborn.plugin.flink.FlinkResultPartitionInfo;
import org.apache.celeborn.plugin.flink.RemoteShuffleResource;
import org.apache.celeborn.plugin.flink.ShuffleResourceDescriptor;
import org.apache.celeborn.plugin.flink.ShuffleResourceTracker;
import org.apache.celeborn.plugin.flink.ShuffleTaskInfo;
import org.apache.celeborn.plugin.flink.tiered.TierShuffleDescriptorImpl;
import org.apache.celeborn.plugin.flink.utils.FlinkUtils;
import org.apache.celeborn.plugin.flink.utils.Utils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageIdMappingUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierMasterAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierShuffleDescriptor;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierShuffleHandler;
import org.apache.flink.runtime.shuffle.JobShuffleContext;
import org.apache.flink.runtime.shuffle.PartitionWithMetrics;
import org.apache.flink.util.ExecutorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CelebornTierMasterAgent
implements TierMasterAgent {
    private static final Logger LOG = LoggerFactory.getLogger(CelebornTierMasterAgent.class);
    private final Map<JobID, Set<Integer>> jobShuffleIds = JavaUtils.newConcurrentHashMap();
    private final ShuffleTaskInfo shuffleTaskInfo = new ShuffleTaskInfo();
    private final ScheduledExecutorService executor = ThreadUtils.newDaemonSingleThreadScheduledExecutor("celeborn-client-tier-master-executor");
    private final long lifecycleManagerTimestamp;
    private final CelebornConf conf;
    private ShuffleResourceTracker shuffleResourceTracker;
    private String celebornAppId;
    private volatile LifecycleManager lifecycleManager;

    public CelebornTierMasterAgent(CelebornConf conf) {
        this.conf = conf;
        this.lifecycleManagerTimestamp = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void registerJob(JobID jobID, TierShuffleHandler tierShuffleHandler) {
        if (this.lifecycleManager == null) {
            Class<CelebornTierMasterAgent> clazz = CelebornTierMasterAgent.class;
            // MONITORENTER : org.apache.celeborn.plugin.flink.tiered.CelebornTierMasterAgent.class
            if (this.lifecycleManager == null) {
                this.celebornAppId = FlinkUtils.toCelebornAppId(this.lifecycleManagerTimestamp, jobID);
                LOG.info("CelebornAppId: {}", (Object)this.celebornAppId);
                this.lifecycleManager = new LifecycleManager(this.celebornAppId, this.conf);
                this.shuffleResourceTracker = new ShuffleResourceTracker(this.executor, this.lifecycleManager);
            }
            // MONITOREXIT : clazz
        }
        Set previousShuffleIds = this.jobShuffleIds.putIfAbsent(jobID, new HashSet());
        LOG.info("Register job: {}.", (Object)jobID);
        if (previousShuffleIds != null) {
            throw new RuntimeException("Duplicated registration job: " + jobID);
        }
        this.shuffleResourceTracker.registerJob(this.getJobShuffleContext(jobID, tierShuffleHandler));
    }

    public void unregisterJob(JobID jobID) {
        LOG.info("Unregister job: {}.", (Object)jobID);
        Set<Integer> shuffleIds = this.jobShuffleIds.remove(jobID);
        if (shuffleIds != null) {
            this.executor.execute(() -> {
                for (Integer shuffleId : shuffleIds) {
                    this.lifecycleManager.unregisterShuffle(shuffleId);
                    this.shuffleTaskInfo.removeExpiredShuffle(shuffleId);
                }
                this.shuffleResourceTracker.unRegisterJob(jobID);
            });
        }
    }

    public TierShuffleDescriptor addPartitionAndGetShuffleDescriptor(JobID jobID, int numSubpartitions, ResultPartitionID resultPartitionID) {
        Set<Integer> shuffleIds = this.jobShuffleIds.get(jobID);
        if (shuffleIds == null) {
            throw new RuntimeException("Can not find job in master agent, job: " + jobID);
        }
        FlinkResultPartitionInfo resultPartitionInfo = new FlinkResultPartitionInfo(jobID, resultPartitionID);
        ShuffleResourceDescriptor shuffleResourceDescriptor = this.shuffleTaskInfo.genShuffleResourceDescriptor(resultPartitionInfo.getShuffleId(), resultPartitionInfo.getTaskId(), resultPartitionInfo.getAttemptId());
        shuffleIds.add(shuffleResourceDescriptor.getShuffleId());
        this.shuffleResourceTracker.addPartitionResource(jobID, shuffleResourceDescriptor.getShuffleId(), shuffleResourceDescriptor.getPartitionId(), resultPartitionID);
        RemoteShuffleResource remoteShuffleResource = new RemoteShuffleResource(this.lifecycleManager.getHost(), this.lifecycleManager.getPort(), this.lifecycleManagerTimestamp, shuffleResourceDescriptor);
        return new TierShuffleDescriptorImpl(this.celebornAppId, jobID, resultPartitionInfo.getShuffleId(), resultPartitionID, remoteShuffleResource);
    }

    public void releasePartition(TierShuffleDescriptor shuffleDescriptor) {
        Utils.checkState(shuffleDescriptor instanceof TierShuffleDescriptorImpl, "Wrong descriptor type.");
        try {
            TierShuffleDescriptorImpl descriptor = (TierShuffleDescriptorImpl)shuffleDescriptor;
            RemoteShuffleResource shuffleResource = descriptor.getShuffleResource();
            ShuffleResourceDescriptor resourceDescriptor = shuffleResource.getMapPartitionShuffleDescriptor();
            LOG.debug("release partition resource: {}.", (Object)resourceDescriptor);
            this.lifecycleManager.releasePartition(resourceDescriptor.getShuffleId(), resourceDescriptor.getPartitionId());
            this.shuffleResourceTracker.removePartitionResource(descriptor.getJobId(), resourceDescriptor.getShuffleId(), resourceDescriptor.getPartitionId());
        }
        catch (Throwable throwable) {
            LOG.debug("Failed to release data partition {}.", (Object)shuffleDescriptor, (Object)throwable);
        }
    }

    public void close() {
        try {
            this.jobShuffleIds.clear();
            if (null != this.lifecycleManager) {
                this.lifecycleManager.stop();
            }
        }
        catch (Exception e) {
            LOG.warn("Encounter exception when shutdown: {}", (Object)e.getMessage(), (Object)e);
        }
        ExecutorUtils.gracefulShutdown((long)10L, (TimeUnit)TimeUnit.SECONDS, (ExecutorService[])new ExecutorService[]{this.executor});
    }

    private JobShuffleContext getJobShuffleContext(final JobID jobID, final TierShuffleHandler tierShuffleHandler) {
        return new JobShuffleContext(){

            public JobID getJobId() {
                return jobID;
            }

            public CompletableFuture<?> stopTrackingAndReleasePartitions(Collection<ResultPartitionID> resultPartitionIds) {
                return tierShuffleHandler.onReleasePartitions((Collection)resultPartitionIds.stream().map(TieredStorageIdMappingUtils::convertId).collect(Collectors.toList()));
            }

            public CompletableFuture<Collection<PartitionWithMetrics>> getPartitionWithMetrics(Duration duration, Set<ResultPartitionID> set) {
                return CompletableFuture.completedFuture(Collections.emptyList());
            }

            public void notifyPartitionRecoveryStarted() {
            }
        };
    }
}

