/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.memory;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.network.util.NettyUtils;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.util.ThreadUtils;
import org.apache.celeborn.service.deploy.worker.memory.MemoryManager;
import org.apache.celeborn.service.deploy.worker.memory.ReadBufferRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadBufferDispatcher {
    private final Logger logger = LoggerFactory.getLogger(ReadBufferDispatcher.class);
    private final LinkedBlockingQueue<ReadBufferRequest> requests = new LinkedBlockingQueue();
    private final MemoryManager memoryManager;
    private final ByteBufAllocator readBufferAllocator;
    private final LongAdder allocatedReadBuffers = new LongAdder();
    private final long readBufferAllocationWait;
    @VisibleForTesting
    public volatile boolean stopFlag = false;
    @VisibleForTesting
    public final AtomicReference<Thread> dispatcherThread;

    public ReadBufferDispatcher(MemoryManager memoryManager, CelebornConf conf, AbstractSource source) {
        this.readBufferAllocationWait = conf.readBufferAllocationWait();
        long checkThreadInterval = conf.readBufferDispatcherCheckThreadInterval();
        this.readBufferAllocator = NettyUtils.getByteBufAllocator((TransportConf)new TransportConf("readBuffer", conf), (AbstractSource)source, (boolean)true);
        this.memoryManager = memoryManager;
        this.dispatcherThread = new AtomicReference<Thread>(ThreadUtils.newThread((Runnable)new DispatcherRunnable(), (String)"read-buffer-dispatcher"));
        this.dispatcherThread.get().start();
        if (checkThreadInterval > 0L) {
            ScheduledExecutorService checkAliveThread = ThreadUtils.newDaemonSingleThreadScheduledExecutor((String)"read-buffer-dispatcher-checker");
            checkAliveThread.scheduleWithFixedDelay(() -> {
                if (!this.dispatcherThread.get().isAlive()) {
                    this.dispatcherThread.set(ThreadUtils.newThread((Runnable)new DispatcherRunnable(), (String)"read-buffer-dispatcher"));
                    this.dispatcherThread.get().start();
                }
            }, checkThreadInterval, checkThreadInterval, TimeUnit.MILLISECONDS);
        }
    }

    public void addBufferRequest(ReadBufferRequest request) {
        this.requests.add(request);
    }

    public void recycle(ByteBuf buf) {
        int bufferSize = buf.capacity();
        int refCnt = buf.refCnt();
        if (refCnt > 0) {
            buf.release(refCnt);
        }
        this.allocatedReadBuffers.decrement();
        this.memoryManager.changeReadBufferCounter(-1 * bufferSize);
    }

    public int requestsLength() {
        return this.requests.size();
    }

    public long getAllocatedReadBuffers() {
        return this.allocatedReadBuffers.sum();
    }

    public void close() {
        this.stopFlag = true;
        this.requests.clear();
    }

    private class DispatcherRunnable
    implements Runnable {
        @Override
        public void run() {
            while (!ReadBufferDispatcher.this.stopFlag) {
                try {
                    ReadBufferRequest request = (ReadBufferRequest)ReadBufferDispatcher.this.requests.poll(1000L, TimeUnit.MILLISECONDS);
                    ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>();
                    try {
                        if (request != null) {
                            this.processBufferRequest(request, buffers);
                            continue;
                        }
                        if (!(ReadBufferDispatcher.this.readBufferAllocator instanceof PooledByteBufAllocator)) continue;
                        ((PooledByteBufAllocator)ReadBufferDispatcher.this.readBufferAllocator).trimCurrentThreadCache();
                    }
                    catch (Throwable e) {
                        ReadBufferDispatcher.this.logger.error(e.getMessage(), e);
                        try {
                            for (ByteBuf buffer : buffers) {
                                ReadBufferDispatcher.this.recycle(buffer);
                            }
                        }
                        catch (Throwable e1) {
                            ReadBufferDispatcher.this.logger.error("Recycle read buffer failed.", e1);
                        }
                        request.getBufferListener().notifyBuffers(null, e);
                    }
                }
                catch (Throwable e) {
                    ReadBufferDispatcher.this.logger.error("Read buffer dispatcher encountered error: {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }

        void processBufferRequest(ReadBufferRequest request, List<ByteBuf> buffers) {
            long start = System.nanoTime();
            int bufferSize = request.getBufferSize();
            while (buffers.size() < request.getNumber()) {
                if (ReadBufferDispatcher.this.memoryManager.readBufferAvailable(bufferSize)) {
                    ByteBuf buf = ReadBufferDispatcher.this.readBufferAllocator.buffer(bufferSize, bufferSize);
                    buffers.add(buf);
                    ReadBufferDispatcher.this.memoryManager.changeReadBufferCounter(bufferSize);
                    ReadBufferDispatcher.this.allocatedReadBuffers.increment();
                    continue;
                }
                try {
                    Thread.sleep(ReadBufferDispatcher.this.readBufferAllocationWait);
                }
                catch (InterruptedException e) {
                    ReadBufferDispatcher.this.logger.warn("Buffer dispatcher is closing");
                }
            }
            long end = System.nanoTime();
            ReadBufferDispatcher.this.logger.debug("process read buffer request using {} ms", (Object)TimeUnit.NANOSECONDS.toMillis(end - start));
            request.getBufferListener().notifyBuffers(buffers, null);
        }
    }
}

