/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.plugin.flink.AbstractRemoteShuffleInputGateFactory;
import org.apache.celeborn.plugin.flink.AbstractRemoteShuffleResultPartitionFactory;
import org.apache.celeborn.plugin.flink.RemoteShuffleDescriptor;
import org.apache.celeborn.plugin.flink.metric.RemoteShuffleMetricFactory;
import org.apache.celeborn.plugin.flink.netty.NettyShuffleEnvironmentWrapper;
import org.apache.celeborn.plugin.flink.utils.Utils;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.deployment.InputGateDeploymentDescriptor;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.PartitionInfo;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.metrics.InputChannelMetrics;
import org.apache.flink.runtime.io.network.partition.PartitionProducerStateProvider;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.metrics.groups.ShuffleIOMetricGroup;
import org.apache.flink.runtime.shuffle.ShuffleEnvironment;
import org.apache.flink.runtime.shuffle.ShuffleIOOwnerContext;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteShuffleEnvironment
implements ShuffleEnvironment<ResultPartitionWriter, IndexedInputGate> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteShuffleEnvironment.class);
    private final NetworkBufferPool networkBufferPool;
    private final ResultPartitionManager resultPartitionManager;
    private final AbstractRemoteShuffleResultPartitionFactory resultPartitionFactory;
    private final AbstractRemoteShuffleInputGateFactory inputGateFactory;
    private final CelebornConf conf;
    private final NettyShuffleEnvironmentWrapper shuffleEnvironmentWrapper;
    private boolean isClosed;
    private final Object lock = new Object();
    private final ConcurrentHashMap.KeySetView<IntermediateDataSetID, Boolean> nettyResultIds = ConcurrentHashMap.newKeySet();
    private final ConcurrentHashMap.KeySetView<IntermediateResultPartitionID, Boolean> nettyResultPartitionIds = ConcurrentHashMap.newKeySet();
    private final Map<Integer, ShuffleIOMetricGroup> shuffleIOMetricGroups = JavaUtils.newConcurrentHashMap();

    public RemoteShuffleEnvironment(NetworkBufferPool networkBufferPool, ResultPartitionManager resultPartitionManager, AbstractRemoteShuffleResultPartitionFactory resultPartitionFactory, AbstractRemoteShuffleInputGateFactory inputGateFactory, CelebornConf conf, NettyShuffleEnvironmentWrapper shuffleEnvironmentWrapper) {
        this.networkBufferPool = networkBufferPool;
        this.resultPartitionManager = resultPartitionManager;
        this.resultPartitionFactory = resultPartitionFactory;
        this.inputGateFactory = inputGateFactory;
        this.conf = conf;
        this.shuffleEnvironmentWrapper = shuffleEnvironmentWrapper;
        this.isClosed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LOG.info("Close RemoteShuffleEnvironment.");
        Object object = this.lock;
        synchronized (object) {
            this.nettyResultIds.clear();
            this.nettyResultPartitionIds.clear();
            this.shuffleIOMetricGroups.clear();
            try {
                this.networkBufferPool.destroyAllBufferPools();
            }
            catch (Throwable t) {
                LOG.error("Close RemoteShuffleEnvironment failure.", t);
            }
            try {
                this.resultPartitionManager.shutdown();
            }
            catch (Throwable t) {
                LOG.error("Close RemoteShuffleEnvironment failure.", t);
            }
            try {
                this.networkBufferPool.destroy();
            }
            catch (Throwable t) {
                LOG.error("Close RemoteShuffleEnvironment failure.", t);
            }
            this.isClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Utils.checkState(!this.isClosed, "The RemoteShuffleEnvironment has already been shut down.");
            LOG.info("Starting the network environment and its components.");
            return 1;
        }
    }

    public boolean updatePartitionInfo(ExecutionAttemptID consumerID, PartitionInfo partitionInfo) {
        throw new FlinkRuntimeException("Not implemented yet.");
    }

    public ShuffleIOOwnerContext createShuffleIOOwnerContext(String ownerName, ExecutionAttemptID executionAttemptID, MetricGroup parentGroup) {
        MetricGroup remoteGroup = RemoteShuffleMetricFactory.createShuffleIOOwnerMetricGroup(Utils.checkNotNull(parentGroup));
        return new ShuffleIOOwnerContext(Utils.checkNotNull(ownerName), Utils.checkNotNull(executionAttemptID), parentGroup, remoteGroup.addGroup("Output"), remoteGroup.addGroup("Input"));
    }

    public Collection<ResultPartitionID> getPartitionsOccupyingLocalResources() {
        return this.resultPartitionManager.getUnreleasedPartitions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResultPartitionWriter> createResultPartitionWriters(ShuffleIOOwnerContext ownerContext, List<ResultPartitionDeploymentDescriptor> resultPartitionDeploymentDescriptors) {
        Object object = this.lock;
        synchronized (object) {
            Utils.checkState(!this.isClosed, "The RemoteShuffleEnvironment has already been shut down.");
            ResultPartitionWriter[] resultPartitions = new ResultPartitionWriter[resultPartitionDeploymentDescriptors.size()];
            for (int index = 0; index < resultPartitions.length; ++index) {
                resultPartitions[index] = this.createResultPartitionWriterInternal(ownerContext, index, resultPartitionDeploymentDescriptors.get(index), this.conf);
            }
            return Arrays.asList(resultPartitions);
        }
    }

    private ResultPartitionWriter createResultPartitionWriterInternal(ShuffleIOOwnerContext ownerContext, int index, ResultPartitionDeploymentDescriptor resultPartitionDeploymentDescriptor, CelebornConf conf) {
        if (resultPartitionDeploymentDescriptor.getShuffleDescriptor() instanceof RemoteShuffleDescriptor) {
            int shuffleId = ((RemoteShuffleDescriptor)resultPartitionDeploymentDescriptor.getShuffleDescriptor()).getShuffleResource().getMapPartitionShuffleDescriptor().getShuffleId();
            return this.resultPartitionFactory.create(ownerContext.getOwnerName(), index, resultPartitionDeploymentDescriptor, conf, this.shuffleIOMetricGroups.computeIfAbsent(shuffleId, k -> ShuffleIOMetricGroup.createShuffleIOMetricGroup(ownerContext, shuffleId, conf)));
        }
        this.nettyResultIds.add(resultPartitionDeploymentDescriptor.getResultId());
        this.nettyResultPartitionIds.add(resultPartitionDeploymentDescriptor.getPartitionId());
        return this.shuffleEnvironmentWrapper.nettyResultPartitionFactory().create(ownerContext.getOwnerName(), index, resultPartitionDeploymentDescriptor);
    }

    public void releasePartitionsLocally(Collection<ResultPartitionID> partitionIds) {
        List resultPartitionIds = partitionIds.stream().filter(partitionId -> this.nettyResultPartitionIds.contains(partitionId.getPartitionId())).collect(Collectors.toList());
        if (!resultPartitionIds.isEmpty()) {
            this.shuffleEnvironmentWrapper.nettyShuffleEnvironment().releasePartitionsLocally(resultPartitionIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IndexedInputGate> createInputGates(ShuffleIOOwnerContext ownerContext, PartitionProducerStateProvider producerStateProvider, List<InputGateDeploymentDescriptor> inputGateDescriptors) {
        Object object = this.lock;
        synchronized (object) {
            Utils.checkState(!this.isClosed, "The RemoteShuffleEnvironment has already been shut down.");
            InputChannelMetrics inputChannelMetrics = new InputChannelMetrics(new MetricGroup[]{ownerContext.getInputGroup(), ownerContext.getParentGroup()});
            IndexedInputGate[] inputGates = new IndexedInputGate[inputGateDescriptors.size()];
            for (int gateIndex = 0; gateIndex < inputGates.length; ++gateIndex) {
                IndexedInputGate inputGate;
                InputGateDeploymentDescriptor igdd = inputGateDescriptors.get(gateIndex);
                inputGates[gateIndex] = inputGate = this.createInputGateInternal(ownerContext, producerStateProvider, gateIndex, igdd, inputChannelMetrics, this.shuffleIOMetricGroups);
            }
            return Arrays.asList(inputGates);
        }
    }

    private IndexedInputGate createInputGateInternal(ShuffleIOOwnerContext ownerContext, PartitionProducerStateProvider producerStateProvider, int gateIndex, InputGateDeploymentDescriptor igdd, InputChannelMetrics inputChannelMetrics, Map<Integer, ShuffleIOMetricGroup> shuffleIOMetricGroups) {
        return this.nettyResultIds.contains(igdd.getConsumedResultId()) ? this.shuffleEnvironmentWrapper.nettyInputGateFactory().create(ownerContext, gateIndex, igdd, producerStateProvider, inputChannelMetrics) : this.inputGateFactory.create(ownerContext, gateIndex, igdd, shuffleIOMetricGroups);
    }

    @VisibleForTesting
    AbstractRemoteShuffleResultPartitionFactory getResultPartitionFactory() {
        return this.resultPartitionFactory;
    }
}

