/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.tiered;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.plugin.flink.tiered.CelebornTierConsumerAgent;
import org.apache.celeborn.plugin.flink.tiered.CelebornTierMasterAgent;
import org.apache.celeborn.plugin.flink.tiered.CelebornTierProducerAgent;
import org.apache.celeborn.plugin.flink.utils.FlinkUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.io.disk.BatchShuffleReadBufferPool;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.TieredStorageNettyService;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageConsumerSpec;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemorySpec;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageResourceRegistry;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierConsumerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierMasterAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierProducerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierShuffleDescriptor;
import org.apache.flink.runtime.util.ConfigurationParserUtils;

public class CelebornTierFactory
implements TierFactory {
    private CelebornConf conf;
    private int bufferSizeBytes = -1;
    private static int NUM_BYTES_PER_SEGMENT = 0x800000;
    private static final String CELEBORN_TIER_NAME = CelebornTierFactory.class.getSimpleName();

    public void setup(Configuration configuration) {
        this.conf = FlinkUtils.toCelebornConf(configuration);
        this.bufferSizeBytes = ConfigurationParserUtils.getPageSize((Configuration)configuration);
    }

    public TieredStorageMemorySpec getMasterAgentMemorySpec() {
        return new TieredStorageMemorySpec((Object)CelebornTierFactory.getCelebornTierName(), 0);
    }

    public TieredStorageMemorySpec getProducerAgentMemorySpec() {
        return new TieredStorageMemorySpec((Object)CelebornTierFactory.getCelebornTierName(), 1);
    }

    public TieredStorageMemorySpec getConsumerAgentMemorySpec() {
        return new TieredStorageMemorySpec((Object)CelebornTierFactory.getCelebornTierName(), 0);
    }

    public TierMasterAgent createMasterAgent(TieredStorageResourceRegistry tieredStorageResourceRegistry) {
        return new CelebornTierMasterAgent(this.conf);
    }

    public TierProducerAgent createProducerAgent(int numPartitions, int numSubpartitions, TieredStoragePartitionId partitionId, String dataFileBasePath, boolean isBroadcastOnly, TieredStorageMemoryManager storageMemoryManager, TieredStorageNettyService nettyService, TieredStorageResourceRegistry resourceRegistry, BatchShuffleReadBufferPool bufferPool, ScheduledExecutorService ioExecutor, List<TierShuffleDescriptor> shuffleDescriptors, int maxRequestedBuffers) {
        return new CelebornTierProducerAgent(this.conf, partitionId, numPartitions, numSubpartitions, NUM_BYTES_PER_SEGMENT, this.bufferSizeBytes, storageMemoryManager, resourceRegistry, shuffleDescriptors);
    }

    public TierConsumerAgent createConsumerAgent(List<TieredStorageConsumerSpec> tieredStorageConsumerSpecs, List<TierShuffleDescriptor> shuffleDescriptors, TieredStorageNettyService nettyService) {
        return new CelebornTierConsumerAgent(this.conf, tieredStorageConsumerSpecs, shuffleDescriptors, this.bufferSizeBytes);
    }

    public static String getCelebornTierName() {
        return CELEBORN_TIER_NAME;
    }
}

