/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.GeneratedMessageV3;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.celeborn.common.meta.DiskFileInfo;
import org.apache.celeborn.common.protocol.PbSegmentStart;
import org.apache.celeborn.service.deploy.worker.storage.FlushNotifier;
import org.apache.celeborn.service.deploy.worker.storage.MapPartitionMetaHandler;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001\u0002\u000b\u0016\u0001\u0011B\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\te\u0001\u0011\t\u0011)A\u0005g!)a\u0007\u0001C\u0001o!91\b\u0001b\u0001\n\u0013a\u0004BB)\u0001A\u0003%Q\bC\u0005_\u0001\u0001\u0007\t\u0019!C\u0005?\"Ia\r\u0001a\u0001\u0002\u0004%Ia\u001a\u0005\n[\u0002\u0001\r\u0011!Q!\n\u0001D\u0011b\u001c\u0001A\u0002\u0003\u0007I\u0011\u00029\t\u0013u\u0004\u0001\u0019!a\u0001\n\u0013q\bBCA\u0001\u0001\u0001\u0007\t\u0011)Q\u0005c\"9\u00111\u0001\u0001\u0005B\u0005\u0015\u0001bBA\f\u0001\u0011%\u0011\u0011\u0004\u0005\b\u0003G\u0001A\u0011IA\u0013\u0011\u001d\ty\u0003\u0001C!\u0003cAq!a\u000e\u0001\t\u0003\nI\u0004C\u0004\u0002<\u0001!\t%!\u0010\t\u000f\u0005]\u0003\u0001\"\u0011\u0002Z!9\u0011Q\f\u0001\u0005B\u0005e\"AH*fO6,g\u000e^'baB\u000b'\u000f^5uS>tW*\u001a;b\u0011\u0006tG\r\\3s\u0015\t1r#A\u0004ti>\u0014\u0018mZ3\u000b\u0005aI\u0012AB<pe.,'O\u0003\u0002\u001b7\u00051A-\u001a9m_fT!\u0001H\u000f\u0002\u000fM,'O^5dK*\u0011adH\u0001\tG\u0016dWMY8s]*\u0011\u0001%I\u0001\u0007CB\f7\r[3\u000b\u0003\t\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0013\u0011\u0005\u0019:S\"A\u000b\n\u0005!*\"aF'baB\u000b'\u000f^5uS>tW*\u001a;b\u0011\u0006tG\r\\3s\u00031!\u0017n]6GS2,\u0017J\u001c4p!\tY\u0003'D\u0001-\u0015\tic&\u0001\u0003nKR\f'BA\u0018\u001e\u0003\u0019\u0019w.\\7p]&\u0011\u0011\u0007\f\u0002\r\t&\u001c8NR5mK&sgm\\\u0001\t]>$\u0018NZ5feB\u0011a\u0005N\u0005\u0003kU\u0011QB\u00127vg\"tu\u000e^5gS\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u00029si\u0002\"A\n\u0001\t\u000b%\u001a\u0001\u0019\u0001\u0016\t\u000bI\u001a\u0001\u0019A\u001a\u00027M,(\rU1si&$\u0018n\u001c8ICN\u001cF/\u0019:u'\u0016<W.\u001a8u+\u0005i\u0004\u0003\u0002 D\u000b.k\u0011a\u0010\u0006\u0003\u0001\u0006\u000bA!\u001e;jY*\t!)\u0001\u0003kCZ\f\u0017B\u0001#@\u0005\ri\u0015\r\u001d\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\u0006\u000bA\u0001\\1oO&\u0011!j\u0012\u0002\b\u0013:$XmZ3s!\tau*D\u0001N\u0015\u0005q\u0015!B:dC2\f\u0017B\u0001)N\u0005\u001d\u0011un\u001c7fC:\fAd];c!\u0006\u0014H/\u001b;j_:D\u0015m]*uCJ$8+Z4nK:$\b\u0005\u000b\u0002\u0006'B\u0011A\u000bX\u0007\u0002+*\u0011akV\u0001\fC:tw\u000e^1uS>t7O\u0003\u000201*\u0011\u0011LW\u0001\u0007O>|w\r\\3\u000b\u0003m\u000b1aY8n\u0013\tiVKA\tWSNL'\r\\3G_J$Vm\u001d;j]\u001e\fqc];c!\u0006\u0014H/\u001b;j_:\u0014UO\u001a4fe&sG-\u001a=\u0016\u0003\u0001\u00042\u0001T1d\u0013\t\u0011WJA\u0003BeJ\f\u0017\u0010\u0005\u0002MI&\u0011Q-\u0014\u0002\u0004\u0013:$\u0018aG:vEB\u000b'\u000f^5uS>t')\u001e4gKJLe\u000eZ3y?\u0012*\u0017\u000f\u0006\u0002iWB\u0011A*[\u0005\u0003U6\u0013A!\u00168ji\"9AnBA\u0001\u0002\u0004\u0001\u0017a\u0001=%c\u0005A2/\u001e2QCJ$\u0018\u000e^5p]\n+hMZ3s\u0013:$W\r\u001f\u0011)\u0005!\u0019\u0016a\u00033bi\u0006DU-\u00193feN,\u0012!\u001d\t\u0004ej\u001cgBA:y\u001d\t!x/D\u0001v\u0015\t18%\u0001\u0004=e>|GOP\u0005\u0002\u001d&\u0011\u00110T\u0001\ba\u0006\u001c7.Y4f\u0013\tYHP\u0001\u0003MSN$(BA=N\u0003=!\u0017\r^1IK\u0006$WM]:`I\u0015\fHC\u00015\u0000\u0011\u001da'\"!AA\u0002E\fA\u0002Z1uC\"+\u0017\rZ3sg\u0002\n1\u0002[1oI2,WI^3oiR\u0019\u0001.a\u0002\t\u000f\u0005%A\u00021\u0001\u0002\f\u00059Q.Z:tC\u001e,\u0007\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005E\u0001,\u0001\u0005qe>$xNY;g\u0013\u0011\t)\"a\u0004\u0003%\u001d+g.\u001a:bi\u0016$W*Z:tC\u001e,gkM\u0001\rg\u0016<W.\u001a8u'R\f'\u000f\u001e\u000b\u0006Q\u0006m\u0011q\u0004\u0005\u0007\u0003;i\u0001\u0019A2\u0002\u001dM,(\rU1si&$\u0018n\u001c8JI\"1\u0011\u0011E\u0007A\u0002\r\f\u0011b]3h[\u0016tG/\u00133\u0002#A,8\u000f\u001b#bi\u0006D\u0015M\u001c3TQ\u0006\\W\rF\u0003i\u0003O\tY\u0003\u0003\u0004\u0002*9\u0001\raY\u0001\u0011]Vl7+\u001e2qCJ$\u0018\u000e^5p]NDa!!\f\u000f\u0001\u0004\u0019\u0017A\u00032vM\u001a,'oU5{K\u0006Q\u0011M\u001a;fe\u001acWo\u001d5\u0015\u0007!\f\u0019\u0004\u0003\u0004\u00026=\u0001\raY\u0001\u0005g&TX-\u0001\u0006bMR,'o\u00117pg\u0016$\u0012\u0001[\u0001\fE\u00164wN]3Xe&$X\rF\u0002i\u0003\u007fAq!!\u0011\u0012\u0001\u0004\t\u0019%A\u0003csR,7\u000f\u0005\u0003\u0002F\u0005MSBAA$\u0015\u0011\tI%a\u0013\u0002\r\t,hMZ3s\u0015\u0011\ti%a\u0014\u0002\u000b9,G\u000f^=\u000b\u0005\u0005E\u0013AA5p\u0013\u0011\t)&a\u0012\u0003\u000f\tKH/\u001a\"vM\u0006Q\u0011M\u001a;fe^\u0013\u0018\u000e^3\u0015\u0007!\fY\u0006\u0003\u0004\u00026I\u0001\raY\u0001\u000eE\u00164wN]3EKN$(o\\=")
public class SegmentMapPartitionMetaHandler
extends MapPartitionMetaHandler {
    private final DiskFileInfo diskFileInfo;
    @VisibleForTesting
    private final Map<Integer, Object> subPartitionHasStartSegment;
    @VisibleForTesting
    private int[] subPartitionBufferIndex;
    private List<Object> dataHeaders;

    private Map<Integer, Object> subPartitionHasStartSegment() {
        return this.subPartitionHasStartSegment;
    }

    private int[] subPartitionBufferIndex() {
        return this.subPartitionBufferIndex;
    }

    private void subPartitionBufferIndex_$eq(int[] x$1) {
        this.subPartitionBufferIndex = x$1;
    }

    private List<Object> dataHeaders() {
        return this.dataHeaders;
    }

    private void dataHeaders_$eq(List<Object> x$1) {
        this.dataHeaders = x$1;
    }

    @Override
    public void handleEvent(GeneratedMessageV3 message) {
        super.handleEvent(message);
        GeneratedMessageV3 generatedMessageV3 = message;
        if (generatedMessageV3 instanceof PbSegmentStart) {
            PbSegmentStart pbSegmentStart = (PbSegmentStart)generatedMessageV3;
            this.segmentStart(pbSegmentStart.getSubPartitionId(), pbSegmentStart.getSegmentId());
            return;
        }
    }

    private void segmentStart(int subPartitionId, int segmentId) {
        this.fileMeta().addPartitionSegmentId(subPartitionId, segmentId);
        this.subPartitionHasStartSegment().put(Predef$.MODULE$.int2Integer(subPartitionId), BoxesRunTime.boxToBoolean((boolean)true));
    }

    @Override
    public void pushDataHandShake(int numSubpartitions, int bufferSize) {
        super.pushDataHandShake(numSubpartitions, bufferSize);
        this.subPartitionBufferIndex_$eq(new int[numSubpartitions]);
        Arrays.fill(this.subPartitionBufferIndex(), 0);
        this.fileMeta().setIsWriterClosed(false);
        this.fileMeta().setSegmentGranularityVisible(true);
    }

    @Override
    public void afterFlush(int size) {
        this.diskFileInfo.updateBytesFlushed((long)size);
    }

    @Override
    public void afterClose() {
        this.subPartitionHasStartSegment().clear();
        super.afterClose();
        this.logger().debug(new StringBuilder(16).append("Close ").append(this).append(" for file ").append(this.diskFileInfo.getFile()).toString());
        this.fileMeta().setIsWriterClosed(true);
    }

    @Override
    public void beforeWrite(ByteBuf bytes) {
        bytes.markReaderIndex();
        int subPartitionId = bytes.readInt();
        int attemptId = bytes.readInt();
        int batchId = bytes.readInt();
        int size = bytes.readInt();
        this.dataHeaders_$eq((List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{subPartitionId, attemptId, batchId, size})));
        if (!this.subPartitionHasStartSegment().containsKey(BoxesRunTime.boxToInteger((int)subPartitionId))) {
            throw new IllegalStateException(String.format(new StringBuilder(81).append("This partition may not start a segment: subPartitionId:").append(subPartitionId).append(" attemptId:").append(attemptId).append(" batchId:").append(batchId).append(" size:").append(size).toString(), new Object[0]));
        }
        int currentSubpartition = this.getCurrentSubpartition();
        if (subPartitionId < currentSubpartition) {
            throw new IOException(String.format(new StringBuilder(151).append("Must writing data in reduce partition index order, but now supPartitionId is ").append(subPartitionId).append(" and the previous supPartitionId is ").append(currentSubpartition).append(", attemptId is ").append(attemptId).append(", batchId is ").append(batchId).append(", size is ").append(size).toString(), new Object[0]));
        }
        bytes.resetReaderIndex();
        this.logger().debug(new StringBuilder(87).append("map partition filename:").append(this.diskFileInfo.getFilePath()).append(" write partition:").append(subPartitionId).append(" currentSubPartition:").append(currentSubpartition).append(" attemptId:").append(attemptId).append(" batchId:").append(batchId).append(" size:").append(size).toString());
        if (subPartitionId > currentSubpartition) {
            this.setCurrentSubpartition(subPartitionId);
        }
        int length = bytes.readableBytes();
        this.setTotalBytes(this.getTotalBytes() + (long)length);
        long[] lArray = this.getNumSubpartitionBytes();
        lArray[subPartitionId] = lArray[subPartitionId] + (long)length;
    }

    @Override
    public void afterWrite(int size) {
        Object object;
        super.afterWrite(size);
        this.setRegionFinished(false);
        int subPartitionId = BoxesRunTime.unboxToInt((Object)this.dataHeaders().apply(0));
        int attemptId = BoxesRunTime.unboxToInt((Object)this.dataHeaders().apply(1));
        if (BoxesRunTime.unboxToBoolean((Object)this.subPartitionHasStartSegment().get(BoxesRunTime.boxToInteger((int)subPartitionId)))) {
            this.fileMeta().addSegmentIdAndFirstBufferIndex(subPartitionId, this.subPartitionBufferIndex()[subPartitionId], this.fileMeta().getPartitionWritingSegmentId(subPartitionId));
            this.logger().debug(new StringBuilder(80).append("Add a segment id, partitionId:").append(subPartitionId).append(", ").append("bufferIndex:").append(this.subPartitionBufferIndex()[subPartitionId]).append(", ").append("segmentId:").append(this.fileMeta().getPartitionWritingSegmentId(subPartitionId)).append(", ").append("filename:").append(this.diskFileInfo.getFilePath()).append(", ").append("attemptId:").append(attemptId).append(".").toString());
            object = this.subPartitionHasStartSegment().put(Predef$.MODULE$.int2Integer(subPartitionId), BoxesRunTime.boxToBoolean((boolean)false));
        } else {
            object = BoxedUnit.UNIT;
        }
        int[] nArray = this.subPartitionBufferIndex();
        nArray[subPartitionId] = nArray[subPartitionId] + 1;
    }

    @Override
    public void beforeDestroy() {
        super.beforeDestroy();
    }

    public SegmentMapPartitionMetaHandler(DiskFileInfo diskFileInfo, FlushNotifier notifier) {
        this.diskFileInfo = diskFileInfo;
        super(diskFileInfo, notifier);
        this.subPartitionHasStartSegment = new HashMap<Integer, Object>();
    }
}

