/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.buffer;

import java.util.List;
import org.apache.celeborn.common.meta.ReduceFileMeta;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.celeborn.shaded.com.google.common.base.Preconditions;
import scala.Tuple2;

public abstract class ChunkBuffers {
    protected long[] offsets;
    protected int numChunks;

    public int numChunks() {
        return this.numChunks;
    }

    public ChunkBuffers(ReduceFileMeta reduceFileMeta) {
        this.numChunks = reduceFileMeta.getNumChunks();
        if (this.numChunks > 0) {
            this.offsets = new long[this.numChunks + 1];
            List<Long> chunkOffsets = reduceFileMeta.getChunkOffsets();
            for (int i = 0; i <= this.numChunks; ++i) {
                this.offsets[i] = chunkOffsets.get(i);
            }
        } else {
            this.offsets = new long[]{0L};
        }
    }

    public Tuple2<Long, Long> getChunkOffsetLength(int chunkIndex, int offset, int len) {
        long chunkOffset = this.offsets[chunkIndex];
        long chunkLength = this.offsets[chunkIndex + 1] - chunkOffset;
        Preconditions.checkArgument((long)offset < chunkLength);
        long length = Math.min(chunkLength - (long)offset, (long)len);
        return new Tuple2((Object)(chunkOffset + (long)offset), (Object)length);
    }

    public abstract ManagedBuffer chunk(int var1, int var2, int var3);
}

