/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink;

import java.time.Duration;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.plugin.flink.RemoteShuffleMaster;
import org.apache.celeborn.plugin.flink.metric.RemoteShuffleMetricFactory;
import org.apache.celeborn.plugin.flink.utils.FlinkUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.io.network.NettyShuffleServiceFactory;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleEnvironment;
import org.apache.flink.runtime.shuffle.ShuffleEnvironmentContext;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.runtime.shuffle.ShuffleMasterContext;
import org.apache.flink.runtime.shuffle.ShuffleServiceFactory;
import org.apache.flink.runtime.util.ConfigurationParserUtils;

public abstract class AbstractRemoteShuffleServiceFactory
implements ShuffleServiceFactory<ShuffleDescriptor, ResultPartitionWriter, IndexedInputGate> {
    public final NettyShuffleServiceFactory nettyShuffleServiceFactory = new NettyShuffleServiceFactory();

    public ShuffleMaster<ShuffleDescriptor> createShuffleMaster(ShuffleMasterContext shuffleMasterContext) {
        return new RemoteShuffleMaster(shuffleMasterContext, this.nettyShuffleServiceFactory);
    }

    public abstract ShuffleEnvironment<ResultPartitionWriter, IndexedInputGate> createShuffleEnvironment(ShuffleEnvironmentContext var1);

    private int calculateNumberOfNetworkBuffers(MemorySize memorySize, int bufferSize) {
        long numBuffersLong = memorySize.getBytes() / (long)bufferSize;
        if (numBuffersLong > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The given number of memory bytes (" + memorySize.getBytes() + ") corresponds to more than MAX_INT pages.");
        }
        return (int)numBuffersLong;
    }

    protected AbstractRemoteShuffleServiceParameters initializePreCreateShuffleEnvironment(ShuffleEnvironmentContext shuffleEnvironmentContext) {
        Configuration configuration = shuffleEnvironmentContext.getConfiguration();
        int bufferSize = ConfigurationParserUtils.getPageSize((Configuration)configuration);
        int numBuffers = this.calculateNumberOfNetworkBuffers(shuffleEnvironmentContext.getNetworkMemorySize(), bufferSize);
        ResultPartitionManager resultPartitionManager = new ResultPartitionManager();
        MetricGroup metricGroup = shuffleEnvironmentContext.getParentMetricGroup();
        Duration requestSegmentsTimeout = this.getRequestSegmentsTimeout(configuration);
        NetworkBufferPool networkBufferPool = new NetworkBufferPool(numBuffers, bufferSize, requestSegmentsTimeout);
        RemoteShuffleMetricFactory.registerShuffleMetrics(metricGroup, networkBufferPool);
        CelebornConf celebornConf = FlinkUtils.toCelebornConf(configuration);
        AbstractRemoteShuffleServiceParameters result = new AbstractRemoteShuffleServiceParameters(configuration, bufferSize, resultPartitionManager, networkBufferPool, celebornConf);
        return result;
    }

    abstract Duration getRequestSegmentsTimeout(Configuration var1);

    protected static class AbstractRemoteShuffleServiceParameters {
        public final Configuration configuration;
        public final int bufferSize;
        public final ResultPartitionManager resultPartitionManager;
        public final NetworkBufferPool networkBufferPool;
        public final CelebornConf celebornConf;

        public AbstractRemoteShuffleServiceParameters(Configuration configuration, int bufferSize, ResultPartitionManager resultPartitionManager, NetworkBufferPool networkBufferPool, CelebornConf celebornConf) {
            this.configuration = configuration;
            this.bufferSize = bufferSize;
            this.resultPartitionManager = resultPartitionManager;
            this.networkBufferPool = networkBufferPool;
            this.celebornConf = celebornConf;
        }
    }
}

