/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.http.authentication;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.authentication.AnonymousAuthenticationProviderImpl;
import org.apache.celeborn.common.authentication.DefaultPasswordCredential;
import org.apache.celeborn.common.authentication.HttpAuthSchemes$;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.server.common.http.HttpAuthUtils$;
import org.apache.celeborn.server.common.http.authentication.AuthenticationHandler;
import org.apache.celeborn.server.common.http.authentication.HttpAuthenticationFactory$;
import org.apache.celeborn.spi.authentication.PasswdAuthenticationProvider;
import org.apache.celeborn.spi.authentication.PasswordCredential;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001\u0002\t\u0012\u0001\u0001B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\u0006}\u0001!\ta\u0010\u0005\n\u0005\u0002\u0001\r\u00111A\u0005\n\rC\u0011\u0002\u0013\u0001A\u0002\u0003\u0007I\u0011B%\t\u0013=\u0003\u0001\u0019!A!B\u0013!\u0005b\u0002)\u0001\u0005\u0004%I!\u0015\u0005\u0007+\u0002\u0001\u000b\u0011\u0002*\t\u000fY\u0003!\u0019!C!/\"1!\u000e\u0001Q\u0001\naCQa\u001b\u0001\u0005B1DQA\u001c\u0001\u0005BECQa\u001c\u0001\u0005BADQa\u001d\u0001\u0005BQDq!!\u0001\u0001\t\u0003\n\u0019\u0001C\u0004\u0002\u0012\u0001!\t%a\u0005\u00035\t\u000b7/[2BkRDWM\u001c;jG\u0006$\u0018n\u001c8IC:$G.\u001a:\u000b\u0005I\u0019\u0012AD1vi\",g\u000e^5dCRLwN\u001c\u0006\u0003)U\tA\u0001\u001b;ua*\u0011acF\u0001\u0007G>lWn\u001c8\u000b\u0005aI\u0012AB:feZ,'O\u0003\u0002\u001b7\u0005A1-\u001a7fE>\u0014hN\u0003\u0002\u001d;\u00051\u0011\r]1dQ\u0016T\u0011AH\u0001\u0004_J<7\u0001A\n\u0005\u0001\u0005:3\u0006\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0004B]f\u0014VM\u001a\t\u0003Q%j\u0011!E\u0005\u0003UE\u0011Q#Q;uQ\u0016tG/[2bi&|g\u000eS1oI2,'\u000f\u0005\u0002-a5\tQF\u0003\u0002/_\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u00173%\u0011\u0011'\f\u0002\b\u0019><w-\u001b8h\u00035\u0001(o\u001c<jI\u0016\u00148\t\\1tgB\u0011Ag\u000f\b\u0003ke\u0002\"AN\u0012\u000e\u0003]R!\u0001O\u0010\u0002\rq\u0012xn\u001c;?\u0013\tQ4%\u0001\u0004Qe\u0016$WMZ\u0005\u0003yu\u0012aa\u0015;sS:<'B\u0001\u001e$\u0003\u0019a\u0014N\\5u}Q\u0011\u0001)\u0011\t\u0003Q\u0001AQA\r\u0002A\u0002M\nAaY8oMV\tA\t\u0005\u0002F\r6\tq&\u0003\u0002H_\ta1)\u001a7fE>\u0014hnQ8oM\u0006A1m\u001c8g?\u0012*\u0017\u000f\u0006\u0002K\u001bB\u0011!eS\u0005\u0003\u0019\u000e\u0012A!\u00168ji\"9a\nBA\u0001\u0002\u0004!\u0015a\u0001=%c\u0005)1m\u001c8gA\u0005q\u0011\r\u001c7po\u0006swN\\=n_V\u001cX#\u0001*\u0011\u0005\t\u001a\u0016B\u0001+$\u0005\u001d\u0011un\u001c7fC:\fq\"\u00197m_^\fen\u001c8z[>,8\u000fI\u0001\u000bCV$\bnU2iK6,W#\u0001-\u0011\u0005e;gB\u0001.e\u001d\tY6M\u0004\u0002]E:\u0011Q,\u0019\b\u0003=\u0002t!AN0\n\u0003yI!\u0001H\u000f\n\u0005iY\u0012B\u0001\f\u001a\u0013\t\u0011r&\u0003\u0002fM\u0006y\u0001\n\u001e;q\u0003V$\bnU2iK6,7O\u0003\u0002\u0013_%\u0011\u0001.\u001b\u0002\u000f\u0011R$\b/Q;uQN\u001b\u0007.Z7f\u0015\t)g-A\u0006bkRD7k\u00195f[\u0016\u0004\u0013\u0001B5oSR$\"AS7\t\u000b\tS\u0001\u0019\u0001#\u0002/\u0005,H\u000f[3oi&\u001c\u0017\r^5p]N+\b\u000f]8si\u0016$\u0017aD7bi\u000eD\u0017)\u001e;i'\u000eDW-\\3\u0015\u0005I\u000b\b\"\u0002:\r\u0001\u0004\u0019\u0014!D1vi\"|'/\u001b>bi&|g.\u0001\thKR\fU\u000f\u001e5pe&T\u0018\r^5p]R\u00111'\u001e\u0005\u0006m6\u0001\ra^\u0001\be\u0016\fX/Z:u!\tAh0D\u0001z\u0015\t!\"P\u0003\u0002|y\u000691/\u001a:wY\u0016$(\"A?\u0002\u000b)\fg/\u0019=\n\u0005}L(A\u0005%uiB\u001cVM\u001d<mKR\u0014V-];fgR\fA\"Y;uQ\u0016tG/[2bi\u0016$RaMA\u0003\u0003\u000fAQA\u001e\bA\u0002]Dq!!\u0003\u000f\u0001\u0004\tY!\u0001\u0005sKN\u0004xN\\:f!\rA\u0018QB\u0005\u0004\u0003\u001fI(a\u0005%uiB\u001cVM\u001d<mKR\u0014Vm\u001d9p]N,\u0017a\u00023fgR\u0014x.\u001f\u000b\u0002\u0015\u0002")
public class BasicAuthenticationHandler
implements AuthenticationHandler,
Logging {
    private final String providerClass;
    private CelebornConf conf;
    private final boolean allowAnonymous;
    private final Enumeration.Value authScheme;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        BasicAuthenticationHandler basicAuthenticationHandler = this;
        synchronized (basicAuthenticationHandler) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    private CelebornConf conf() {
        return this.conf;
    }

    private void conf_$eq(CelebornConf x$1) {
        this.conf = x$1;
    }

    private boolean allowAnonymous() {
        return this.allowAnonymous;
    }

    @Override
    public Enumeration.Value authScheme() {
        return this.authScheme;
    }

    @Override
    public void init(CelebornConf conf) {
        this.conf_$eq(conf);
    }

    @Override
    public boolean authenticationSupported() {
        return Option$.MODULE$.apply((Object)this.providerClass).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BasicAuthenticationHandler.$anonfun$authenticationSupported$1(this, x$1)));
    }

    @Override
    public boolean matchAuthScheme(String authorization) {
        if (authorization == null || authorization.isEmpty()) {
            return this.allowAnonymous();
        }
        return AuthenticationHandler.matchAuthScheme$(this, authorization);
    }

    @Override
    public String getAuthorization(HttpServletRequest request) {
        String authHeader = request.getHeader(HttpAuthUtils$.MODULE$.AUTHORIZATION_HEADER());
        if (this.allowAnonymous() && (authHeader == null || authHeader.isEmpty())) {
            return "";
        }
        return AuthenticationHandler.getAuthorization$(this, request);
    }

    @Override
    public String authenticate(HttpServletRequest request, HttpServletResponse response) {
        String authUser = null;
        String authorization = this.getAuthorization(request);
        byte[] inputToken = (byte[])Option$.MODULE$.apply((Object)authorization).map((Function1 & Serializable & scala.Serializable)a -> Base64.getDecoder().decode(a.getBytes())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
        String[] creds = new String(inputToken, StandardCharsets.UTF_8).split(":");
        if (this.allowAnonymous()) {
            authUser = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])creds)).take(1))).headOption().filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        } else if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])creds)).size() < 2 || creds[0].trim().isEmpty() || creds[1].trim().isEmpty()) {
            response.setHeader(HttpAuthUtils$.MODULE$.WWW_AUTHENTICATE_HEADER(), this.authScheme().toString());
            response.setStatus(401);
        } else {
            Seq seq = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])creds)).toSeq().take(2);
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)seq);
            }
            String user = (String)((SeqLike)some.get()).apply(0);
            String password = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple2 = new Tuple2((Object)user, (Object)password);
            String user2 = (String)tuple2._1();
            String password2 = (String)tuple2._2();
            PasswdAuthenticationProvider passwdAuthenticationProvider = HttpAuthenticationFactory$.MODULE$.getPasswordAuthenticationProvider(this.providerClass, this.conf());
            authUser = passwdAuthenticationProvider.authenticate((PasswordCredential)new DefaultPasswordCredential(user2, password2, HttpAuthUtils$.MODULE$.getCredentialExtraInfo())).getName();
            response.setStatus(200);
        }
        return authUser;
    }

    @Override
    public void destroy() {
    }

    public static final /* synthetic */ boolean $anonfun$authenticationSupported$1(BasicAuthenticationHandler $this, String x$1) {
        boolean bl;
        try {
            Class.forName($this.providerClass).isAssignableFrom(PasswdAuthenticationProvider.class);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    public BasicAuthenticationHandler(String providerClass) {
        this.providerClass = providerClass;
        AuthenticationHandler.$init$(this);
        Logging.$init$((Logging)this);
        String string = AnonymousAuthenticationProviderImpl.class.getName();
        String string2 = providerClass;
        this.allowAnonymous = !(string != null ? !string.equals(string2) : string2 != null);
        this.authScheme = HttpAuthSchemes$.MODULE$.BASIC();
    }
}

