/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail2.javax;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.activation.DataHandler;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.mail2.javax.settings.EmailConfiguration;
import org.apache.commons.mail2.javax.util.MimeMessageUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;

public abstract class AbstractEmailTest {
    public static final int BODY_END_PAD = 3;
    public static final int BODY_START_PAD = 2;
    private static final String LINE_SEPARATOR = "\r\n";
    private static int mailServerPort = 2500;
    private static int fileNameCounter;
    protected Wiser fakeMailServer;
    protected String strTestMailServer = "localhost";
    protected String strTestMailFrom = "test_from@apache.org";
    protected String strTestMailTo = "test_to@apache.org";
    protected String strTestUser = "user";
    protected String strTestPasswd = "password";
    protected String strTestURL = EmailConfiguration.TEST_URL;
    protected String[] testCharsValid = new String[]{" ", "a", "A", "\uc5ec", "0123456789", "012345678901234567890"};
    protected String[] endOfLineCombinations = new String[]{"\n", "\r", "\r\n", "\n\r"};
    protected String[] testCharsNotValid = new String[]{"", null};
    private File emailOutputDir;

    protected URL createInvalidURL() throws Exception {
        URL url = new URL("http://example.invalid");
        url = (URL)Mockito.spy((Object)url);
        ((URL)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Mocked IOException")}).when((Object)url)).openStream();
        return url;
    }

    public void getMailServer() {
        if (this.fakeMailServer == null || this.isMailServerStopped(this.fakeMailServer)) {
            ++mailServerPort;
            this.fakeMailServer = new Wiser();
            this.fakeMailServer.setPort(this.getMailServerPort());
            this.fakeMailServer.start();
            Assertions.assertFalse((boolean)this.isMailServerStopped(this.fakeMailServer), (String)"fake mail server didn't start");
            Date dtStartWait = new Date();
            while (this.isMailServerStopped(this.fakeMailServer) && (this.fakeMailServer == null || this.isMailServerStopped(this.fakeMailServer))) {
                if (dtStartWait.getTime() + 500L > new Date().getTime()) continue;
                Assertions.fail((String)"Mail server failed to start");
            }
        }
    }

    protected int getMailServerPort() {
        return mailServerPort;
    }

    public String getMessageAsString(int intMsgNo) {
        List receivedMessages = this.fakeMailServer.getMessages();
        Assertions.assertTrue((receivedMessages.size() >= intMsgNo ? 1 : 0) != 0, (String)"mail server didn't get enough messages");
        WiserMessage emailMessage = (WiserMessage)receivedMessages.get(intMsgNo);
        if (emailMessage != null) {
            try {
                return this.serializeEmailMessage(emailMessage);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Assertions.fail((String)"Message not found");
        return "";
    }

    private String getMessageBody(WiserMessage wiserMessage) throws IOException {
        if (wiserMessage == null) {
            return "";
        }
        byte[] messageBody = null;
        try {
            MimeMessage message = wiserMessage.getMimeMessage();
            messageBody = this.getMessageBodyBytes(message);
        }
        catch (MessagingException e) {
            IllegalStateException rethrow = new IllegalStateException("couldn't process MimeMessage from WiserMessage in getMessageBody()");
            rethrow.initCause(e);
            throw rethrow;
        }
        return messageBody != null ? new String(messageBody).intern() : "";
    }

    private byte[] getMessageBodyBytes(MimeMessage mimeMessage) throws IOException, MessagingException {
        DataHandler dataHandler = mimeMessage.getDataHandler();
        ByteArrayOutputStream byteArrayOutStream = new ByteArrayOutputStream();
        BufferedOutputStream buffOs = new BufferedOutputStream(byteArrayOutStream);
        dataHandler.writeTo((OutputStream)buffOs);
        buffOs.flush();
        return byteArrayOutStream.toByteArray();
    }

    protected boolean isMailServerStopped(Wiser fakeMailServer) {
        return !fakeMailServer.getServer().isRunning();
    }

    protected void saveEmailToFile(WiserMessage email) throws IOException, MessagingException {
        int currCounter = fileNameCounter++ % 10;
        String emailFileName = "email" + new Date().getTime() + "-" + currCounter + ".eml";
        File emailFile = new File(this.emailOutputDir, emailFileName);
        MimeMessageUtils.writeMimeMessage((MimeMessage)email.getMimeMessage(), (File)emailFile);
    }

    private String serializeEmailMessage(WiserMessage wiserMessage) throws MessagingException, IOException {
        if (wiserMessage == null) {
            return "";
        }
        StringBuilder serializedEmail = new StringBuilder();
        MimeMessage message = wiserMessage.getMimeMessage();
        Enumeration headers = message.getAllHeaders();
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            serializedEmail.append(header.getName());
            serializedEmail.append(": ");
            serializedEmail.append(header.getValue());
            serializedEmail.append(LINE_SEPARATOR);
        }
        byte[] messageBody = this.getMessageBodyBytes(message);
        serializedEmail.append(LINE_SEPARATOR);
        serializedEmail.append(messageBody);
        serializedEmail.append(LINE_SEPARATOR);
        return serializedEmail.toString();
    }

    @BeforeEach
    public void setUpAbstractEmailTest() {
        this.emailOutputDir = new File("target/test-emails");
        if (!this.emailOutputDir.exists()) {
            this.emailOutputDir.mkdirs();
        }
    }

    protected void stopServer() {
        if (this.fakeMailServer != null) {
            this.fakeMailServer.stop();
        }
    }

    @AfterEach
    public void tearDownEmailTest() {
        if (this.fakeMailServer != null && !this.isMailServerStopped(this.fakeMailServer)) {
            this.fakeMailServer.stop();
            Assertions.assertTrue((boolean)this.isMailServerStopped(this.fakeMailServer), (String)"Mail server didn't stop");
        }
        this.fakeMailServer = null;
    }

    protected WiserMessage validateSend(Wiser mailServer, String strSubject, InternetAddress fromAdd, List<InternetAddress> toAdd, List<InternetAddress> ccAdd, List<InternetAddress> bccAdd, boolean boolSaveToFile) throws IOException {
        Assertions.assertTrue((mailServer.getMessages().size() == 1 ? 1 : 0) != 0, (String)"mail server doesn't contain expected message");
        WiserMessage emailMessage = (WiserMessage)mailServer.getMessages().get(0);
        if (boolSaveToFile) {
            try {
                this.saveEmailToFile(emailMessage);
            }
            catch (MessagingException e) {
                IllegalStateException rethrow = new IllegalStateException("caught MessagingException during saving the email");
                rethrow.initCause(e);
                throw rethrow;
            }
        }
        try {
            MimeMessage mimeMessage = emailMessage.getMimeMessage();
            Assertions.assertEquals((Object)strSubject, (Object)mimeMessage.getHeader("Subject", null), (String)"got wrong subject from mail");
            Assertions.assertEquals((Object)fromAdd.toString(), (Object)mimeMessage.getHeader("From", null), (String)"got wrong From: address from mail");
            Assertions.assertTrue((boolean)toAdd.toString().contains(mimeMessage.getHeader("To", null)), (String)"got wrong To: address from mail");
            if (!ccAdd.isEmpty()) {
                Assertions.assertTrue((boolean)ccAdd.toString().contains(mimeMessage.getHeader("Cc", null)), (String)"got wrong Cc: address from mail");
            }
            if (!bccAdd.isEmpty()) {
                Assertions.assertTrue((boolean)bccAdd.toString().contains(mimeMessage.getHeader("Bcc", null)), (String)"got wrong Bcc: address from mail");
            }
        }
        catch (MessagingException e) {
            IllegalStateException rethrow = new IllegalStateException("caught MessagingException in validateSend()");
            rethrow.initCause(e);
            throw rethrow;
        }
        return emailMessage;
    }

    protected void validateSend(Wiser mailServer, String strSubject, Multipart content, InternetAddress fromAdd, List<InternetAddress> toAdd, List<InternetAddress> ccAdd, List<InternetAddress> bccAdd, boolean boolSaveToFile) throws IOException {
        WiserMessage emailMessage = this.validateSend(mailServer, strSubject, fromAdd, toAdd, ccAdd, bccAdd, boolSaveToFile);
        String strSentContent = content.getContentType();
        String emailMessageBody = this.getMessageBody(emailMessage);
        String strMessageBody = emailMessageBody.substring(2, emailMessageBody.length() - 3);
        Assertions.assertTrue((boolean)strMessageBody.contains(strSentContent), (String)"didn't find expected content type in message body");
    }

    protected void validateSend(Wiser mailServer, String strSubject, String strMessage, InternetAddress fromAdd, List<InternetAddress> toAdd, List<InternetAddress> ccAdd, List<InternetAddress> bccAdd, boolean boolSaveToFile) throws IOException {
        WiserMessage emailMessage = this.validateSend(mailServer, strSubject, fromAdd, toAdd, ccAdd, bccAdd, true);
        Assertions.assertTrue((boolean)this.getMessageBody(emailMessage).contains(strMessage), (String)"didn't find expected message content in message body");
    }
}

