/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail2.javax.resolver;

import java.io.File;
import java.io.IOException;
import org.apache.commons.mail2.javax.DataSourceResolver;
import org.apache.commons.mail2.javax.resolver.AbstractDataSourceResolverTest;
import org.apache.commons.mail2.javax.resolver.DataSourceFileResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataSourceFileResolverTest
extends AbstractDataSourceResolverTest {
    @Test
    public void testResolveLenient() throws Exception {
        DataSourceFileResolver dataSourceResolver = new DataSourceFileResolver(new File("./src/test/resources"), true);
        Assertions.assertEquals((int)5866, (int)this.toByteArray(dataSourceResolver.resolve("images/asf_logo_wide.gif")).length);
        Assertions.assertEquals((int)5866, (int)this.toByteArray(dataSourceResolver.resolve("./images/asf_logo_wide.gif")).length);
        Assertions.assertEquals((int)5866, (int)this.toByteArray(dataSourceResolver.resolve("../resources/images/asf_logo_wide.gif")).length);
        Assertions.assertNull((Object)this.toByteArray(dataSourceResolver.resolve("/images/does-not-exist.gif")));
        Assertions.assertNull((Object)dataSourceResolver.resolve("./images/does-not-exist.gif"));
    }

    @Test
    public void testResolveStrict() throws Exception {
        DataSourceFileResolver dataSourceResolver = new DataSourceFileResolver(new File("."), false);
        Assertions.assertNotNull((Object)dataSourceResolver.resolve("./src/test/resources/images/asf_logo_wide.gif"));
        Assertions.assertThrows(IOException.class, () -> DataSourceFileResolverTest.lambda$testResolveStrict$0((DataSourceResolver)dataSourceResolver));
    }

    private static /* synthetic */ void lambda$testResolveStrict$0(DataSourceResolver dataSourceResolver) throws Throwable {
        dataSourceResolver.resolve("asf_logo_wide.gif");
    }
}

