/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.ByteConversions;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.tiff.AbstractTiffElement;
import org.apache.commons.imaging.formats.tiff.AbstractTiffImageData;
import org.apache.commons.imaging.formats.tiff.AbstractTiffRasterData;
import org.apache.commons.imaging.formats.tiff.JpegImageData;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImageParser;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.fieldtypes.AbstractFieldType;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoAscii;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoByte;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoBytes;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoDouble;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoDoubles;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoFloat;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoFloats;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoGpsText;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoLong;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoLongs;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoRational;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoRationals;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoSByte;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoSBytes;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoSLong;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoSLongs;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoSRational;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoSRationals;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoSShort;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoSShorts;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoShort;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoShortOrLong;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoShorts;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoXpString;

public class TiffDirectory
extends AbstractTiffElement
implements Iterable<TiffField> {
    private final List<TiffField> entries;
    private final ByteOrder headerByteOrder;
    private JpegImageData jpegImageData;
    private final long nextDirectoryOffset;
    private AbstractTiffImageData abstractTiffImageData;
    public final int type;

    public static String description(int type) {
        switch (type) {
            case -1: {
                return "Unknown";
            }
            case 0: {
                return "Root";
            }
            case 1: {
                return "Sub";
            }
            case 2: {
                return "Thumbnail";
            }
            case -2: {
                return "Exif";
            }
            case -3: {
                return "Gps";
            }
            case -4: {
                return "Interoperability";
            }
        }
        return "Bad Type";
    }

    public TiffDirectory(int type, List<TiffField> entries, long offset, long nextDirectoryOffset, ByteOrder byteOrder) {
        super(offset, 2 + entries.size() * 12 + 4);
        this.type = type;
        this.entries = Collections.unmodifiableList(entries);
        this.nextDirectoryOffset = nextDirectoryOffset;
        this.headerByteOrder = byteOrder;
    }

    public String description() {
        return TiffDirectory.description(this.type);
    }

    public void dump() {
        this.entries.forEach(TiffField::dump);
    }

    public TiffField findField(TagInfo tag) throws ImagingException {
        boolean failIfMissing = false;
        return this.findField(tag, false);
    }

    public TiffField findField(TagInfo tag, boolean failIfMissing) throws ImagingException {
        for (TiffField field : this.entries) {
            if (field.getTag() != tag.tag) continue;
            return field;
        }
        if (failIfMissing) {
            throw new ImagingException("Missing expected field: " + tag.getDescription());
        }
        return null;
    }

    public ByteOrder getByteOrder() {
        return this.headerByteOrder;
    }

    public List<TiffField> getDirectoryEntries() {
        return new ArrayList<TiffField>(this.entries);
    }

    @Override
    public String getElementDescription() {
        long entryOffset = this.offset + 2L;
        StringBuilder result = new StringBuilder();
        for (TiffField entry : this.entries) {
            result.append(String.format("\t[%d]: %s (%d, 0x%x), %s, %d: %s%n", entryOffset, entry.getTagInfo().name, entry.getTag(), entry.getTag(), entry.getFieldType().getName(), entry.getBytesLength(), entry.getValueDescription()));
            entryOffset += 12L;
        }
        return result.toString();
    }

    public Object getFieldValue(TagInfo tag) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            return null;
        }
        return field.getValue();
    }

    public String[] getFieldValue(TagInfoAscii tag, boolean mustExist) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" is missing");
            }
            return null;
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
            }
            return null;
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public byte getFieldValue(TagInfoByte tag) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            throw new ImagingException("Required field \"" + tag.name + "\" is missing");
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
        }
        if (field.getCount() != 1L) {
            throw new ImagingException("Field \"" + tag.name + "\" has wrong count " + field.getCount());
        }
        return field.getByteArrayValue()[0];
    }

    public byte[] getFieldValue(TagInfoBytes tag, boolean mustExist) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" is missing");
            }
            return null;
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
            }
            return null;
        }
        return field.getByteArrayValue();
    }

    public double getFieldValue(TagInfoDouble tag) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            throw new ImagingException("Required field \"" + tag.name + "\" is missing");
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
        }
        if (field.getCount() != 1L) {
            throw new ImagingException("Field \"" + tag.name + "\" has wrong count " + field.getCount());
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public double[] getFieldValue(TagInfoDoubles tag, boolean mustExist) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" is missing");
            }
            return null;
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
            }
            return null;
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public float getFieldValue(TagInfoFloat tag) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            throw new ImagingException("Required field \"" + tag.name + "\" is missing");
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
        }
        if (field.getCount() != 1L) {
            throw new ImagingException("Field \"" + tag.name + "\" has wrong count " + field.getCount());
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public float[] getFieldValue(TagInfoFloats tag, boolean mustExist) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" is missing");
            }
            return null;
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
            }
            return null;
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public String getFieldValue(TagInfoGpsText tag, boolean mustExist) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" is missing");
            }
            return null;
        }
        return tag.getValue(field);
    }

    public int getFieldValue(TagInfoLong tag) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            throw new ImagingException("Required field \"" + tag.name + "\" is missing");
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
        }
        if (field.getCount() != 1L) {
            throw new ImagingException("Field \"" + tag.name + "\" has wrong count " + field.getCount());
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public int[] getFieldValue(TagInfoLongs tag, boolean mustExist) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" is missing");
            }
            return null;
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
            }
            return null;
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public RationalNumber getFieldValue(TagInfoRational tag) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            throw new ImagingException("Required field \"" + tag.name + "\" is missing");
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
        }
        if (field.getCount() != 1L) {
            throw new ImagingException("Field \"" + tag.name + "\" has wrong count " + field.getCount());
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public RationalNumber[] getFieldValue(TagInfoRationals tag, boolean mustExist) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" is missing");
            }
            return null;
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
            }
            return null;
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public byte getFieldValue(TagInfoSByte tag) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            throw new ImagingException("Required field \"" + tag.name + "\" is missing");
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
        }
        if (field.getCount() != 1L) {
            throw new ImagingException("Field \"" + tag.name + "\" has wrong count " + field.getCount());
        }
        return field.getByteArrayValue()[0];
    }

    public byte[] getFieldValue(TagInfoSBytes tag, boolean mustExist) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" is missing");
            }
            return null;
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
            }
            return null;
        }
        return field.getByteArrayValue();
    }

    public short getFieldValue(TagInfoShort tag) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            throw new ImagingException("Required field \"" + tag.name + "\" is missing");
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
        }
        if (field.getCount() != 1L) {
            throw new ImagingException("Field \"" + tag.name + "\" has wrong count " + field.getCount());
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public int[] getFieldValue(TagInfoShortOrLong tag, boolean mustExist) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" is missing");
            }
            return null;
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
            }
            return null;
        }
        byte[] bytes = field.getByteArrayValue();
        if (field.getFieldType() == AbstractFieldType.SHORT) {
            return ByteConversions.toUInt16s(bytes, field.getByteOrder());
        }
        return ByteConversions.toInts(bytes, field.getByteOrder());
    }

    public short[] getFieldValue(TagInfoShorts tag, boolean mustExist) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" is missing");
            }
            return null;
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
            }
            return null;
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public int getFieldValue(TagInfoSLong tag) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            throw new ImagingException("Required field \"" + tag.name + "\" is missing");
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
        }
        if (field.getCount() != 1L) {
            throw new ImagingException("Field \"" + tag.name + "\" has wrong count " + field.getCount());
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public int[] getFieldValue(TagInfoSLongs tag, boolean mustExist) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" is missing");
            }
            return null;
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
            }
            return null;
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public RationalNumber getFieldValue(TagInfoSRational tag) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            throw new ImagingException("Required field \"" + tag.name + "\" is missing");
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
        }
        if (field.getCount() != 1L) {
            throw new ImagingException("Field \"" + tag.name + "\" has wrong count " + field.getCount());
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public RationalNumber[] getFieldValue(TagInfoSRationals tag, boolean mustExist) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" is missing");
            }
            return null;
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
            }
            return null;
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public short getFieldValue(TagInfoSShort tag) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            throw new ImagingException("Required field \"" + tag.name + "\" is missing");
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
        }
        if (field.getCount() != 1L) {
            throw new ImagingException("Field \"" + tag.name + "\" has wrong count " + field.getCount());
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public short[] getFieldValue(TagInfoSShorts tag, boolean mustExist) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" is missing");
            }
            return null;
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
            }
            return null;
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public String getFieldValue(TagInfoXpString tag, boolean mustExist) throws ImagingException {
        TiffField field = this.findField(tag);
        if (field == null) {
            if (mustExist) {
                throw new ImagingException("Required field \"" + tag.name + "\" is missing");
            }
            return null;
        }
        return tag.getValue(field);
    }

    public JpegImageData getJpegImageData() {
        return this.jpegImageData;
    }

    public ImageDataElement getJpegRawImageDataElement() throws ImagingException {
        TiffField jpegInterchangeFormat = this.findField(TiffTagConstants.TIFF_TAG_JPEG_INTERCHANGE_FORMAT);
        TiffField jpegInterchangeFormatLength = this.findField(TiffTagConstants.TIFF_TAG_JPEG_INTERCHANGE_FORMAT_LENGTH);
        if (jpegInterchangeFormat != null && jpegInterchangeFormatLength != null) {
            int offSet = jpegInterchangeFormat.getIntArrayValue()[0];
            int byteCount = jpegInterchangeFormatLength.getIntArrayValue()[0];
            return new ImageDataElement(offSet, byteCount);
        }
        throw new ImagingException("Couldn't find image data.");
    }

    public long getNextDirectoryOffset() {
        return this.nextDirectoryOffset;
    }

    public AbstractTiffRasterData getRasterData(TiffImagingParameters params) throws ImagingException, IOException {
        TiffImageParser parser = new TiffImageParser();
        return parser.getRasterData(this, this.headerByteOrder, params);
    }

    private List<ImageDataElement> getRawImageDataElements(TiffField offsetsField, TiffField byteCountsField) throws ImagingException {
        int[] byteCounts;
        long[] offsets = offsetsField.getLongArrayValue();
        if (offsets.length != (byteCounts = byteCountsField.getIntArrayValue()).length) {
            throw new ImagingException("offsets.length(" + offsets.length + ") != byteCounts.length(" + byteCounts.length + ")");
        }
        ArrayList<ImageDataElement> result = Allocator.arrayList(offsets.length);
        for (int i = 0; i < offsets.length; ++i) {
            result.add(new ImageDataElement(offsets[i], byteCounts[i]));
        }
        return result;
    }

    public String getSingleFieldValue(TagInfoAscii tag) throws ImagingException {
        String[] result = this.getFieldValue(tag, true);
        if (result.length != 1) {
            throw new ImagingException("Field \"" + tag.name + "\" has incorrect length " + result.length);
        }
        return result[0];
    }

    public int getSingleFieldValue(TagInfoShortOrLong tag) throws ImagingException {
        int[] result = this.getFieldValue(tag, true);
        if (result.length != 1) {
            throw new ImagingException("Field \"" + tag.name + "\" has incorrect length " + result.length);
        }
        return result[0];
    }

    public BufferedImage getTiffImage() throws ImagingException, IOException {
        if (null == this.abstractTiffImageData) {
            return null;
        }
        return new TiffImageParser().getBufferedImage(this, this.headerByteOrder, null);
    }

    public BufferedImage getTiffImage(ByteOrder byteOrder) throws ImagingException, IOException {
        return this.getTiffImage(byteOrder, new TiffImagingParameters());
    }

    public BufferedImage getTiffImage(ByteOrder byteOrder, TiffImagingParameters params) throws ImagingException, IOException {
        if (null == this.abstractTiffImageData) {
            return null;
        }
        return new TiffImageParser().getBufferedImage(this, byteOrder, params);
    }

    public BufferedImage getTiffImage(TiffImagingParameters params) throws ImagingException, IOException {
        if (null == this.abstractTiffImageData) {
            return null;
        }
        return new TiffImageParser().getBufferedImage(this, this.headerByteOrder, params);
    }

    public AbstractTiffImageData getTiffImageData() {
        return this.abstractTiffImageData;
    }

    public List<ImageDataElement> getTiffRawImageDataElements() throws ImagingException {
        TiffField tileOffsets = this.findField(TiffTagConstants.TIFF_TAG_TILE_OFFSETS);
        TiffField tileByteCounts = this.findField(TiffTagConstants.TIFF_TAG_TILE_BYTE_COUNTS);
        TiffField stripOffsets = this.findField(TiffTagConstants.TIFF_TAG_STRIP_OFFSETS);
        TiffField stripByteCounts = this.findField(TiffTagConstants.TIFF_TAG_STRIP_BYTE_COUNTS);
        if (tileOffsets != null && tileByteCounts != null) {
            return this.getRawImageDataElements(tileOffsets, tileByteCounts);
        }
        if (stripOffsets != null && stripByteCounts != null) {
            return this.getRawImageDataElements(stripOffsets, stripByteCounts);
        }
        throw new ImagingException("Couldn't find image data.");
    }

    public boolean hasJpegImageData() throws ImagingException {
        return null != this.findField(TiffTagConstants.TIFF_TAG_JPEG_INTERCHANGE_FORMAT);
    }

    public boolean hasTiffFloatingPointRasterData() throws ImagingException {
        if (!this.hasTiffImageData()) {
            return false;
        }
        short[] s = this.getFieldValue(TiffTagConstants.TIFF_TAG_SAMPLE_FORMAT, false);
        return s != null && s.length > 0 && s[0] == 3;
    }

    public boolean hasTiffImageData() throws ImagingException {
        if (null != this.findField(TiffTagConstants.TIFF_TAG_TILE_OFFSETS)) {
            return true;
        }
        return null != this.findField(TiffTagConstants.TIFF_TAG_STRIP_OFFSETS);
    }

    public boolean hasTiffRasterData() throws ImagingException {
        if (!this.hasTiffImageData()) {
            return false;
        }
        short[] s = this.getFieldValue(TiffTagConstants.TIFF_TAG_SAMPLE_FORMAT, false);
        return s != null && s.length > 0 && (s[0] == 3 || s[0] == 2);
    }

    public boolean imageDataInStrips() throws ImagingException {
        TiffField tileOffsets = this.findField(TiffTagConstants.TIFF_TAG_TILE_OFFSETS);
        TiffField tileByteCounts = this.findField(TiffTagConstants.TIFF_TAG_TILE_BYTE_COUNTS);
        TiffField stripOffsets = this.findField(TiffTagConstants.TIFF_TAG_STRIP_OFFSETS);
        TiffField stripByteCounts = this.findField(TiffTagConstants.TIFF_TAG_STRIP_BYTE_COUNTS);
        if (tileOffsets != null && tileByteCounts != null) {
            return false;
        }
        if (stripOffsets != null && stripByteCounts != null) {
            return true;
        }
        throw new ImagingException("Couldn't find image data.");
    }

    @Override
    public Iterator<TiffField> iterator() {
        return this.entries.iterator();
    }

    public void setJpegImageData(JpegImageData value) {
        this.jpegImageData = value;
    }

    public void setTiffImageData(AbstractTiffImageData rawImageData) {
        this.abstractTiffImageData = rawImageData;
    }

    public int size() {
        return this.entries.size();
    }

    public static final class ImageDataElement
    extends AbstractTiffElement {
        public ImageDataElement(long offset, int length) {
            super(offset, length);
        }

        @Override
        public String getElementDescription() {
            return "ImageDataElement";
        }
    }
}

