/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.examples.tiff;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.apache.commons.imaging.FormatCompliance;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.tiff.AbstractTiffRasterData;
import org.apache.commons.imaging.formats.tiff.TiffContents;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.formats.tiff.TiffRasterStatistics;
import org.apache.commons.imaging.formats.tiff.TiffReader;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.floatingpoint.PaletteEntryForRange;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.floatingpoint.PaletteEntryForValue;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.floatingpoint.PhotometricInterpreterFloat;
import org.apache.commons.lang3.StringUtils;

public class ExampleReadFloatingPointData {
    private static final String[] USAGE = new String[]{"Usage ReadFloatingPointData <input file> [output file]", "   input file:  Mandatory file to be read", "   output file: Optional output path for file to be written.", "                This name should not include a file extension.", "                Output data will be written using the JPEG format."};

    public static void main(String[] args) throws ImagingException, IOException {
        if (args.length == 0) {
            for (String s : USAGE) {
                System.err.println(s);
            }
            System.exit(0);
        }
        File target = new File(args[0]);
        String outputPath = null;
        if (args.length >= 2) {
            outputPath = args[1];
        }
        boolean optionalImageWritingEnabled = StringUtils.isNotEmpty(outputPath);
        ByteSource byteSource = ByteSource.file((File)target);
        TiffReader tiffReader = new TiffReader(true);
        TiffContents contents = tiffReader.readDirectories(byteSource, true, FormatCompliance.getDefault());
        TiffDirectory directory = (TiffDirectory)contents.directories.get(0);
        if (!directory.hasTiffFloatingPointRasterData()) {
            System.err.println("Specified directory does not contain floating-point data");
            System.exit(-1);
        }
        long time0Nanos = System.nanoTime();
        TiffImagingParameters params = new TiffImagingParameters();
        AbstractTiffRasterData rasterData = directory.getRasterData(params);
        long time1Nanos = System.nanoTime();
        System.out.println("Data read in " + (double)(time1Nanos - time0Nanos) / 1000000.0 + " ms");
        float excludedValue = Float.NaN;
        TiffRasterStatistics simpleStats = "Sample64BitFloatingPointPix451x337.tiff".equals(target.getName()) ? rasterData.getSimpleStatistics(9999.0f) : rasterData.getSimpleStatistics();
        int w = rasterData.getWidth();
        int h = rasterData.getHeight();
        float minValue = simpleStats.getMinValue();
        float maxValue = simpleStats.getMaxValue();
        System.out.format("Image size %dx%d%n", w, h);
        System.out.format("Range of values in TIFF: %f %f%n", Float.valueOf(minValue), Float.valueOf(maxValue));
        System.out.format("Number of data values found %d%n", simpleStats.getCountOfSamples());
        if (optionalImageWritingEnabled) {
            File output = new File(outputPath);
            System.out.println("Writing image to " + output.getPath());
            ArrayList<Object> paletteList = new ArrayList<Object>();
            if (!Float.isNaN(Float.NaN)) {
                paletteList.add(new PaletteEntryForValue(Float.NaN, Color.red));
            }
            paletteList.add(new PaletteEntryForRange(minValue, maxValue, Color.black, Color.white));
            paletteList.add(new PaletteEntryForValue(maxValue, Color.white));
            PhotometricInterpreterFloat photometricInterpreter = new PhotometricInterpreterFloat(paletteList);
            ImageBuilder builder = new ImageBuilder(w, h, false);
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    float f = rasterData.getValue(x, y);
                    int argb = photometricInterpreter.mapValueToArgb(f);
                    builder.setRgb(x, y, argb);
                }
            }
            BufferedImage bImage = builder.getBufferedImage();
            ImageIO.write((RenderedImage)bImage, "JPEG", output);
        }
    }
}

