/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import org.apache.commons.imaging.formats.tiff.AbstractTiffRasterData;
import org.apache.commons.imaging.formats.tiff.TiffRasterDataInt;
import org.apache.commons.imaging.formats.tiff.TiffRasterDataType;
import org.apache.commons.imaging.formats.tiff.TiffRasterStatistics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TiffRasterDataIntTest {
    int width = 11;
    int height = 10;
    int[] data;
    AbstractTiffRasterData raster;
    float meanValue;

    public TiffRasterDataIntTest() {
        double sum = 0.0;
        this.data = new int[this.width * this.height];
        int k = 0;
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                this.data[k] = k;
                sum += (double)k;
                ++k;
            }
        }
        this.raster = new TiffRasterDataInt(this.width, this.height, this.data);
        this.meanValue = (float)(sum / (double)k);
    }

    @Test
    public void testBadConstructor() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TiffRasterDataInt(-1, 10), (String)"Constructor did not detect bad width");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TiffRasterDataInt(10, -1), (String)"Constructor did not detect bad height");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TiffRasterDataInt(1, 1, 0), (String)"Constructor did not detect bad samplesPerPixel");
        int[] s = new int[10];
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TiffRasterDataInt(2, 10, s), (String)"Constructor did not detect insufficient input array size");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TiffRasterDataInt(2, 3, 2, s), (String)"Constructor did not detect insufficient input array size");
    }

    @Test
    public void testBadCoordinates() {
        TiffRasterDataInt raster;
        int[] sample2;
        try {
            sample2 = new int[100];
            raster = new TiffRasterDataInt(10, 10, sample2);
            raster.getIntValue(11, 11);
            Assertions.fail((String)"Access method getValue() did not detect bad coordinates");
        }
        catch (IllegalArgumentException sample2) {
            // empty catch block
        }
        try {
            sample2 = new int[100];
            raster = new TiffRasterDataInt(10, 10, sample2);
            raster.setValue(11, 11, 5.0f);
            Assertions.fail((String)"Access method setValue() did not detect bad coordinates");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetData() {
        float[] result = this.raster.getData();
        for (int i = 0; i < result.length; ++i) {
            Assertions.assertEquals((int)((int)result[i]), (int)this.data[i]);
        }
        int[] iResult = this.raster.getIntData();
        Assertions.assertArrayEquals((int[])this.data, (int[])iResult);
    }

    @Test
    public void testGetDataType() {
        TiffRasterDataType dataType = this.raster.getDataType();
        Assertions.assertEquals((Object)dataType, (Object)TiffRasterDataType.INTEGER, (String)("Unexpected data type " + dataType.name()));
    }

    @Test
    public void testGetHeight() {
        Assertions.assertEquals((int)this.width, (int)this.raster.getWidth(), (String)"Improper height stored");
    }

    @Test
    public void testGetSimpleStatistics_0args() {
        TiffRasterStatistics result = this.raster.getSimpleStatistics();
        Assertions.assertEquals((float)0.0f, (float)result.getMinValue(), (String)"Min value failure");
        Assertions.assertEquals((float)(this.width * this.height - 1), (float)result.getMaxValue(), (String)"Max value failure");
        Assertions.assertEquals((float)this.meanValue, (float)result.getMeanValue(), (String)"Mean value failure");
    }

    @Test
    public void testGetSimpleStatistics_float() {
        TiffRasterStatistics result = this.raster.getSimpleStatistics((float)(this.width * this.height - 1));
        Assertions.assertEquals((float)(this.width * this.height - 2), (float)result.getMaxValue(), (String)"Max value failure");
    }

    @Test
    public void testGetValue() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int index = y * this.width + x;
                int test = (int)this.raster.getValue(x, y);
                Assertions.assertEquals((int)index, (int)test, (String)("Get into source data test failed at (" + x + "," + y + ")"));
                test = this.raster.getIntValue(x, y);
                Assertions.assertEquals((int)index, (int)test, (String)("Get into source data test failed at (" + x + "," + y + ")"));
            }
        }
    }

    @Test
    public void testGetValue2() {
        int[] data = new int[this.width * this.height * 2];
        data[this.width * this.height] = 77;
        TiffRasterDataInt instance = new TiffRasterDataInt(this.width, this.height, 2, data);
        int test = instance.getIntValue(0, 0, 1);
        Assertions.assertEquals((int)77, (int)test, (String)"Get into source data test failed at (0, 0, 1)");
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int index = y * this.width + x;
                test = (int)this.raster.getValue(x, y, 0);
                Assertions.assertEquals((int)index, (int)test, (String)("Get into source data test failed at (" + x + "," + y + ")"));
                test = this.raster.getIntValue(x, y, 0);
                Assertions.assertEquals((int)index, (int)test, (String)("Get into source data test failed at (" + x + "," + y + ")"));
            }
        }
    }

    @Test
    public void testGetWidth() {
        Assertions.assertEquals((int)this.width, (int)this.raster.getWidth(), (String)"Improper width stored");
    }

    @Test
    public void testSetValue() {
        TiffRasterDataInt instance = new TiffRasterDataInt(this.width, this.height);
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int index = y * this.width + this.height;
                instance.setValue(x, y, (float)index + 0.4f);
                int test = (int)instance.getValue(x, y);
                Assertions.assertEquals((int)index, (int)test, (String)"Set/get value test failed");
                instance.setIntValue(x, y, index);
                test = instance.getIntValue(x, y);
                Assertions.assertEquals((int)index, (int)test, (String)"Set/get int value test failed");
            }
        }
    }

    @Test
    public void testSetValue2() {
        TiffRasterDataInt instance = new TiffRasterDataInt(this.width, this.height, 2);
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int index = y * this.width + this.height;
                instance.setValue(x, y, 1, (float)index + 0.4f);
                int test = (int)instance.getValue(x, y, 1);
                Assertions.assertEquals((int)index, (int)test, (String)"Set/get value test failed");
                instance.setIntValue(x, y, 1, index);
                test = instance.getIntValue(x, y, 1);
                Assertions.assertEquals((int)index, (int)test, (String)"Set/get int value test failed");
            }
        }
    }
}

