/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileSystem;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemProperties;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class FileSystemTest {
    private static final String CHAR_UTF8_1B = "a";
    private static final String CHAR_UTF8_2B = "\u00e9";
    private static final String CHAR_UTF8_3B = "\u2605";
    private static final String CHAR_UTF8_4B = "\ud83d\ude00";
    private static final String CHAR_UTF8_69B = "\ud83d\udc69\ud83c\udffb\u200d\ud83e\uddb0\u200d\ud83d\udc68\ud83c\udfff\u200d\ud83e\uddb2\u200d\ud83d\udc67\ud83c\udffd\u200d\ud83e\uddb1\u200d\ud83d\udc66\ud83c\udffc\u200d\ud83e\uddb3";
    private static final String FILE_NAME_255_BYTES_UTF8_1B = StringUtils.repeat((String)"a", (int)255);
    private static final String FILE_NAME_255_BYTES_UTF8_2B = StringUtils.repeat((String)"\u00e9", (int)127) + "a";
    private static final String FILE_NAME_255_BYTES_UTF8_3B = StringUtils.repeat((String)"\u2605", (int)85);
    private static final String FILE_NAME_255_BYTES_UTF8_4B = StringUtils.repeat((String)"\ud83d\ude00", (int)63) + "\u2605";
    private static final String FILE_NAME_255_CHARS_UTF8_1B = FILE_NAME_255_BYTES_UTF8_1B;
    private static final String FILE_NAME_255_CHARS_UTF8_2B = StringUtils.repeat((String)"\u00e9", (int)255);
    private static final String FILE_NAME_255_CHARS_UTF8_3B = StringUtils.repeat((String)"\u2605", (int)255);
    private static final String FILE_NAME_255_CHARS_UTF8_4B = StringUtils.repeat((String)"\ud83d\ude00", (int)127) + "\u2605";

    FileSystemTest() {
    }

    private static void createAndDelete(Path tempDir, String fileName) throws IOException {
        Path filePath = tempDir.resolve(fileName);
        Files.createFile(filePath, new FileAttribute[0]);
        try (Stream<Path> files = Files.list(tempDir);){
            boolean found = files.anyMatch(filePath::equals);
            if (!found) {
                throw new FileNotFoundException(fileName + " not found in " + tempDir);
            }
        }
        Files.delete(filePath);
    }

    static Stream<Arguments> testIsLegalName_Length() {
        return Stream.of(Arguments.of((Object[])new Object[]{FileSystem.GENERIC, StringUtils.repeat((String)FILE_NAME_255_BYTES_UTF8_1B, (int)4), StandardCharsets.UTF_8}), Arguments.of((Object[])new Object[]{FileSystem.GENERIC, StringUtils.repeat((String)FILE_NAME_255_BYTES_UTF8_2B, (int)4), StandardCharsets.UTF_8}), Arguments.of((Object[])new Object[]{FileSystem.GENERIC, StringUtils.repeat((String)FILE_NAME_255_BYTES_UTF8_3B, (int)4), StandardCharsets.UTF_8}), Arguments.of((Object[])new Object[]{FileSystem.GENERIC, StringUtils.repeat((String)FILE_NAME_255_BYTES_UTF8_4B, (int)4), StandardCharsets.UTF_8}), Arguments.of((Object[])new Object[]{FileSystem.LINUX, FILE_NAME_255_BYTES_UTF8_1B, StandardCharsets.UTF_8}), Arguments.of((Object[])new Object[]{FileSystem.LINUX, FILE_NAME_255_BYTES_UTF8_2B, StandardCharsets.UTF_8}), Arguments.of((Object[])new Object[]{FileSystem.LINUX, FILE_NAME_255_BYTES_UTF8_3B, StandardCharsets.UTF_8}), Arguments.of((Object[])new Object[]{FileSystem.LINUX, FILE_NAME_255_BYTES_UTF8_4B, StandardCharsets.UTF_8}), Arguments.of((Object[])new Object[]{FileSystem.MAC_OSX, FILE_NAME_255_BYTES_UTF8_1B, StandardCharsets.UTF_8}), Arguments.of((Object[])new Object[]{FileSystem.MAC_OSX, FILE_NAME_255_BYTES_UTF8_2B, StandardCharsets.UTF_8}), Arguments.of((Object[])new Object[]{FileSystem.MAC_OSX, FILE_NAME_255_BYTES_UTF8_3B, StandardCharsets.UTF_8}), Arguments.of((Object[])new Object[]{FileSystem.MAC_OSX, FILE_NAME_255_BYTES_UTF8_4B, StandardCharsets.UTF_8}), Arguments.of((Object[])new Object[]{FileSystem.WINDOWS, FILE_NAME_255_CHARS_UTF8_1B, StandardCharsets.UTF_8}), Arguments.of((Object[])new Object[]{FileSystem.WINDOWS, FILE_NAME_255_CHARS_UTF8_2B, StandardCharsets.UTF_8}), Arguments.of((Object[])new Object[]{FileSystem.WINDOWS, FILE_NAME_255_CHARS_UTF8_3B, StandardCharsets.UTF_8}), Arguments.of((Object[])new Object[]{FileSystem.WINDOWS, FILE_NAME_255_CHARS_UTF8_4B, StandardCharsets.UTF_8}), Arguments.of((Object[])new Object[]{FileSystem.GENERIC, StringUtils.repeat((String)FILE_NAME_255_BYTES_UTF8_1B, (int)4), StandardCharsets.US_ASCII}), Arguments.of((Object[])new Object[]{FileSystem.GENERIC, StringUtils.repeat((String)CHAR_UTF8_2B, (int)1020), StandardCharsets.ISO_8859_1}), Arguments.of((Object[])new Object[]{FileSystem.LINUX, FILE_NAME_255_BYTES_UTF8_1B, StandardCharsets.US_ASCII}), Arguments.of((Object[])new Object[]{FileSystem.LINUX, StringUtils.repeat((String)CHAR_UTF8_2B, (int)255), StandardCharsets.ISO_8859_1}));
    }

    static Stream<Arguments> testNameLengthStrategyTruncate_Succeeds() {
        String redHeadWoman;
        String woman;
        if (SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_19)) {
            woman = CHAR_UTF8_69B.substring(0, 2);
            redHeadWoman = CHAR_UTF8_69B.substring(0, 7);
        } else {
            woman = "";
            redHeadWoman = "";
        }
        return Stream.of(Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 0, "", ""}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 10, "simple.txt", "simple.txt"}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 10, "." + StringUtils.repeat((String)CHAR_UTF8_1B, (int)10), "." + StringUtils.repeat((String)CHAR_UTF8_1B, (int)9)}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 20, "." + StringUtils.repeat((String)CHAR_UTF8_2B, (int)10), "." + StringUtils.repeat((String)CHAR_UTF8_2B, (int)9)}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 30, "." + StringUtils.repeat((String)CHAR_UTF8_3B, (int)10), "." + StringUtils.repeat((String)CHAR_UTF8_3B, (int)9)}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 40, "." + StringUtils.repeat((String)CHAR_UTF8_4B, (int)10), "." + StringUtils.repeat((String)CHAR_UTF8_4B, (int)9)}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 13, StringUtils.repeat((String)CHAR_UTF8_1B, (int)10) + ".txt", StringUtils.repeat((String)CHAR_UTF8_1B, (int)9) + ".txt"}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 23, StringUtils.repeat((String)CHAR_UTF8_2B, (int)10) + ".txt", StringUtils.repeat((String)CHAR_UTF8_2B, (int)9) + ".txt"}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 33, StringUtils.repeat((String)CHAR_UTF8_3B, (int)10) + ".txt", StringUtils.repeat((String)CHAR_UTF8_3B, (int)9) + ".txt"}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 43, StringUtils.repeat((String)CHAR_UTF8_4B, (int)10) + ".txt", StringUtils.repeat((String)CHAR_UTF8_4B, (int)9) + ".txt"}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 1, CHAR_UTF8_1B, CHAR_UTF8_1B}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 2, CHAR_UTF8_2B, CHAR_UTF8_2B}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 3, CHAR_UTF8_3B, CHAR_UTF8_3B}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 4, CHAR_UTF8_4B, CHAR_UTF8_4B}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 9, StringUtils.repeat((String)CHAR_UTF8_1B, (int)10), StringUtils.repeat((String)CHAR_UTF8_1B, (int)9)}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 19, StringUtils.repeat((String)CHAR_UTF8_2B, (int)10), StringUtils.repeat((String)CHAR_UTF8_2B, (int)9)}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 29, StringUtils.repeat((String)CHAR_UTF8_3B, (int)10), StringUtils.repeat((String)CHAR_UTF8_3B, (int)9)}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 39, StringUtils.repeat((String)CHAR_UTF8_4B, (int)10), StringUtils.repeat((String)CHAR_UTF8_4B, (int)9)}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 69, CHAR_UTF8_69B, CHAR_UTF8_69B}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 73, StringUtils.repeat((String)CHAR_UTF8_69B, (int)2), CHAR_UTF8_69B + woman}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 84, StringUtils.repeat((String)CHAR_UTF8_69B, (int)2), CHAR_UTF8_69B + redHeadWoman}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 0, "", ""}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 10, "simple.txt", "simple.txt"}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 10, "." + StringUtils.repeat((String)CHAR_UTF8_1B, (int)10), "." + StringUtils.repeat((String)CHAR_UTF8_1B, (int)9)}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 10, "." + StringUtils.repeat((String)CHAR_UTF8_2B, (int)10), "." + StringUtils.repeat((String)CHAR_UTF8_2B, (int)9)}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 10, "." + StringUtils.repeat((String)CHAR_UTF8_3B, (int)10), "." + StringUtils.repeat((String)CHAR_UTF8_3B, (int)9)}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 20, "." + StringUtils.repeat((String)CHAR_UTF8_4B, (int)10), "." + StringUtils.repeat((String)CHAR_UTF8_4B, (int)9)}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 13, StringUtils.repeat((String)CHAR_UTF8_1B, (int)10) + ".txt", StringUtils.repeat((String)CHAR_UTF8_1B, (int)9) + ".txt"}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 13, StringUtils.repeat((String)CHAR_UTF8_2B, (int)10) + ".txt", StringUtils.repeat((String)CHAR_UTF8_2B, (int)9) + ".txt"}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 13, StringUtils.repeat((String)CHAR_UTF8_3B, (int)10) + ".txt", StringUtils.repeat((String)CHAR_UTF8_3B, (int)9) + ".txt"}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 23, StringUtils.repeat((String)CHAR_UTF8_4B, (int)10) + ".txt", StringUtils.repeat((String)CHAR_UTF8_4B, (int)9) + ".txt"}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 1, CHAR_UTF8_1B, CHAR_UTF8_1B}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 1, CHAR_UTF8_2B, CHAR_UTF8_2B}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 1, CHAR_UTF8_3B, CHAR_UTF8_3B}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 2, CHAR_UTF8_4B, CHAR_UTF8_4B}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 9, StringUtils.repeat((String)CHAR_UTF8_1B, (int)10), StringUtils.repeat((String)CHAR_UTF8_1B, (int)9)}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 9, StringUtils.repeat((String)CHAR_UTF8_2B, (int)10), StringUtils.repeat((String)CHAR_UTF8_2B, (int)9)}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 9, StringUtils.repeat((String)CHAR_UTF8_3B, (int)10), StringUtils.repeat((String)CHAR_UTF8_3B, (int)9)}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 19, StringUtils.repeat((String)CHAR_UTF8_4B, (int)10), StringUtils.repeat((String)CHAR_UTF8_4B, (int)9)}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 31, CHAR_UTF8_69B, CHAR_UTF8_69B}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 33, StringUtils.repeat((String)CHAR_UTF8_69B, (int)2), CHAR_UTF8_69B + woman}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 38, StringUtils.repeat((String)CHAR_UTF8_69B, (int)2), CHAR_UTF8_69B + redHeadWoman}));
    }

    static Stream<Arguments> testNameLengthStrategyTruncate_Throws() {
        Stream<Arguments> common = Stream.of(Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 10, "caf\u00e9", StandardCharsets.US_ASCII, "US-ASCII"}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 10, "\ud800.txt", StandardCharsets.UTF_8, "UTF-16"}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 10, "\udc00.txt", StandardCharsets.UTF_8, "UTF-16"}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 4, "a.txt", StandardCharsets.UTF_8, "extension"}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 4, "a.txt", StandardCharsets.UTF_8, "extension"}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 3, CHAR_UTF8_4B, StandardCharsets.UTF_8, "truncated to 1 character"}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 1, CHAR_UTF8_4B, StandardCharsets.UTF_8, "truncated to 1 character"}));
        return SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_19) ? common : Stream.concat(common, Stream.of(Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.BYTES, 68, CHAR_UTF8_69B, StandardCharsets.UTF_8, "truncated to 29 characters"}), Arguments.of((Object[])new Object[]{FileSystem.NameLengthStrategy.UTF16_CODE_UNITS, 30, CHAR_UTF8_69B, StandardCharsets.UTF_8, "truncated to 30 characters"})));
    }

    private String parseXmlRootValue(Path xmlPath, Charset charset) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        try (BufferedReader reader = Files.newBufferedReader(xmlPath, charset);){
            Document document = builder.parse(new InputSource(reader));
            String string = document.getDocumentElement().getTextContent();
            return string;
        }
    }

    private String parseXmlRootValue(String xmlString) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xmlString)));
        return document.getDocumentElement().getTextContent();
    }

    @Test
    void testGetBlockSize() {
        Assertions.assertTrue((FileSystem.getCurrent().getBlockSize() >= 0 ? 1 : 0) != 0);
    }

    @Test
    void testGetCurrent() {
        if (SystemUtils.IS_OS_WINDOWS) {
            Assertions.assertEquals((Object)FileSystem.WINDOWS, (Object)FileSystem.getCurrent());
        }
        if (SystemUtils.IS_OS_LINUX) {
            Assertions.assertEquals((Object)FileSystem.LINUX, (Object)FileSystem.getCurrent());
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            Assertions.assertEquals((Object)FileSystem.MAC_OSX, (Object)FileSystem.getCurrent());
        }
    }

    @Test
    void testGetIllegalFileNameChars() {
        FileSystem current = FileSystem.getCurrent();
        Assertions.assertNotSame((Object)current.getIllegalFileNameChars(), (Object)current.getIllegalFileNameChars());
    }

    @Test
    void testGetNameSeparator() {
        FileSystem current = FileSystem.getCurrent();
        Assertions.assertEquals((Object)SystemProperties.getFileSeparator(), (Object)Character.toString(current.getNameSeparator()));
    }

    @ParameterizedTest
    @EnumSource(value=FileSystem.class)
    void testIsLegalName(FileSystem fs) {
        Assertions.assertFalse((boolean)fs.isLegalFileName((CharSequence)""), (String)fs.name());
        Assertions.assertFalse((boolean)fs.isLegalFileName(null), (String)fs.name());
        Assertions.assertFalse((boolean)fs.isLegalFileName((CharSequence)"\u0000"), (String)fs.name());
        Assertions.assertTrue((boolean)fs.isLegalFileName((CharSequence)"0"), (String)fs.name());
        for (String candidate : fs.getReservedFileNames()) {
            Assertions.assertFalse((boolean)fs.isLegalFileName((CharSequence)candidate), (String)candidate);
        }
    }

    @Test
    void testIsLegalName_Encoding() {
        Assertions.assertFalse((boolean)FileSystem.GENERIC.isLegalFileName((CharSequence)FILE_NAME_255_BYTES_UTF8_3B, StandardCharsets.US_ASCII), (String)"US-ASCII cannot represent all chars");
        Assertions.assertTrue((boolean)FileSystem.GENERIC.isLegalFileName((CharSequence)FILE_NAME_255_BYTES_UTF8_3B, StandardCharsets.UTF_8), (String)"UTF-8 can represent all chars");
    }

    @ParameterizedTest(name="{index}: {0} with charset {2}")
    @MethodSource
    void testIsLegalName_Length(FileSystem fs, String nameAtLimit, Charset charset) {
        Assertions.assertTrue((boolean)fs.isLegalFileName((CharSequence)nameAtLimit, charset), (String)(fs.name() + " length at limit"));
        String nameOverLimit = nameAtLimit + CHAR_UTF8_1B;
        Assertions.assertFalse((boolean)fs.isLegalFileName((CharSequence)nameOverLimit, charset), (String)(fs.name() + " length over limit"));
    }

    @Test
    void testIsReservedFileName() {
        for (FileSystem fs : FileSystem.values()) {
            for (String candidate : fs.getReservedFileNames()) {
                Assertions.assertTrue((boolean)fs.isReservedFileName((CharSequence)candidate));
            }
        }
    }

    @Test
    void testIsReservedFileNameOnWindows() {
        FileSystem fs = FileSystem.WINDOWS;
        for (String candidate : fs.getReservedFileNames()) {
            Assertions.assertTrue((boolean)fs.isReservedFileName((CharSequence)candidate));
            Assertions.assertTrue((boolean)fs.isReservedFileName((CharSequence)(candidate + ".txt")), (String)candidate);
        }
    }

    @Test
    void testMaxNameLength_MatchesRealSystem(@TempDir Path tempDir) {
        String[] validNames;
        FileSystem fs = FileSystem.getCurrent();
        switch (fs) {
            case MAC_OSX: 
            case LINUX: {
                validNames = new String[]{FILE_NAME_255_BYTES_UTF8_1B, FILE_NAME_255_BYTES_UTF8_2B, FILE_NAME_255_BYTES_UTF8_3B, FILE_NAME_255_BYTES_UTF8_4B};
                break;
            }
            case WINDOWS: {
                validNames = new String[]{FILE_NAME_255_CHARS_UTF8_1B, FILE_NAME_255_CHARS_UTF8_2B, FILE_NAME_255_CHARS_UTF8_3B, FILE_NAME_255_CHARS_UTF8_4B};
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + fs);
            }
        }
        int failures = 0;
        for (String fileName : validNames) {
            Assertions.assertDoesNotThrow(() -> FileSystemTest.createAndDelete(tempDir, fileName), (String)("OS should accept max-length name: " + fileName));
            Assertions.assertTrue((boolean)fs.isLegalFileName((CharSequence)fileName, StandardCharsets.UTF_8), (String)("Commons IO should accept max-length name: " + fileName));
            String tooLongName = fileName + CHAR_UTF8_1B;
            Assertions.assertFalse((boolean)fs.isLegalFileName((CharSequence)tooLongName, StandardCharsets.UTF_8), (String)("Commons IO should reject too-long name: " + tooLongName));
            try {
                FileSystemTest.createAndDelete(tempDir, tooLongName);
            }
            catch (Throwable e) {
                ++failures;
                Assertions.assertInstanceOf(IOException.class, (Object)e, (String)"OS rejects too-long name");
            }
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            Assertions.assertTrue((failures >= 1 ? 1 : 0) != 0, (String)("Expected at least one too-long name rejected, got " + failures));
        } else {
            Assertions.assertEquals((int)4, (int)failures, (String)"All too-long names were rejected");
        }
    }

    @ParameterizedTest(name="{index}: {0} truncates {1} to {2}")
    @MethodSource
    void testNameLengthStrategyTruncate_Succeeds(FileSystem.NameLengthStrategy strategy, int limit, String input, String expected) {
        CharSequence out = strategy.truncate((CharSequence)input, limit, StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)expected, (Object)out.toString(), (String)(strategy.name() + " truncates to limit"));
    }

    @ParameterizedTest(name="{index}: {0} truncates {2} with limit {1} throws")
    @MethodSource
    void testNameLengthStrategyTruncate_Throws(FileSystem.NameLengthStrategy strategy, int limit, String input, Charset charset, String message) {
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> strategy.truncate((CharSequence)input, limit, charset));
        String exMessage = ex.getMessage();
        Assertions.assertTrue((boolean)exMessage.contains(message), (String)("ex message contains " + message + ": " + exMessage));
    }

    @Test
    void testReplacementWithNUL() {
        for (FileSystem fs : FileSystem.values()) {
            try {
                fs.toLegalFileName("Test", '\u0000');
            }
            catch (IllegalArgumentException iae) {
                Assertions.assertTrue((boolean)iae.getMessage().startsWith("The replacement character '\\0'"), (String)iae.getMessage());
            }
        }
    }

    @Test
    void testSorted() {
        for (FileSystem fs : FileSystem.values()) {
            char[] chars = fs.getIllegalFileNameChars();
            for (int i = 0; i < chars.length - 1; ++i) {
                Assertions.assertTrue((chars[i] < chars[i + 1] ? 1 : 0) != 0, (String)fs.name());
            }
        }
    }

    @Test
    void testSupportsDriveLetter() {
        Assertions.assertTrue((boolean)FileSystem.WINDOWS.supportsDriveLetter());
        Assertions.assertFalse((boolean)FileSystem.GENERIC.supportsDriveLetter());
        Assertions.assertFalse((boolean)FileSystem.LINUX.supportsDriveLetter());
        Assertions.assertFalse((boolean)FileSystem.MAC_OSX.supportsDriveLetter());
    }

    @Test
    void testToLegalFileNameWindows() {
        char i;
        FileSystem fs = FileSystem.WINDOWS;
        int replacement = 45;
        for (char i2 = '\u0000'; i2 < ' '; i2 = (char)(i2 + '\u0001')) {
            Assertions.assertEquals((char)'-', (char)fs.toLegalFileName(String.valueOf(i2), '-').charAt(0));
        }
        char[] illegal = new char[]{'<', '>', ':', '\"', '/', '\\', '|', '?', '*'};
        for (i = '\u0000'; i < illegal.length; i = (char)((char)(i + '\u0001'))) {
            Assertions.assertEquals((char)'-', (char)fs.toLegalFileName(String.valueOf(i), '-').charAt(0));
        }
        for (i = 'a'; i < 'z'; i = (char)(i + '\u0001')) {
            Assertions.assertEquals((char)i, (char)fs.toLegalFileName(String.valueOf(i), '-').charAt(0));
        }
        for (i = 'A'; i < 'Z'; i = (char)(i + '\u0001')) {
            Assertions.assertEquals((char)i, (char)fs.toLegalFileName(String.valueOf(i), '-').charAt(0));
        }
        for (i = '0'; i < '9'; i = (char)(i + '\u0001')) {
            Assertions.assertEquals((char)i, (char)fs.toLegalFileName(String.valueOf(i), '-').charAt(0));
        }
        Assertions.assertThrows(NullPointerException.class, () -> fs.toLegalFileName(null, '_'));
        Assertions.assertThrows(IllegalArgumentException.class, () -> fs.toLegalFileName("", '_'));
        Assertions.assertThrows(IllegalArgumentException.class, () -> fs.toLegalFileName("test", '\u0000'));
        Assertions.assertThrows(IllegalArgumentException.class, () -> fs.toLegalFileName("test", ':'));
    }

    @ParameterizedTest
    @EnumSource(value=FileSystem.class)
    void testXmlRoundtrip(FileSystem fs, @TempDir Path tempDir) throws Exception {
        if (SystemUtils.IS_OS_WINDOWS) {
            Assumptions.assumeTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_21));
        }
        Charset charset = StandardCharsets.UTF_8;
        Assertions.assertEquals((Object)CHAR_UTF8_1B, (Object)fs.toLegalFileName((CharSequence)CHAR_UTF8_1B, '_', charset));
        Assertions.assertEquals((Object)"abcdefghijklmno", (Object)fs.toLegalFileName((CharSequence)"abcdefghijklmno", '_', charset));
        Assertions.assertEquals((Object)"\u4f60\u597d\u55ce", (Object)fs.toLegalFileName((CharSequence)"\u4f60\u597d\u55ce", '_', charset));
        Assertions.assertEquals((Object)"\u2713\u2714", (Object)fs.toLegalFileName((CharSequence)"\u2713\u2714", '_', charset));
        Assertions.assertEquals((Object)"\ud83d\ude80\u2728\ud83c\udf89", (Object)fs.toLegalFileName((CharSequence)"\ud83d\ude80\u2728\ud83c\udf89", '_', charset));
        Assertions.assertEquals((Object)"\ud83d\ude03", (Object)fs.toLegalFileName((CharSequence)"\ud83d\ude03", '_', charset));
        Assertions.assertEquals((Object)"\ud83d\ude03\ud83d\ude03\ud83d\ude03\ud83d\ude03\ud83d\ude03", (Object)fs.toLegalFileName((CharSequence)"\ud83d\ude03\ud83d\ude03\ud83d\ude03\ud83d\ude03\ud83d\ude03", '_', charset));
        for (int i = 1; i <= 10; ++i) {
            String name1 = fs.toLegalFileName((CharSequence)StringUtils.repeat((String)"\ud83e\udd8a", (int)i), '_', charset);
            Assertions.assertNotNull((Object)name1);
            byte[] name1Bytes = name1.getBytes();
            String xmlString1 = this.toXmlString(name1, charset);
            Path path = tempDir.resolve(name1);
            Files.write(path, xmlString1.getBytes(charset), new OpenOption[0]);
            String xmlFromPath = this.parseXmlRootValue(path, charset);
            Assertions.assertEquals((Object)name1, (Object)xmlFromPath, (String)("i =  " + i));
            String name2 = new String(name1Bytes, charset);
            Assertions.assertEquals((Object)name1, (Object)name2);
            String xmlString2 = this.toXmlString(name2, charset);
            Assertions.assertEquals((Object)xmlString1, (Object)xmlString2);
            String parsedValue = Objects.toString(this.parseXmlRootValue(xmlString2), "");
            Assertions.assertEquals((Object)name1, (Object)parsedValue, (String)("i =  " + i));
            Assertions.assertEquals((Object)name2, (Object)parsedValue, (String)("i =  " + i));
        }
    }

    private String toXmlString(String s, Charset charset) {
        return String.format("<?xml version=\"1.0\" encoding=\"%s\"?><data>%s</data>", charset.name(), s);
    }
}

