/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.compilers;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jci.compilers.JavaCompilerSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EclipseJavaCompilerSettings
extends JavaCompilerSettings {
    private final Map<String, String> defaultEclipseSettings = new HashMap<String, String>();
    private static Map<String, String> nativeVersions = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("1.1", "1.1");
            this.put("1.2", "1.2");
            this.put("1.3", "1.3");
            this.put("1.4", "1.4");
            this.put("1.5", "1.5");
            this.put("1.6", "1.6");
            this.put("1.7", "1.7");
        }
    };

    public EclipseJavaCompilerSettings() {
        this.defaultEclipseSettings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        this.defaultEclipseSettings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        this.defaultEclipseSettings.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "ignore");
        this.defaultEclipseSettings.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
    }

    public EclipseJavaCompilerSettings(JavaCompilerSettings pSettings) {
        super(pSettings);
        if (pSettings instanceof EclipseJavaCompilerSettings) {
            this.defaultEclipseSettings.putAll(((EclipseJavaCompilerSettings)pSettings).toNativeSettings());
        }
    }

    public EclipseJavaCompilerSettings(Map<String, String> pMap) {
        this.defaultEclipseSettings.putAll(pMap);
    }

    private String toNativeVersion(String pVersion) {
        String nativeVersion = nativeVersions.get(pVersion);
        if (nativeVersion == null) {
            throw new RuntimeException("unknown version " + pVersion);
        }
        return nativeVersion;
    }

    Map<String, String> toNativeSettings() {
        HashMap<String, String> map = new HashMap<String, String>(this.defaultEclipseSettings);
        map.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", this.isWarnings() ? "generate" : "do not generate");
        map.put("org.eclipse.jdt.core.compiler.problem.deprecation", this.isDeprecations() ? "generate" : "do not generate");
        map.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", this.toNativeVersion(this.getTargetVersion()));
        map.put("org.eclipse.jdt.core.compiler.source", this.toNativeVersion(this.getSourceVersion()));
        map.put("org.eclipse.jdt.core.encoding", this.getSourceEncoding());
        return map;
    }

    public String toString() {
        return this.toNativeSettings().toString();
    }
}

