/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.jelly.tags.util;

import org.apache.commons.jelly.TagLibrary;

/** Implements general utility tags.
 *
 *  @author <a href="mailto:bob@eng.werken.com">bob mcwhirter</a>
 *  @version $Revision: 1808870 $
 */
public class UtilTagLibrary extends TagLibrary {

    public UtilTagLibrary() {
        registerTag("available", AvailableTag.class);
        registerTag("file", FileTag.class);
        registerTag("loadText", LoadTextTag.class);
        registerTag("properties", PropertiesTag.class);
        registerTag("replace", ReplaceTag.class);
        registerTag("sleep", SleepTag.class);
        registerTag("sort", SortTag.class);
        registerTag("tokenize", TokenizeTag.class);
    }
}
