/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model;

import java.util.HashSet;
import java.util.Locale;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.ExceptionHandler;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.JXPathNotFoundException;
import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.jxpath.ri.NamespaceResolver;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.apache.commons.jxpath.ri.model.beans.NullPointer;

public abstract class NodePointer
implements Pointer {
    private static final long serialVersionUID = 8117201322861007777L;
    public static final int WHOLE_COLLECTION = Integer.MIN_VALUE;
    public static final String UNKNOWN_NAMESPACE = "<<unknown namespace>>";
    protected int index = Integer.MIN_VALUE;
    private boolean attribute;
    private NamespaceResolver namespaceResolver;
    private ExceptionHandler exceptionHandler;
    private transient Object rootNode;
    protected NodePointer parent;
    protected Locale locale;

    public static NodePointer newChildNodePointer(NodePointer parent, QName qName, Object bean) {
        NodePointerFactory[] factories;
        for (NodePointerFactory element : factories = JXPathContextReferenceImpl.getNodePointerFactories()) {
            NodePointer pointer = element.createNodePointer(parent, qName, bean);
            if (pointer == null) continue;
            return pointer;
        }
        throw new JXPathException("Could not allocate a NodePointer for object of " + bean.getClass());
    }

    public static NodePointer newNodePointer(QName qName, Object bean, Locale locale) {
        NodePointerFactory[] factories;
        if (bean == null) {
            NullPointer pointer = new NullPointer(qName, locale);
            return pointer;
        }
        for (NodePointerFactory element : factories = JXPathContextReferenceImpl.getNodePointerFactories()) {
            NodePointer pointer = element.createNodePointer(qName, bean, locale);
            if (pointer == null) continue;
            return pointer;
        }
        throw new JXPathException("Could not allocate a NodePointer for object of " + bean.getClass());
    }

    private static void printDeep(NodePointer pointer, String indent) {
        if (indent.length() == 0) {
            System.err.println("POINTER: " + pointer + "(" + pointer.getClass().getName() + ")");
        } else {
            System.err.println(indent + " of " + pointer + "(" + pointer.getClass().getName() + ")");
        }
        if (pointer.getImmediateParentPointer() != null) {
            NodePointer.printDeep(pointer.getImmediateParentPointer(), indent + "  ");
        }
    }

    private static boolean safeEquals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    public static NodePointer verify(NodePointer nodePointer) {
        NodePointer parent;
        if (!(nodePointer.isActual() || (parent = nodePointer.getImmediateParentPointer()) != null && parent.isContainer() && parent.isActual())) {
            throw new JXPathNotFoundException("No value for xpath: " + nodePointer);
        }
        return nodePointer;
    }

    protected NodePointer(NodePointer parent) {
        this.parent = parent;
    }

    protected NodePointer(NodePointer parent, Locale locale) {
        this.parent = parent;
        this.locale = locale;
    }

    @Override
    public String asPath() {
        if (this.parent != null && this.parent.isContainer()) {
            return this.parent.asPath();
        }
        StringBuilder buffer = new StringBuilder();
        if (this.parent != null) {
            buffer.append(this.parent.asPath());
        }
        if (buffer.length() == 0 || buffer.charAt(buffer.length() - 1) != '/') {
            buffer.append('/');
        }
        if (this.attribute) {
            buffer.append('@');
        }
        buffer.append(this.getName());
        if (this.index != Integer.MIN_VALUE && this.isCollection()) {
            buffer.append('[').append(this.index + 1).append(']');
        }
        return buffer.toString();
    }

    public NodeIterator attributeIterator(QName qname) {
        NodePointer valuePointer = this.getValuePointer();
        return valuePointer == null || valuePointer == this ? null : valuePointer.attributeIterator(qname);
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        NodePointer valuePointer = this.getValuePointer();
        return valuePointer == null || valuePointer == this ? null : valuePointer.childIterator(test, reverse, startWith);
    }

    @Override
    public Object clone() {
        try {
            NodePointer ptr = (NodePointer)super.clone();
            if (this.parent != null) {
                ptr.parent = (NodePointer)this.parent.clone();
            }
            return ptr;
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public abstract int compareChildNodePointers(NodePointer var1, NodePointer var2);

    private int compareNodePointers(NodePointer p1, int depth1, NodePointer p2, int depth2) {
        if (depth1 < depth2) {
            int r = this.compareNodePointers(p1, depth1, p2.parent, depth2 - 1);
            return r == 0 ? -1 : r;
        }
        if (depth1 > depth2) {
            int r = this.compareNodePointers(p1.parent, depth1 - 1, p2, depth2);
            return r == 0 ? 1 : r;
        }
        if (NodePointer.safeEquals(p1, p2)) {
            return 0;
        }
        if (depth1 == 1) {
            throw new JXPathException("Cannot compare pointers that do not belong to the same tree: '" + p1 + "' and '" + p2 + "'");
        }
        int r = this.compareNodePointers(p1.parent, depth1 - 1, p2.parent, depth2 - 1);
        return r == 0 ? p1.parent.compareChildNodePointers(p1, p2) : r;
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        NodePointer pointer = (NodePointer)object;
        if (NodePointer.safeEquals(this.parent, pointer.parent)) {
            return this.parent == null ? 0 : this.parent.compareChildNodePointers(this, pointer);
        }
        int depth1 = 0;
        NodePointer p1 = this;
        HashSet<NodePointer> parents1 = new HashSet<NodePointer>();
        while (p1 != null) {
            ++depth1;
            p1 = p1.parent;
            if (p1 == null) continue;
            parents1.add(p1);
        }
        boolean commonParentFound = false;
        int depth2 = 0;
        NodePointer p2 = pointer;
        while (p2 != null) {
            ++depth2;
            p2 = p2.parent;
            if (!parents1.contains(p2)) continue;
            commonParentFound = true;
        }
        return commonParentFound ? this.compareNodePointers(this, depth1, pointer, depth2) : 0;
    }

    public NodePointer createAttribute(JXPathContext context, QName qName) {
        throw new JXPathException("Cannot create an attribute for path " + this.asPath() + "/@" + qName + ", operation is not allowed for this type of node");
    }

    public NodePointer createChild(JXPathContext context, QName qName, int index) {
        throw new JXPathException("Cannot create an object for path " + this.asPath() + "/" + qName + "[" + (index + 1) + "], operation is not allowed for this type of node");
    }

    public NodePointer createChild(JXPathContext context, QName qName, int index, Object value) {
        throw new JXPathException("Cannot create an object for path " + this.asPath() + "/" + qName + "[" + (index + 1) + "], operation is not allowed for this type of node");
    }

    public NodePointer createPath(JXPathContext context) {
        return this;
    }

    public NodePointer createPath(JXPathContext context, Object value) {
        this.setValue(value);
        return this;
    }

    protected String escape(String string) {
        int i;
        char[] c = new char[]{'\'', '\"'};
        String[] esc = new String[]{"&apos;", "&quot;"};
        StringBuilder sb = null;
        for (i = 0; sb == null && i < c.length; ++i) {
            if (string.indexOf(c[i]) < 0) continue;
            sb = new StringBuilder(string);
        }
        if (sb == null) {
            return string;
        }
        for (i = 0; i < c.length; ++i) {
            if (string.indexOf(c[i]) < 0) continue;
            int pos = 0;
            while (pos < sb.length()) {
                if (sb.charAt(pos) == c[i]) {
                    sb.replace(pos, pos + 1, esc[i]);
                    pos += esc[i].length();
                    continue;
                }
                ++pos;
            }
        }
        return sb.toString();
    }

    protected AbstractFactory getAbstractFactory(JXPathContext context) {
        AbstractFactory factory = context.getFactory();
        if (factory == null) {
            throw new JXPathException("Factory is not set on the JXPathContext - cannot create path: " + this.asPath());
        }
        return factory;
    }

    public abstract Object getBaseValue();

    protected String getDefaultNamespaceURI() {
        return null;
    }

    public abstract Object getImmediateNode();

    public NodePointer getImmediateParentPointer() {
        return this.parent;
    }

    public NodePointer getImmediateValuePointer() {
        return this;
    }

    public int getIndex() {
        return this.index;
    }

    public abstract int getLength();

    public Locale getLocale() {
        if (this.locale == null && this.parent != null) {
            this.locale = this.parent.getLocale();
        }
        return this.locale;
    }

    public abstract QName getName();

    public NamespaceResolver getNamespaceResolver() {
        if (this.namespaceResolver == null && this.parent != null) {
            this.namespaceResolver = this.parent.getNamespaceResolver();
        }
        return this.namespaceResolver;
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getNamespaceURI(String prefix) {
        return null;
    }

    @Override
    public Object getNode() {
        return this.getValuePointer().getImmediateNode();
    }

    public NodeSet getNodeSetByKey(JXPathContext context, String key, Object value) {
        return context.getNodeSetByKey(key, value);
    }

    @Deprecated
    public Object getNodeValue() {
        return this.getNode();
    }

    public NodePointer getParent() {
        NodePointer pointer;
        for (pointer = this.parent; pointer != null && pointer.isContainer(); pointer = pointer.getImmediateParentPointer()) {
        }
        return pointer;
    }

    public Pointer getPointerByID(JXPathContext context, String id) {
        return context.getPointerByID(id);
    }

    public Pointer getPointerByKey(JXPathContext context, String key, String value) {
        return context.getPointerByKey(key, value);
    }

    @Override
    public synchronized Object getRootNode() {
        if (this.rootNode == null) {
            this.rootNode = this.parent == null ? this.getImmediateNode() : this.parent.getRootNode();
        }
        return this.rootNode;
    }

    @Override
    public Object getValue() {
        NodePointer valuePointer = this.getValuePointer();
        if (valuePointer != this) {
            return valuePointer.getValue();
        }
        return this.getNode();
    }

    public NodePointer getValuePointer() {
        NodePointer ivp = this.getImmediateValuePointer();
        return ivp == this ? this : ivp.getValuePointer();
    }

    public void handle(Throwable t) {
        this.handle(t, this);
    }

    public void handle(Throwable t, NodePointer originator) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.accept(t, originator);
            return;
        }
        if (this.parent != null) {
            this.parent.handle(t, originator);
        }
    }

    public boolean isActual() {
        return this.index == Integer.MIN_VALUE || this.index >= 0 && this.index < this.getLength();
    }

    public boolean isAttribute() {
        return this.attribute;
    }

    public abstract boolean isCollection();

    public boolean isContainer() {
        return false;
    }

    protected boolean isDefaultNamespace(String prefix) {
        if (prefix == null) {
            return true;
        }
        String namespace = this.getNamespaceURI(prefix);
        return namespace != null && namespace.equals(this.getDefaultNamespaceURI());
    }

    public boolean isLanguage(String lang) {
        Locale loc = this.getLocale();
        String name = loc.toString().replace('_', '-');
        return name.toUpperCase(Locale.ENGLISH).startsWith(lang.toUpperCase(Locale.ENGLISH));
    }

    public abstract boolean isLeaf();

    @Deprecated
    public boolean isNode() {
        return !this.isContainer();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public NodeIterator namespaceIterator() {
        return null;
    }

    public NodePointer namespacePointer(String namespace) {
        return null;
    }

    public void printPointerChain() {
        NodePointer.printDeep(this, "");
    }

    public void remove() {
    }

    public void setAttribute(boolean attribute) {
        this.attribute = attribute;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }

    @Override
    public abstract void setValue(Object var1);

    public boolean testNode(NodeTest test) {
        if (test == null) {
            return true;
        }
        if (test instanceof NodeNameTest) {
            String nodeNS;
            String testNS;
            String nodePrefix;
            if (this.isContainer()) {
                return false;
            }
            NodeNameTest nodeNameTest = (NodeNameTest)test;
            QName testName = nodeNameTest.getNodeName();
            QName nodeName = this.getName();
            if (nodeName == null) {
                return false;
            }
            String testPrefix = testName.getPrefix();
            if (!NodePointer.safeEquals(testPrefix, nodePrefix = nodeName.getPrefix()) && !NodePointer.safeEquals(testNS = this.getNamespaceURI(testPrefix), nodeNS = this.getNamespaceURI(nodePrefix))) {
                return false;
            }
            if (nodeNameTest.isWildcard()) {
                return true;
            }
            return testName.getName().equals(nodeName.getName());
        }
        return test instanceof NodeTypeTest && ((NodeTypeTest)test).getNodeType() == 1 && this.isNode();
    }

    public String toString() {
        return this.asPath();
    }
}

