/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.ml.clustering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.math4.legacy.exception.NotPositiveException;
import org.apache.commons.math4.legacy.exception.NullArgumentException;
import org.apache.commons.math4.legacy.ml.clustering.Cluster;
import org.apache.commons.math4.legacy.ml.clustering.Clusterable;
import org.apache.commons.math4.legacy.ml.clustering.Clusterer;
import org.apache.commons.math4.legacy.ml.distance.DistanceMeasure;
import org.apache.commons.math4.legacy.ml.distance.EuclideanDistance;

public class DBSCANClusterer<T extends Clusterable>
extends Clusterer<T> {
    private final double eps;
    private final int minPts;

    public DBSCANClusterer(double eps, int minPts) {
        this(eps, minPts, new EuclideanDistance());
    }

    public DBSCANClusterer(double eps, int minPts, DistanceMeasure measure) {
        super(measure);
        if (eps < 0.0) {
            throw new NotPositiveException((Number)eps);
        }
        if (minPts < 0) {
            throw new NotPositiveException((Number)minPts);
        }
        this.eps = eps;
        this.minPts = minPts;
    }

    public double getEps() {
        return this.eps;
    }

    public int getMinPts() {
        return this.minPts;
    }

    @Override
    public List<Cluster<T>> cluster(Collection<T> points) {
        NullArgumentException.check(points);
        ArrayList<Cluster<T>> clusters = new ArrayList<Cluster<T>>();
        HashMap<Clusterable, PointStatus> visited = new HashMap<Clusterable, PointStatus>();
        for (Clusterable point : points) {
            if (visited.get(point) != null) continue;
            List<Clusterable> neighbors = this.getNeighbors(point, points);
            if (neighbors.size() >= this.minPts) {
                Cluster cluster = new Cluster();
                clusters.add(this.expandCluster(cluster, point, neighbors, points, visited));
                continue;
            }
            visited.put(point, PointStatus.NOISE);
        }
        return clusters;
    }

    private Cluster<T> expandCluster(Cluster<T> cluster, T point, List<T> neighbors, Collection<T> points, Map<Clusterable, PointStatus> visited) {
        cluster.addPoint((Clusterable)point);
        visited.put((Clusterable)point, PointStatus.PART_OF_CLUSTER);
        List<Object> seeds = new ArrayList<T>(neighbors);
        for (int index = 0; index < seeds.size(); ++index) {
            List<Clusterable> currentNeighbors;
            Clusterable current = (Clusterable)seeds.get(index);
            PointStatus pStatus = visited.get(current);
            if (pStatus == null && (currentNeighbors = this.getNeighbors(current, points)).size() >= this.minPts) {
                seeds = this.merge(seeds, currentNeighbors);
            }
            if (pStatus == PointStatus.PART_OF_CLUSTER) continue;
            visited.put(current, PointStatus.PART_OF_CLUSTER);
            cluster.addPoint(current);
        }
        return cluster;
    }

    private List<T> getNeighbors(T point, Collection<T> points) {
        return points.stream().filter(neighbor -> point != neighbor && this.distance((Clusterable)neighbor, (Clusterable)point) <= this.eps).collect(Collectors.toList());
    }

    private List<T> merge(List<T> one, List<T> two) {
        HashSet oneSet = new HashSet(one);
        two.stream().filter(item -> !oneSet.contains(item)).forEach(one::add);
        return one;
    }

    private static enum PointStatus {
        NOISE,
        PART_OF_CLUSTER;

    }
}

