/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.fraction;

import java.util.function.Supplier;
import org.apache.commons.numbers.fraction.FractionException;

public final class GeneralizedContinuedFraction {
    static final double SMALL = 1.0E-50;
    static final int DEFAULT_ITERATIONS = Integer.MAX_VALUE;
    private static final double MIN_EPSILON = (double)1.110223E-16f;
    private static final double MAX_EPSILON = 0.5;
    private static final double DEFAULT_LOW = 0.9999999999999999;
    private static final double DEFAULT_EPS = 2.220446049250313E-16;

    private GeneralizedContinuedFraction() {
    }

    public static double value(Supplier<Coefficient> gen) {
        return GeneralizedContinuedFraction.value(gen, 1.110223E-16f, Integer.MAX_VALUE);
    }

    public static double value(Supplier<Coefficient> gen, double epsilon) {
        return GeneralizedContinuedFraction.value(gen, epsilon, Integer.MAX_VALUE);
    }

    public static double value(Supplier<Coefficient> gen, double epsilon, int maxIterations) {
        Coefficient c = gen.get();
        return GeneralizedContinuedFraction.evaluate(c.getB(), gen, epsilon, maxIterations);
    }

    public static double value(double b0, Supplier<Coefficient> gen) {
        return GeneralizedContinuedFraction.value(b0, gen, 1.110223E-16f, Integer.MAX_VALUE);
    }

    public static double value(double b0, Supplier<Coefficient> gen, double epsilon) {
        return GeneralizedContinuedFraction.value(b0, gen, epsilon, Integer.MAX_VALUE);
    }

    public static double value(double b0, Supplier<Coefficient> gen, double epsilon, int maxIterations) {
        Coefficient c = gen.get();
        return b0 + c.getA() / GeneralizedContinuedFraction.evaluate(c.getB(), gen, epsilon, maxIterations);
    }

    static double evaluate(double b0, Supplier<Coefficient> gen, double epsilon, int maxIterations) {
        double eps;
        double low;
        if (epsilon > (double)1.110223E-16f && epsilon <= 0.5) {
            low = 1.0 - epsilon;
            eps = 1.0 / low - 1.0;
        } else {
            low = 0.9999999999999999;
            eps = 2.220446049250313E-16;
        }
        double hPrev = GeneralizedContinuedFraction.updateIfCloseToZero(b0);
        double dPrev = 0.0;
        double cPrev = hPrev;
        for (int n = maxIterations; n > 0; --n) {
            Coefficient c = gen.get();
            double a = c.getA();
            double b = c.getB();
            double dN = GeneralizedContinuedFraction.updateIfCloseToZero(b + a * dPrev);
            double cN = GeneralizedContinuedFraction.updateIfCloseToZero(b + a / cPrev);
            double deltaN = cN * (dN = 1.0 / dN);
            double hN = hPrev * deltaN;
            if (!Double.isFinite(hN)) {
                throw new FractionException("Continued fraction diverged to " + hN);
            }
            if (deltaN == 0.0) {
                throw new FractionException("Ratio of successive convergents is zero");
            }
            if (Math.abs(deltaN - 1.0) <= eps && deltaN >= low) {
                return hN;
            }
            dPrev = dN;
            cPrev = cN;
            hPrev = hN;
        }
        throw new FractionException("Maximum iterations (%d) exceeded", maxIterations);
    }

    private static double updateIfCloseToZero(double value) {
        return Math.abs(value) < 1.0E-50 ? Math.copySign(1.0E-50, value) : value;
    }

    public static final class Coefficient {
        private final double a;
        private final double b;

        private Coefficient(double a, double b) {
            this.a = a;
            this.b = b;
        }

        public double getA() {
            return this.a;
        }

        public double getB() {
            return this.b;
        }

        public static Coefficient of(double a, double b) {
            return new Coefficient(a, b);
        }
    }
}

