/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.matcher;

import org.apache.commons.text.matcher.AbstractStringMatcher;
import org.apache.commons.text.matcher.StringMatcher;
import org.apache.commons.text.matcher.StringMatcherFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class StringMatcherOnCharArrayTest {
    private static final char[] INPUT1 = "0,1\t2 3\n\r\f\u0000'\"".toCharArray();
    private static final char[] INPUT2 = "abcdef".toCharArray();
    private static final int INPUT2_LENGTH = INPUT2.length;

    StringMatcherOnCharArrayTest() {
    }

    private void checkAndMatcher_char(StringMatcher matcher) {
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 0, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 1, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)3, (int)matcher.isMatch(INPUT2, 2, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 3, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 4, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 5, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 0));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 1));
        Assertions.assertEquals((int)3, (int)matcher.isMatch(INPUT2, 2));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 3));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 4));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 5));
    }

    @Test
    void testAndMatcher_char() {
        StringMatcher matcher1 = StringMatcherFactory.INSTANCE.andMatcher(new StringMatcher[]{StringMatcherFactory.INSTANCE.charMatcher('c'), StringMatcherFactory.INSTANCE.stringMatcher("de")});
        Assertions.assertEquals((int)3, (int)matcher1.size());
        this.checkAndMatcher_char(matcher1);
        StringMatcher matcher2 = StringMatcherFactory.INSTANCE.andMatcher(new StringMatcher[]{null, StringMatcherFactory.INSTANCE.charMatcher('c'), null, StringMatcherFactory.INSTANCE.stringMatcher("de"), null});
        Assertions.assertEquals((int)3, (int)matcher2.size());
        this.checkAndMatcher_char(matcher2);
    }

    @Test
    void testCharMatcher_char() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.charMatcher('c');
        Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 0, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 1, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT2, 2, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 3, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 4, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 5, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 0));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 1));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT2, 2));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 3));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 4));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 5));
    }

    @Test
    void testCharSetMatcher_charArray() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.charSetMatcher("ace".toCharArray());
        Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT2, 0, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 1, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT2, 2, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 3, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT2, 4, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 5, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT2, 0));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 1));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT2, 2));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 3));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT2, 4));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 5));
        Assertions.assertSame((Object)StringMatcherFactory.INSTANCE.charSetMatcher(new char[0]), (Object)StringMatcherFactory.INSTANCE.noneMatcher());
        Assertions.assertSame((Object)StringMatcherFactory.INSTANCE.charSetMatcher((char[])null), (Object)StringMatcherFactory.INSTANCE.noneMatcher());
        Assertions.assertInstanceOf(AbstractStringMatcher.CharMatcher.class, (Object)StringMatcherFactory.INSTANCE.charSetMatcher("a".toCharArray()));
    }

    @Test
    void testCharSetMatcher_String() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.charSetMatcher("ace");
        Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT2, 0, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 1, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT2, 2, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 3, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT2, 4, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 5, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT2, 0));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 1));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT2, 2));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 3));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT2, 4));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 5));
        Assertions.assertSame((Object)StringMatcherFactory.INSTANCE.charSetMatcher(""), (Object)StringMatcherFactory.INSTANCE.noneMatcher());
        Assertions.assertSame((Object)StringMatcherFactory.INSTANCE.charSetMatcher((String)null), (Object)StringMatcherFactory.INSTANCE.noneMatcher());
        Assertions.assertInstanceOf(AbstractStringMatcher.CharMatcher.class, (Object)StringMatcherFactory.INSTANCE.charSetMatcher("a"));
    }

    @Test
    void testCommaMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.commaMatcher();
        Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertSame((Object)StringMatcherFactory.INSTANCE.commaMatcher(), (Object)matcher);
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 0, 0, INPUT1.length));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 1, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 2, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 0));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 1));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 2));
    }

    @Test
    void testDoubleQuoteMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.doubleQuoteMatcher();
        Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertSame((Object)StringMatcherFactory.INSTANCE.doubleQuoteMatcher(), (Object)matcher);
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 11, 0, INPUT1.length));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 12, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 11));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 12));
    }

    @Test
    void testMatcherIndices() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.stringMatcher("bc");
        Assertions.assertEquals((int)2, (int)matcher.size());
        Assertions.assertEquals((int)2, (int)matcher.isMatch(INPUT2, 1, 1, INPUT2_LENGTH));
        Assertions.assertEquals((int)2, (int)matcher.isMatch(INPUT2, 1, 0, 3));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 1, 0, 2));
    }

    @Test
    void testNoneMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.noneMatcher();
        Assertions.assertEquals((int)0, (int)matcher.size());
        Assertions.assertSame((Object)StringMatcherFactory.INSTANCE.noneMatcher(), (Object)matcher);
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 0, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 1, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 2, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 3, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 4, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 5, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 6, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 7, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 8, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 9, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 10, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 11, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 12, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 0));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 1));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 2));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 3));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 4));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 5));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 6));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 7));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 8));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 9));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 10));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 11));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 12));
    }

    @Test
    void testQuoteMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.quoteMatcher();
        Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertSame((Object)StringMatcherFactory.INSTANCE.quoteMatcher(), (Object)matcher);
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 10, 0, INPUT1.length));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 11, 0, INPUT1.length));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 12, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 10));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 11));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 12));
    }

    @Test
    void testSingleQuoteMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.singleQuoteMatcher();
        Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertSame((Object)StringMatcherFactory.INSTANCE.singleQuoteMatcher(), (Object)matcher);
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 10, 0, INPUT1.length));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 11, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 12, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 10));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 11));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 12));
    }

    @Test
    void testSpaceMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.spaceMatcher();
        Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertSame((Object)StringMatcherFactory.INSTANCE.spaceMatcher(), (Object)matcher);
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 4, 0, INPUT1.length));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 5, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 6, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 4));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 5));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 6));
    }

    @Test
    void testSplitMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.splitMatcher();
        Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertSame((Object)StringMatcherFactory.INSTANCE.splitMatcher(), (Object)matcher);
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 2, 0, INPUT1.length));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 3, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 4, 0, INPUT1.length));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 5, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 6, 0, INPUT1.length));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 7, 0, INPUT1.length));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 8, 0, INPUT1.length));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 9, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 10, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 2));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 3));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 4));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 5));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 6));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 7));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 8));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 9));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 10));
    }

    private void testStringMatcher_String(StringMatcher matcher) {
        Assertions.assertEquals((int)2, (int)matcher.size());
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 0, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)2, (int)matcher.isMatch(INPUT2, 1, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 2, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 3, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 4, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 5, 0, INPUT2_LENGTH));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 0));
        Assertions.assertEquals((int)2, (int)matcher.isMatch(INPUT2, 1));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 2));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 3));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 4));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT2, 5));
        Assertions.assertSame((Object)StringMatcherFactory.INSTANCE.stringMatcher(""), (Object)StringMatcherFactory.INSTANCE.noneMatcher());
        Assertions.assertSame((Object)StringMatcherFactory.INSTANCE.stringMatcher((String)null), (Object)StringMatcherFactory.INSTANCE.noneMatcher());
    }

    @Test
    void testStringMatcher_String_fromChars() {
        this.testStringMatcher_String(StringMatcherFactory.INSTANCE.stringMatcher(new char[]{'b', 'c'}));
        this.testStringMatcher_String(StringMatcherFactory.INSTANCE.stringMatcher(new char[]{'b', 'c'}));
    }

    @Test
    void testStringMatcher_String_fromString() {
        this.testStringMatcher_String(StringMatcherFactory.INSTANCE.stringMatcher("bc"));
    }

    @Test
    void testTabMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.tabMatcher();
        Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertSame((Object)StringMatcherFactory.INSTANCE.tabMatcher(), (Object)matcher);
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 2, 0, INPUT1.length));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 3, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 4, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 2));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 3));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 4));
    }

    @Test
    void testTrimMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.trimMatcher();
        Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertSame((Object)StringMatcherFactory.INSTANCE.trimMatcher(), (Object)matcher);
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 2, 0, INPUT1.length));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 3, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 4, 0, INPUT1.length));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 5, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 6, 0, INPUT1.length));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 7, 0, INPUT1.length));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 8, 0, INPUT1.length));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 9, 0, INPUT1.length));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 10, 0, INPUT1.length));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 2));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 3));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 4));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 5));
        Assertions.assertEquals((int)0, (int)matcher.isMatch(INPUT1, 6));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 7));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 8));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 9));
        Assertions.assertEquals((int)1, (int)matcher.isMatch(INPUT1, 10));
    }
}

