/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.ctakes.ytex.uima.model;

import java.io.Serializable;

/**
 * Reference data.  Defines YTEX uimaTypeID, uimaTypeName (Class name), and tableName.
 * We need our own uima Type ID because the typeID field in the annotation is generated dynamically -
 * it can change.
 * Mapped to ref_uima_type.
 * 
 * @author vijay
 *
 */
public class UimaType implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private String tableName;
	private int uimaTypeID;
	private String uimaTypeName;
	public UimaType() {
		super();
	}
	public UimaType(int uimaTypeID, String uimaTypeName) {
		super();
		this.uimaTypeID = uimaTypeID;
		this.uimaTypeName = uimaTypeName;
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		UimaType other = (UimaType) obj;
		if (uimaTypeID != other.uimaTypeID)
			return false;
		return true;
	}
	public String getTableName() {
		return tableName;
	}
	public int getUimaTypeID() {
		return uimaTypeID;
	}
	public String getUimaTypeName() {
		return uimaTypeName;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + uimaTypeID;
		return result;
	}
	public void setTableName(String tableName) {
		this.tableName = tableName;
	}
	public void setUimaTypeID(int uimaTypeID) {
		this.uimaTypeID = uimaTypeID;
	}
	public void setUimaTypeName(String uimaTypeName) {
		this.uimaTypeName = uimaTypeName;
	}
	@Override
	public String toString() {
		return "UimaType [uimaTypeName=" + uimaTypeName + "]";
	}
}
