/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OrderColumn;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

@Entity
public class ServerAuthorizationCodeGrant
extends AuthorizationCodeGrant {
    private static final long serialVersionUID = -5004608901535459036L;
    private long issuedAt;
    private long expiresIn;
    private Client client;
    private List<String> approvedScopes = new LinkedList<String>();
    private List<String> requestedScopes = new LinkedList<String>();
    private UserSubject subject;
    private String audience;
    private String responseType;
    private String clientCodeChallenge;
    private String clientCodeChallengeMethod;
    private String nonce;
    private boolean preauthorizedTokenAvailable;
    private Map<String, String> extraProperties = new LinkedHashMap<String, String>();

    public ServerAuthorizationCodeGrant() {
    }

    public ServerAuthorizationCodeGrant(Client client, long lifetime) {
        this(client, OAuthUtils.generateRandomTokenKey(), lifetime, OAuthUtils.getIssuedAt());
    }

    public ServerAuthorizationCodeGrant(Client client, String code, long expiresIn, long issuedAt) {
        super(code);
        this.client = client;
        this.expiresIn = expiresIn;
        this.issuedAt = issuedAt;
    }

    public long getIssuedAt() {
        return this.issuedAt;
    }

    public void setIssuedAt(long issuedAt) {
        this.issuedAt = issuedAt;
    }

    public long getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(long expiresIn) {
        this.expiresIn = expiresIn;
    }

    @ManyToOne
    public Client getClient() {
        return this.client;
    }

    public void setClient(Client c) {
        this.client = c;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @OrderColumn
    public List<String> getApprovedScopes() {
        return this.approvedScopes;
    }

    public void setApprovedScopes(List<String> scopes) {
        this.approvedScopes = scopes;
    }

    @ManyToOne
    public UserSubject getSubject() {
        return this.subject;
    }

    public void setSubject(UserSubject subject) {
        this.subject = subject;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public String getClientCodeChallenge() {
        return this.clientCodeChallenge;
    }

    public void setClientCodeChallenge(String clientCodeChallenge) {
        this.clientCodeChallenge = clientCodeChallenge;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @OrderColumn
    public List<String> getRequestedScopes() {
        return this.requestedScopes;
    }

    public void setRequestedScopes(List<String> requestedScopes) {
        this.requestedScopes = requestedScopes;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public boolean isPreauthorizedTokenAvailable() {
        return this.preauthorizedTokenAvailable;
    }

    public void setPreauthorizedTokenAvailable(boolean preauthorizedTokenAvailable) {
        this.preauthorizedTokenAvailable = preauthorizedTokenAvailable;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @MapKeyColumn(name="extraPropName")
    public Map<String, String> getExtraProperties() {
        return this.extraProperties;
    }

    public void setExtraProperties(Map<String, String> extraProperties) {
        this.extraProperties = extraProperties;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getClientCodeChallengeMethod() {
        return this.clientCodeChallengeMethod;
    }

    public void setClientCodeChallengeMethod(String clientCodeChallengeMethod) {
        this.clientCodeChallengeMethod = clientCodeChallengeMethod;
    }
}

