/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.metrics.dropwizard;

import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.jmx.JmxReporter;
import io.dropwizard.metrics5.jmx.ObjectNameFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.metrics.MetricsContext;
import org.apache.cxf.metrics.MetricsProvider;
import org.apache.cxf.metrics.dropwizard.DropwizardMetricsContext;
import org.apache.cxf.service.model.BindingOperationInfo;

@NoJSR250Annotations
public class DropwizardMetricsProvider
implements MetricsProvider {
    private static final String QUESTION_MARK = "?";
    private static final String ESCAPED_QUESTION_MARK = "\\?";
    protected Bus bus;
    protected MetricRegistry registry;

    public DropwizardMetricsProvider(Bus b) {
        this.bus = b;
        this.registry = (MetricRegistry)b.getExtension(MetricRegistry.class);
        if (this.registry == null) {
            this.registry = new MetricRegistry();
            DropwizardMetricsProvider.setupJMXReporter(b, this.registry);
        }
    }

    public static void setupJMXReporter(Bus b, MetricRegistry reg) {
        InstrumentationManager im = (InstrumentationManager)b.getExtension(InstrumentationManager.class);
        if (im != null) {
            JmxReporter reporter = JmxReporter.forRegistry((MetricRegistry)reg).registerWith(im.getMBeanServer()).inDomain("org.apache.cxf").createsObjectNamesWith(new ObjectNameFactory(){

                public ObjectName createName(String type, String domain, MetricName name) {
                    try {
                        return new ObjectName(name.getKey());
                    }
                    catch (MalformedObjectNameException e) {
                        throw new RuntimeException(e);
                    }
                }
            }).build();
            reporter.start();
        }
    }

    protected String escapePatternChars(String value) {
        if (value.lastIndexOf(QUESTION_MARK) != -1) {
            value = value.replace(QUESTION_MARK, ESCAPED_QUESTION_MARK);
        }
        return value;
    }

    StringBuilder getBaseServiceName(Endpoint endpoint, boolean isClient, String clientId) {
        StringBuilder buffer = new StringBuilder();
        if (endpoint.get((Object)"org.apache.cxf.management.service.counter.name") != null) {
            buffer.append(endpoint.get((Object)"org.apache.cxf.management.service.counter.name"));
        } else {
            buffer.append("org.apache.cxf").append(':');
            buffer.append("bus.id").append('=').append(this.bus.getId()).append(',');
            buffer.append("type").append("=Metrics");
            buffer.append(isClient ? ".Client," : ".Server,");
            buffer.append("service").append("=\"").append(this.escapePatternChars(endpoint.getService().getName().toString())).append("\",");
            buffer.append("port").append("=\"").append(endpoint.getEndpointInfo().getName().getLocalPart()).append("\",");
            if (clientId != null) {
                buffer.append("Client=").append(clientId).append(',');
            }
        }
        return buffer;
    }

    @Override
    public MetricsContext createEndpointContext(Endpoint endpoint, boolean isClient, String clientId) {
        StringBuilder buffer = this.getBaseServiceName(endpoint, isClient, clientId);
        String baseName = buffer.toString();
        return new DropwizardMetricsContext(baseName, this.registry);
    }

    @Override
    public MetricsContext createOperationContext(Endpoint endpoint, BindingOperationInfo boi, boolean asClient, String clientId) {
        StringBuilder buffer = this.getBaseServiceName(endpoint, asClient, clientId);
        buffer.append("Operation=").append(boi.getName().getLocalPart()).append(',');
        return new DropwizardMetricsContext(buffer.toString(), this.registry);
    }

    @Override
    public MetricsContext createResourceContext(Endpoint endpoint, String resourceName, boolean asClient, String clientId) {
        StringBuilder buffer = this.getBaseServiceName(endpoint, asClient, clientId);
        buffer.append("Operation=").append(resourceName).append(',');
        return new DropwizardMetricsContext(buffer.toString(), this.registry);
    }
}

