/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.offheapstore.storage.allocator;

import org.ehcache.shadow.org.terracotta.offheapstore.storage.allocator.Region;
import org.ehcache.shadow.org.terracotta.offheapstore.util.AATreeSet;
import org.ehcache.shadow.org.terracotta.offheapstore.util.DebuggingUtils;
import org.ehcache.shadow.org.terracotta.offheapstore.util.Validation;

public class PowerOfTwoAllocator
extends AATreeSet<Region> {
    private static final boolean DEBUG = Boolean.getBoolean(PowerOfTwoAllocator.class.getName() + ".DEBUG");
    private static final boolean VALIDATING = Validation.shouldValidate(PowerOfTwoAllocator.class);
    private final int size;
    private volatile int occupied;

    public PowerOfTwoAllocator(int size) {
        this.add(new Region(0, size - 1));
        this.size = size;
    }

    public int allocate(int size, Packing packing) {
        if (Integer.bitCount(size) != 1) {
            throw new AssertionError((Object)("Size " + size + " is not a power of two"));
        }
        Region r = this.findRegion(size, packing);
        if (r == null) {
            return -1;
        }
        Region current = this.removeAndReturn(r.start());
        Region newRange = current.remove(r);
        if (newRange != null) {
            this.insert(current);
            this.insert(newRange);
        } else if (!current.isNull()) {
            this.insert(current);
        }
        this.occupied += r.size();
        this.validateFreeSpace();
        return r.start();
    }

    public void free(int address, int length) {
        if (length != 0) {
            this.free(new Region(address, address + length - 1));
            this.occupied -= length;
            this.validateFreeSpace();
        }
    }

    public void tryFree(int address, int length) {
        if (length == 0) {
            return;
        }
        if (this.tryFree(new Region(address, address + length - 1))) {
            this.occupied -= length;
            this.validateFreeSpace();
        }
    }

    public int find(int size, Packing packing) {
        if (Integer.bitCount(size) != 1) {
            throw new AssertionError((Object)("Size " + size + " is not a power of two"));
        }
        Region r = this.findRegion(size, packing);
        if (r == null) {
            return -1;
        }
        return r.start();
    }

    public void claim(int address, int size) {
        Region r;
        Region current = this.removeAndReturn(address);
        Region newRange = current.remove(r = new Region(address, address + size - 1));
        if (newRange != null) {
            this.insert(current);
            this.insert(newRange);
        } else if (!current.isNull()) {
            this.insert(current);
        }
        this.occupied += size;
        this.validateFreeSpace();
    }

    public int occupied() {
        return this.occupied;
    }

    @Override
    public Region removeAndReturn(Object o) {
        Region r = (Region)super.removeAndReturn(o);
        if (r != null) {
            return new Region(r);
        }
        return null;
    }

    @Override
    public Region find(Object o) {
        Region r = (Region)super.find(o);
        if (r != null) {
            return new Region(r);
        }
        return null;
    }

    private void free(Region r) {
        Region prev = this.removeAndReturn(r.start() - 1);
        if (prev != null) {
            prev.merge(r);
            Region next = this.removeAndReturn(r.end() + 1);
            if (next != null) {
                prev.merge(next);
            }
            this.insert(prev);
            return;
        }
        Region next = this.removeAndReturn(r.end() + 1);
        if (next != null) {
            next.merge(r);
            this.insert(next);
            return;
        }
        this.insert(r);
    }

    private boolean tryFree(Region r) {
        Region prev = this.removeAndReturn(r.start() - 1);
        if (prev != null) {
            if (prev.tryMerge(r)) {
                Region next = this.removeAndReturn(r.end() + 1);
                if (next != null) {
                    prev.merge(next);
                }
                this.insert(prev);
                return true;
            }
            this.insert(prev);
            return false;
        }
        Region next = this.removeAndReturn(r.end() + 1);
        if (next != null) {
            if (next.tryMerge(r)) {
                this.insert(next);
                return true;
            }
            this.insert(next);
            return false;
        }
        return this.tryInsert(r);
    }

    private void insert(Region x) {
        if (!this.tryInsert(x)) {
            throw new AssertionError((Object)(x + " is already inserted"));
        }
    }

    private boolean tryInsert(Region x) {
        return this.add(x);
    }

    private Region findRegion(int size, Packing packing) {
        Validation.validate(!VALIDATING || Integer.bitCount(size) == 1);
        AATreeSet.Node<Region> currentNode = this.getRoot();
        Region currentRegion = (Region)currentNode.getPayload();
        if (currentRegion == null || (currentRegion.available() & size) == 0) {
            return null;
        }
        while (true) {
            AATreeSet.Node<Region> prefered;
            Region preferedRegion;
            if ((preferedRegion = (prefered = packing.prefered(currentNode)).getPayload()) != null && (preferedRegion.available() & size) != 0) {
                currentNode = prefered;
                currentRegion = preferedRegion;
                continue;
            }
            if ((currentRegion.availableHere() & size) != 0) {
                return packing.slice(currentRegion, size);
            }
            AATreeSet.Node<Region> fallback = packing.fallback(currentNode);
            Region fallbackRegion = fallback.getPayload();
            if (fallbackRegion == null || (fallbackRegion.available() & size) == 0) break;
            currentNode = fallback;
            currentRegion = fallbackRegion;
        }
        throw new AssertionError();
    }

    @Override
    public String toString() {
        Region rootRegion = (Region)this.getRoot().getPayload();
        StringBuilder sb = new StringBuilder("PowerOfTwoAllocator: Occupied ");
        sb.append(DebuggingUtils.toBase2SuffixedString(this.occupied())).append("B");
        sb.append(" [Largest Available Area ").append(DebuggingUtils.toBase2SuffixedString(Integer.highestOneBit(rootRegion == null ? 0 : rootRegion.available()))).append("B]");
        if (DEBUG) {
            sb.append("\nFree Regions = ").append(super.toString()).append("");
        }
        return sb.toString();
    }

    private void validateFreeSpace() {
        if (VALIDATING) {
            Region rootRegion = (Region)this.getRoot().getPayload();
            if (this.occupied() != this.size - (rootRegion == null ? 0 : rootRegion.treeSize())) {
                throw new AssertionError((Object)("Occupied:" + this.occupied() + " Size-TreeSize:" + (this.size - (rootRegion == null ? 0 : rootRegion.treeSize()))));
            }
        }
    }

    public static enum Packing {
        FLOOR{

            @Override
            AATreeSet.Node<Region> prefered(AATreeSet.Node<Region> node) {
                return node.getLeft();
            }

            @Override
            AATreeSet.Node<Region> fallback(AATreeSet.Node<Region> node) {
                return node.getRight();
            }

            @Override
            Region slice(Region region, int size) {
                int mask = size - 1;
                int a = region.start() + mask & ~mask;
                return new Region(a, a + size - 1);
            }
        }
        ,
        CEILING{

            @Override
            AATreeSet.Node<Region> prefered(AATreeSet.Node<Region> node) {
                return node.getRight();
            }

            @Override
            AATreeSet.Node<Region> fallback(AATreeSet.Node<Region> node) {
                return node.getLeft();
            }

            @Override
            Region slice(Region region, int size) {
                int mask = size - 1;
                int a = region.end() + 1 & ~mask;
                return new Region(a - size, a - 1);
            }
        };


        abstract AATreeSet.Node<Region> prefered(AATreeSet.Node<Region> var1);

        abstract AATreeSet.Node<Region> fallback(AATreeSet.Node<Region> var1);

        abstract Region slice(Region var1, int var2);
    }
}

