/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.cluster;

import lombok.Generated;
import org.apache.dolphinscheduler.common.model.MasterHeartBeat;
import org.apache.dolphinscheduler.common.model.WorkerHeartBeat;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.SubscribeListener;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.apache.dolphinscheduler.server.master.cluster.MasterClusters;
import org.apache.dolphinscheduler.server.master.cluster.MasterServerMetadata;
import org.apache.dolphinscheduler.server.master.cluster.MasterSlotChangeListenerAdaptor;
import org.apache.dolphinscheduler.server.master.cluster.MasterSlotManager;
import org.apache.dolphinscheduler.server.master.cluster.WorkerClusters;
import org.apache.dolphinscheduler.server.master.cluster.WorkerGroupChangeNotifier;
import org.apache.dolphinscheduler.server.master.cluster.WorkerServerMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClusterManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterManager.class);
    private MasterClusters masterClusters = new MasterClusters();
    private WorkerClusters workerClusters = new WorkerClusters();
    @Autowired
    private MasterSlotManager masterSlotManager;
    @Autowired
    private WorkerGroupChangeNotifier workerGroupChangeNotifier;
    @Autowired
    private RegistryClient registryClient;

    public void start() {
        this.initializeMasterClusters();
        this.initializeWorkerClusters();
        log.info("ClusterManager started...");
    }

    private void initializeMasterClusters() {
        this.masterClusters.registerListener(new MasterSlotChangeListenerAdaptor(this.masterSlotManager, this.masterClusters));
        this.registryClient.getServerList(RegistryNodeType.MASTER).forEach(server -> {
            MasterHeartBeat masterHeartBeat = (MasterHeartBeat)JSONUtils.parseObject((String)server.getHeartBeatInfo(), MasterHeartBeat.class);
            this.masterClusters.onServerAdded(MasterServerMetadata.parseFromHeartBeat(masterHeartBeat));
        });
        log.info("Initialized MasterClusters: {}", (Object)JSONUtils.toPrettyJsonString(this.masterClusters.getServers()));
        this.registryClient.subscribe(RegistryNodeType.MASTER.getRegistryPath(), (SubscribeListener)this.masterClusters);
    }

    private void initializeWorkerClusters() {
        this.registryClient.getServerList(RegistryNodeType.WORKER).forEach(server -> {
            WorkerHeartBeat workerHeartBeat = (WorkerHeartBeat)JSONUtils.parseObject((String)server.getHeartBeatInfo(), WorkerHeartBeat.class);
            this.workerClusters.onServerAdded(WorkerServerMetadata.parseFromHeartBeat(workerHeartBeat));
        });
        log.info("Initialized WorkerClusters: {}", (Object)JSONUtils.toPrettyJsonString(this.workerClusters.getServers()));
        this.registryClient.subscribe(RegistryNodeType.WORKER.getRegistryPath(), (SubscribeListener)this.workerClusters);
        this.workerGroupChangeNotifier.subscribeWorkerGroupsChange(this.workerClusters);
        this.workerGroupChangeNotifier.start();
    }

    @Generated
    public MasterClusters getMasterClusters() {
        return this.masterClusters;
    }

    @Generated
    public WorkerClusters getWorkerClusters() {
        return this.workerClusters;
    }
}

