/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.cluster;

import java.util.Date;
import lombok.Generated;
import org.apache.dolphinscheduler.server.master.cluster.ClusterManager;
import org.apache.dolphinscheduler.server.master.cluster.IClusters;
import org.apache.dolphinscheduler.server.master.cluster.MasterServerMetadata;
import org.apache.dolphinscheduler.server.master.cluster.WorkerServerMetadata;
import org.apache.dolphinscheduler.server.master.engine.system.SystemEventBus;
import org.apache.dolphinscheduler.server.master.engine.system.event.MasterFailoverEvent;
import org.apache.dolphinscheduler.server.master.engine.system.event.WorkerFailoverEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClusterStateMonitors {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterStateMonitors.class);
    @Autowired
    private ClusterManager clusterManager;
    @Autowired
    private SystemEventBus systemEventBus;

    public void start() {
        this.clusterManager.getMasterClusters().registerListener((IClusters.IClustersChangeListener<MasterServerMetadata>)((IClusters.ServerRemovedListener<MasterServerMetadata>)this::masterRemoved));
        this.clusterManager.getWorkerClusters().registerListener((IClusters.IClustersChangeListener<WorkerServerMetadata>)((IClusters.ServerRemovedListener<WorkerServerMetadata>)this::workerRemoved));
        log.info("ClusterStateMonitors started...");
    }

    void masterRemoved(MasterServerMetadata masterServer) {
        this.systemEventBus.publish(MasterFailoverEvent.of(masterServer, new Date(), 30000L));
    }

    void workerRemoved(WorkerServerMetadata workerServer) {
        this.systemEventBus.publish(WorkerFailoverEvent.of(workerServer, new Date(), 30000L));
    }
}

