/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.TaskGroupQueueStatus;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.common.thread.BaseDaemonThread;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskGroup;
import org.apache.dolphinscheduler.dao.entity.TaskGroupQueue;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.repository.TaskGroupDao;
import org.apache.dolphinscheduler.dao.repository.TaskGroupQueueDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.extract.base.client.Clients;
import org.apache.dolphinscheduler.extract.master.ITaskInstanceController;
import org.apache.dolphinscheduler.extract.master.transportor.TaskGroupSlotAcquireSuccessNotifyRequest;
import org.apache.dolphinscheduler.extract.master.transportor.TaskGroupSlotAcquireSuccessNotifyResponse;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.server.master.engine.ITaskGroupCoordinator;
import org.apache.dolphinscheduler.server.master.utils.TaskGroupUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskGroupCoordinator
implements ITaskGroupCoordinator,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskGroupCoordinator.class);
    @Autowired
    private TaskGroupDao taskGroupDao;
    @Autowired
    private TaskGroupQueueDao taskGroupQueueDao;
    @Autowired
    private TaskInstanceDao taskInstanceDao;
    @Autowired
    private WorkflowInstanceDao workflowInstanceDao;
    private boolean flag = false;
    private Thread internalThread;
    private static final int DEFAULT_LIMIT = 1000;

    @Override
    public synchronized void start() {
        log.info("TaskGroupCoordinator starting...");
        if (this.flag) {
            throw new IllegalStateException("TaskGroupCoordinator is already started");
        }
        if (this.internalThread != null) {
            throw new IllegalStateException("InternalThread is already started");
        }
        this.flag = true;
        this.internalThread = new BaseDaemonThread(this::doStart){};
        this.internalThread.setName("TaskGroupCoordinator-Thread");
        this.internalThread.start();
        log.info("TaskGroupCoordinator started...");
    }

    @VisibleForTesting
    boolean isStarted() {
        return this.flag;
    }

    private void doStart() {
        ThreadUtils.sleep((long)TimeUnit.MINUTES.toMillis(1L));
        while (this.flag) {
            try {
                StopWatch taskGroupCoordinatorRoundCost = StopWatch.createStarted();
                this.amendTaskGroupUseSize();
                this.amendTaskGroupQueueStatus();
                this.dealWithForceStartTaskGroupQueue();
                this.dealWithWaitingTaskGroupQueue();
                taskGroupCoordinatorRoundCost.stop();
                log.debug("TaskGroupCoordinator round cost: {}/ms", (Object)taskGroupCoordinatorRoundCost.getTime());
            }
            catch (Throwable e) {
                log.error("TaskGroupCoordinator error", e);
            }
            finally {
                ThreadUtils.sleep((long)5000L);
            }
        }
    }

    private void amendTaskGroupUseSize() {
        List taskGroups = this.taskGroupDao.queryAllTaskGroups();
        if (CollectionUtils.isEmpty((Collection)taskGroups)) {
            return;
        }
        StopWatch taskGroupCoordinatorRoundTimeCost = StopWatch.createStarted();
        for (TaskGroup taskGroup : taskGroups) {
            int actualUseSize = this.taskGroupQueueDao.countUsingTaskGroupQueueByGroupId(taskGroup.getId());
            if (taskGroup.getUseSize() == actualUseSize) continue;
            log.warn("The TaskGroup: {} useSize is {}, but the actual use size is {}, will amend it", new Object[]{taskGroup.getName(), taskGroup.getUseSize(), actualUseSize});
            taskGroup.setUseSize(actualUseSize);
            this.taskGroupDao.updateById((Object)taskGroup);
        }
        log.info("Success amend TaskGroup useSize cost: {}/ms", (Object)taskGroupCoordinatorRoundTimeCost.getTime());
    }

    private void amendTaskGroupQueueStatus() {
        List taskGroupQueues;
        int minTaskGroupQueueId = -1;
        int limit = 1000;
        StopWatch taskGroupCoordinatorRoundTimeCost = StopWatch.createStarted();
        while (!CollectionUtils.isEmpty((Collection)(taskGroupQueues = this.taskGroupQueueDao.queryInQueueTaskGroupQueue(minTaskGroupQueueId, limit)))) {
            this.amendTaskGroupQueueStatus(taskGroupQueues);
            if (taskGroupQueues.size() < limit) break;
            minTaskGroupQueueId = ((TaskGroupQueue)taskGroupQueues.get(taskGroupQueues.size() - 1)).getId();
        }
        log.debug("Success amend TaskGroupQueue status cost: {}/ms", (Object)taskGroupCoordinatorRoundTimeCost.getTime());
    }

    private void amendTaskGroupQueueStatus(List<TaskGroupQueue> taskGroupQueues) {
        List taskInstanceIds = taskGroupQueues.stream().map(TaskGroupQueue::getTaskId).collect(Collectors.toList());
        Map taskInstanceMap = this.taskInstanceDao.queryByIds(taskInstanceIds).stream().collect(Collectors.toMap(TaskInstance::getId, Function.identity()));
        for (TaskGroupQueue taskGroupQueue : taskGroupQueues) {
            int taskId = taskGroupQueue.getTaskId();
            TaskInstance taskInstance = (TaskInstance)taskInstanceMap.get(taskId);
            if (taskInstance == null) {
                log.warn("The TaskInstance: {} is not exist, will release the TaskGroupQueue: {}", (Object)taskId, (Object)taskGroupQueue);
                this.deleteTaskGroupQueueSlot(taskGroupQueue);
                continue;
            }
            if (!taskInstance.getState().isFinished()) continue;
            log.warn("The TaskInstance: {} state: {} finished, will release the TaskGroupQueue: {}", new Object[]{taskInstance.getName(), taskInstance.getState(), taskGroupQueue});
            this.deleteTaskGroupQueueSlot(taskGroupQueue);
        }
    }

    private void dealWithForceStartTaskGroupQueue() {
        List taskGroupQueues;
        int minTaskGroupQueueId = -1;
        int limit = 1000;
        StopWatch taskGroupCoordinatorRoundTimeCost = StopWatch.createStarted();
        while (!CollectionUtils.isEmpty((Collection)(taskGroupQueues = this.taskGroupQueueDao.queryWaitNotifyForceStartTaskGroupQueue(minTaskGroupQueueId, limit)))) {
            this.dealWithForceStartTaskGroupQueue(taskGroupQueues);
            if (taskGroupQueues.size() < limit) break;
            minTaskGroupQueueId = ((TaskGroupQueue)taskGroupQueues.get(taskGroupQueues.size() - 1)).getId();
        }
        log.debug("Success deal with force start TaskGroupQueue cost: {}/ms", (Object)taskGroupCoordinatorRoundTimeCost.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealWithForceStartTaskGroupQueue(List<TaskGroupQueue> taskGroupQueues) {
        for (TaskGroupQueue taskGroupQueue : taskGroupQueues) {
            try {
                LogUtils.setTaskInstanceIdMDC((Integer)taskGroupQueue.getTaskId());
                this.notifyWaitingTaskInstance(taskGroupQueue);
                log.info("Notify the ForceStart waiting TaskInstance: {} for taskGroupQueue: {} success", (Object)taskGroupQueue.getTaskName(), (Object)taskGroupQueue.getId());
                this.deleteTaskGroupQueueSlot(taskGroupQueue);
                log.info("Release the force start TaskGroupQueue {}", (Object)taskGroupQueue);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.deleteTaskGroupQueueSlot(taskGroupQueue);
                log.info("Notify the ForceStart TaskInstance: {} for taskGroupQueue: {} failed, will release the taskGroupQueue", new Object[]{taskGroupQueue.getTaskName(), taskGroupQueue.getId(), unsupportedOperationException});
            }
            catch (Throwable throwable) {
                log.info("Notify the force start TaskGroupQueue {} failed", (Object)taskGroupQueue, (Object)throwable);
            }
            finally {
                LogUtils.removeTaskInstanceIdMDC();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealWithWaitingTaskGroupQueue() {
        List taskGroups = this.taskGroupDao.queryAvailableTaskGroups();
        if (CollectionUtils.isEmpty((Collection)taskGroups)) {
            log.debug("There is no available task group");
            return;
        }
        for (TaskGroup taskGroup : taskGroups) {
            int availableSize = taskGroup.getGroupSize() - taskGroup.getUseSize();
            if (availableSize <= 0) {
                log.info("TaskGroup {} is full, available size is {}", (Object)taskGroup, (Object)availableSize);
                continue;
            }
            List taskGroupQueues = this.taskGroupQueueDao.queryAllInQueueTaskGroupQueueByGroupId(taskGroup.getId()).stream().filter(taskGroupQueue -> Flag.NO.getCode() == taskGroupQueue.getForceStart()).filter(taskGroupQueue -> TaskGroupQueueStatus.WAIT_QUEUE == taskGroupQueue.getStatus()).limit(availableSize).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(taskGroupQueues)) {
                log.debug("There is no waiting task group queue for task group {}", (Object)taskGroup.getName());
                continue;
            }
            for (TaskGroupQueue taskGroupQueue2 : taskGroupQueues) {
                try {
                    LogUtils.setTaskInstanceIdMDC((Integer)taskGroupQueue2.getTaskId());
                    boolean acquireResult = this.taskGroupDao.acquireTaskGroupSlot(taskGroup.getId());
                    if (!acquireResult) {
                        log.error("Failed to acquire task group slot for task group {}", (Object)taskGroup);
                        continue;
                    }
                    this.notifyWaitingTaskInstance(taskGroupQueue2);
                    taskGroupQueue2.setInQueue(Flag.YES.getCode());
                    taskGroupQueue2.setStatus(TaskGroupQueueStatus.ACQUIRE_SUCCESS);
                    taskGroupQueue2.setUpdateTime(new Date());
                    this.taskGroupQueueDao.updateById((Object)taskGroupQueue2);
                    log.info("Success acquire TaskGroupSlot for TaskGroupQueue: {}", (Object)taskGroupQueue2);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.deleteTaskGroupQueueSlot(taskGroupQueue2);
                    log.info("Notify the Waiting TaskInstance: {} for taskGroupQueue: {} failed, will release the taskGroupQueue", new Object[]{taskGroupQueue2.getTaskName(), taskGroupQueue2.getId(), unsupportedOperationException});
                }
                catch (Throwable throwable) {
                    log.error("Notify Waiting TaskGroupQueue: {} failed", (Object)taskGroupQueue2, (Object)throwable);
                }
                finally {
                    LogUtils.removeTaskInstanceIdMDC();
                }
            }
        }
    }

    @Override
    public boolean needAcquireTaskGroupSlot(TaskInstance taskInstance) {
        if (taskInstance == null) {
            throw new IllegalArgumentException("The TaskInstance is null");
        }
        if (!TaskGroupUtils.isUsingTaskGroup(taskInstance)) {
            log.debug("The current TaskInstance doesn't use TaskGroup, no need to acquire TaskGroupSlot");
            return false;
        }
        TaskGroup taskGroup = (TaskGroup)this.taskGroupDao.queryById((Serializable)Integer.valueOf(taskInstance.getTaskGroupId()));
        if (taskGroup == null) {
            log.warn("The current TaskGroup: {} does not exist, will not acquire TaskGroupSlot", (Object)taskInstance.getTaskGroupId());
            return false;
        }
        return Flag.YES.equals((Object)taskGroup.getStatus());
    }

    @Override
    public void acquireTaskGroupSlot(TaskInstance taskInstance, TaskDefinition taskDefinition) {
        if (taskInstance == null || taskInstance.getTaskGroupId() <= 0) {
            throw new IllegalArgumentException("The current TaskInstance does not use task group");
        }
        TaskGroup taskGroup = (TaskGroup)this.taskGroupDao.queryById((Serializable)Integer.valueOf(taskInstance.getTaskGroupId()));
        if (taskGroup == null) {
            throw new IllegalArgumentException("The current TaskGroup: " + taskInstance.getTaskGroupId() + " does not exist");
        }
        Date now = new Date();
        TaskGroupQueue taskGroupQueue = TaskGroupQueue.builder().taskId(taskInstance.getId().intValue()).taskName(taskInstance.getName()).groupId(taskInstance.getTaskGroupId()).workflowInstanceId(Integer.valueOf(taskInstance.getWorkflowInstanceId())).priority(taskDefinition.getTaskGroupPriority()).inQueue(Flag.YES.getCode()).forceStart(Flag.NO.getCode()).status(TaskGroupQueueStatus.WAIT_QUEUE).createTime(now).updateTime(now).build();
        log.info("Success insert TaskGroupQueue: {} for TaskInstance: {}", (Object)taskGroupQueue, (Object)taskInstance.getName());
        this.taskGroupQueueDao.insert((Object)taskGroupQueue);
    }

    @Override
    public boolean needToReleaseTaskGroupSlot(TaskInstance taskInstance) {
        if (taskInstance == null) {
            throw new IllegalArgumentException("The TaskInstance is null");
        }
        if (taskInstance.getTaskGroupId() <= 0) {
            log.debug("The current TaskInstance doesn't use TaskGroup, no need to release TaskGroupSlot");
            return false;
        }
        return true;
    }

    @Override
    public void releaseTaskGroupSlot(TaskInstance taskInstance) {
        if (taskInstance == null) {
            throw new IllegalArgumentException("The TaskInstance is null");
        }
        if (taskInstance.getTaskGroupId() <= 0) {
            log.warn("The task: {} is no need to release TaskGroupSlot", (Object)taskInstance.getName());
            return;
        }
        List taskGroupQueues = this.taskGroupQueueDao.queryByTaskInstanceId(taskInstance.getId());
        for (TaskGroupQueue taskGroupQueue : taskGroupQueues) {
            this.deleteTaskGroupQueueSlot(taskGroupQueue);
        }
    }

    private void notifyWaitingTaskInstance(TaskGroupQueue taskGroupQueue) {
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceDao.queryById((Serializable)Integer.valueOf(taskGroupQueue.getTaskId()));
        if (taskInstance == null) {
            throw new UnsupportedOperationException("The TaskInstance: " + taskGroupQueue.getTaskId() + " is not exist, no need to notify");
        }
        if (taskInstance.getState() != TaskExecutionStatus.SUBMITTED_SUCCESS) {
            throw new UnsupportedOperationException("The TaskInstance: " + taskInstance.getId() + " state is " + taskInstance.getState() + ", no need to notify");
        }
        WorkflowInstance workflowInstance = (WorkflowInstance)this.workflowInstanceDao.queryById((Serializable)Integer.valueOf(taskInstance.getWorkflowInstanceId()));
        if (workflowInstance == null) {
            throw new UnsupportedOperationException("The WorkflowInstance: " + taskInstance.getWorkflowInstanceId() + " is not exist, no need to notify");
        }
        if (workflowInstance.getState() != WorkflowExecutionStatus.RUNNING_EXECUTION) {
            throw new UnsupportedOperationException("The WorkflowInstance: " + workflowInstance.getId() + " state is " + workflowInstance.getState() + ", no need to notify");
        }
        if (workflowInstance.getHost() == null || "NULL".equals(workflowInstance.getHost())) {
            throw new UnsupportedOperationException("WorkflowInstance host is null, maybe it is in failover: " + workflowInstance);
        }
        TaskGroupSlotAcquireSuccessNotifyRequest taskGroupSlotAcquireSuccessNotifyRequest = TaskGroupSlotAcquireSuccessNotifyRequest.builder().workflowInstanceId(workflowInstance.getId()).taskInstanceId(taskInstance.getId()).build();
        TaskGroupSlotAcquireSuccessNotifyResponse taskGroupSlotAcquireSuccessNotifyResponse = ((ITaskInstanceController)Clients.withService(ITaskInstanceController.class).withHost(workflowInstance.getHost())).notifyTaskGroupSlotAcquireSuccess(taskGroupSlotAcquireSuccessNotifyRequest);
        if (!taskGroupSlotAcquireSuccessNotifyResponse.isSuccess()) {
            throw new UnsupportedOperationException("Notify TaskInstance: " + taskInstance.getId() + " failed: " + taskGroupSlotAcquireSuccessNotifyResponse);
        }
        log.info("Wake up TaskInstance: {} success", (Object)taskInstance.getName());
    }

    private void deleteTaskGroupQueueSlot(TaskGroupQueue taskGroupQueue) {
        this.taskGroupQueueDao.deleteById((Serializable)taskGroupQueue);
        log.info("Success release TaskGroupQueue: {}", (Object)taskGroupQueue);
    }

    @Override
    public synchronized void close() {
        if (!this.flag) {
            log.warn("TaskGroupCoordinator is already closed");
            return;
        }
        this.flag = false;
        try {
            if (this.internalThread != null) {
                this.internalThread.interrupt();
            }
        }
        catch (Exception ex) {
            log.error("Close internalThread failed", (Throwable)ex);
        }
        this.internalThread = null;
        log.info("TaskGroupCoordinator closed");
    }
}

