/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallOptions;
import com.google.api.gax.httpjson.HttpJsonChannel;
import com.google.api.gax.httpjson.HttpJsonClientCall;
import com.google.api.gax.httpjson.HttpJsonClientCallImpl;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@BetaApi
public class ManagedHttpJsonChannel
implements HttpJsonChannel,
BackgroundResource {
    private static final ExecutorService DEFAULT_EXECUTOR = InstantiatingExecutorProvider.newBuilder().build().getExecutor();
    private final Executor executor;
    private final String endpoint;
    private final HttpTransport httpTransport;
    private boolean isTransportShutdown;

    protected ManagedHttpJsonChannel() {
        this(null, null, null);
    }

    private ManagedHttpJsonChannel(Executor executor, String endpoint, @Nullable HttpTransport httpTransport) {
        this.executor = executor;
        this.endpoint = endpoint;
        this.httpTransport = httpTransport == null ? new NetHttpTransport() : httpTransport;
    }

    @Override
    public <RequestT, ResponseT> HttpJsonClientCall<RequestT, ResponseT> newCall(ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor, HttpJsonCallOptions callOptions) {
        return new HttpJsonClientCallImpl<RequestT, ResponseT>(methodDescriptor, this.endpoint, callOptions, this.httpTransport, this.executor);
    }

    public synchronized void shutdown() {
        if (this.isTransportShutdown) {
            return;
        }
        try {
            this.httpTransport.shutdown();
            this.isTransportShutdown = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isShutdown() {
        return this.isTransportShutdown;
    }

    public boolean isTerminated() {
        return this.isTransportShutdown;
    }

    public void shutdownNow() {
        this.shutdown();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return false;
    }

    public void close() {
    }

    public static Builder newBuilder() {
        return new Builder().setExecutor(DEFAULT_EXECUTOR);
    }

    public static class Builder {
        private Executor executor;
        private String endpoint;
        private HttpTransport httpTransport;

        private Builder() {
        }

        public Builder setExecutor(Executor executor) {
            this.executor = executor == null ? DEFAULT_EXECUTOR : executor;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder setHttpTransport(HttpTransport httpTransport) {
            this.httpTransport = httpTransport;
            return this;
        }

        public ManagedHttpJsonChannel build() {
            Preconditions.checkNotNull((Object)this.endpoint);
            return new ManagedHttpJsonChannel(this.executor, this.endpoint, (HttpTransport)(this.httpTransport == null ? new NetHttpTransport() : this.httpTransport));
        }
    }
}

