/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.authentication.actuator.config;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@AutoConfiguration
@EnableWebSecurity
@EnableConfigurationProperties(value={ActuatorSecurityProperties.class})
public class ActuatorAuthenticationAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ActuatorAuthenticationAutoConfiguration.class);
    private static final String ACTUATOR_PATH_PATTERN_1 = "/dolphinscheduler/actuator/";
    private static final String ACTUATOR_PATH_PATTERN_2 = "/actuator/";
    private static final String ROLE_ACTUATOR = "ACTUATOR";

    @Bean
    public SecurityFilterChain actuatorSecurityFilterChain(HttpSecurity http, ActuatorSecurityProperties properties) throws Exception {
        log.info("Initialize ActuatorSecurityConfiguration, management.security.enabled: {}, management.security.exclude: {}", (Object)properties.isEnabled(), properties.getExclude());
        http.requestMatcher(request -> request.getRequestURI().startsWith(ACTUATOR_PATH_PATTERN_1) || request.getRequestURI().startsWith(ACTUATOR_PATH_PATTERN_2));
        if (properties.isEnabled()) {
            http.authorizeHttpRequests(authz -> {
                for (String endpoint : properties.getExclude()) {
                    if (!StringUtils.isNotBlank((CharSequence)endpoint)) continue;
                    String cleanEndpoint = endpoint.trim();
                    ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher(ACTUATOR_PATH_PATTERN_2 + cleanEndpoint)})).permitAll();
                    ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher(ACTUATOR_PATH_PATTERN_1 + cleanEndpoint)})).permitAll();
                }
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.anyRequest()).hasRole(ROLE_ACTUATOR);
            }).httpBasic();
        } else {
            http.authorizeHttpRequests(authz -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.anyRequest()).permitAll());
        }
        http.csrf().disable();
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public UserDetailsService actuatorUserDetailsService(ActuatorSecurityProperties properties) {
        if (!properties.isEnabled()) {
            return new InMemoryUserDetailsManager();
        }
        String username = properties.getUsername();
        String password = properties.getPassword();
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException("management.security.username must be configured when enabled.");
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("management.security.password must be configured when enabled.");
        }
        UserDetails user = User.withUsername((String)username).password("{noop}" + password).roles(new String[]{ROLE_ACTUATOR}).build();
        return new InMemoryUserDetailsManager(new UserDetails[]{user});
    }

    @ConfigurationProperties(value="management.security")
    public static class ActuatorSecurityProperties {
        private boolean enabled = false;
        private String username;
        private String password;
        private List<String> exclude = new ArrayList<String>();

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public List<String> getExclude() {
            return this.exclude;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setUsername(String username) {
            this.username = username;
        }

        @Generated
        public void setPassword(String password) {
            this.password = password;
        }

        @Generated
        public void setExclude(List<String> exclude) {
            this.exclude = exclude;
        }

        @Generated
        public String toString() {
            return "ActuatorAuthenticationAutoConfiguration.ActuatorSecurityProperties(enabled=" + this.isEnabled() + ", username=" + this.getUsername() + ", exclude=" + this.getExclude() + ")";
        }
    }
}

