/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ObjectStorageServerProtocol {
    HTTPS("HTTPS"),
    HTTP("HTTP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ObjectStorageServerProtocol> VALUE_MAP;
    private final String value;

    private ObjectStorageServerProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ObjectStorageServerProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ObjectStorageServerProtocol> knownValues() {
        EnumSet<ObjectStorageServerProtocol> knownValues = EnumSet.allOf(ObjectStorageServerProtocol.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ObjectStorageServerProtocol.class, ObjectStorageServerProtocol::toString);
    }
}

