/*
 * Decompiled with CFR 0.152.
 */
package shade.fasterxml.jackson.databind.deser.impl;

import java.io.IOException;
import java.io.Serializable;
import shade.fasterxml.jackson.annotation.ObjectIdGenerator;
import shade.fasterxml.jackson.annotation.ObjectIdResolver;
import shade.fasterxml.jackson.core.JsonParser;
import shade.fasterxml.jackson.databind.DeserializationContext;
import shade.fasterxml.jackson.databind.JavaType;
import shade.fasterxml.jackson.databind.JsonDeserializer;
import shade.fasterxml.jackson.databind.PropertyName;
import shade.fasterxml.jackson.databind.deser.SettableBeanProperty;

public class ObjectIdReader
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final JavaType _idType;
    public final PropertyName propertyName;
    public final ObjectIdGenerator<?> generator;
    public final ObjectIdResolver resolver;
    protected final JsonDeserializer<Object> _deserializer;
    public final SettableBeanProperty idProperty;

    protected ObjectIdReader(JavaType t, PropertyName propName, ObjectIdGenerator<?> gen, JsonDeserializer<?> deser, SettableBeanProperty idProp, ObjectIdResolver resolver) {
        this._idType = t;
        this.propertyName = propName;
        this.generator = gen;
        this.resolver = resolver;
        this._deserializer = deser;
        this.idProperty = idProp;
    }

    public static ObjectIdReader construct(JavaType idType, PropertyName propName, ObjectIdGenerator<?> generator, JsonDeserializer<?> deser, SettableBeanProperty idProp, ObjectIdResolver resolver) {
        return new ObjectIdReader(idType, propName, generator, deser, idProp, resolver);
    }

    public JsonDeserializer<Object> getDeserializer() {
        return this._deserializer;
    }

    public JavaType getIdType() {
        return this._idType;
    }

    public boolean maySerializeAsObject() {
        return this.generator.maySerializeAsObject();
    }

    public boolean isValidReferencePropertyName(String name, JsonParser parser) {
        return this.generator.isValidReferencePropertyName(name, parser);
    }

    public Object readObjectReference(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return this._deserializer.deserialize(jp, ctxt);
    }
}

