/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token.delegation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import javax.crypto.SecretKey;
import org.apache.avro.reflect.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class DelegationKey
implements Writable {
    private int keyId;
    private long expiryDate;
    @Nullable
    private byte[] keyBytes = null;
    private static final int MAX_KEY_LEN = 0x100000;

    public DelegationKey() {
        this(0, 0L, (SecretKey)null);
    }

    public DelegationKey(int keyId, long expiryDate, SecretKey key) {
        this(keyId, expiryDate, key != null ? key.getEncoded() : null);
    }

    public DelegationKey(int keyId, long expiryDate, byte[] encodedKey) {
        this.keyId = keyId;
        this.expiryDate = expiryDate;
        if (encodedKey != null) {
            if (encodedKey.length > 0x100000) {
                throw new RuntimeException("can't create " + encodedKey.length + " byte long DelegationKey.");
            }
            this.keyBytes = encodedKey;
        }
    }

    public int getKeyId() {
        return this.keyId;
    }

    public long getExpiryDate() {
        return this.expiryDate;
    }

    public SecretKey getKey() {
        if (this.keyBytes == null || this.keyBytes.length == 0) {
            return null;
        }
        SecretKey key = AbstractDelegationTokenSecretManager.createSecretKey(this.keyBytes);
        return key;
    }

    public byte[] getEncodedKey() {
        return this.keyBytes;
    }

    public void setExpiryDate(long expiryDate) {
        this.expiryDate = expiryDate;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt(out, this.keyId);
        WritableUtils.writeVLong(out, this.expiryDate);
        if (this.keyBytes == null) {
            WritableUtils.writeVInt(out, -1);
        } else {
            WritableUtils.writeVInt(out, this.keyBytes.length);
            out.write(this.keyBytes);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.keyId = WritableUtils.readVInt(in);
        this.expiryDate = WritableUtils.readVLong(in);
        int len = WritableUtils.readVIntInRange(in, -1, 0x100000);
        if (len == -1) {
            this.keyBytes = null;
        } else {
            this.keyBytes = new byte[len];
            in.readFully(this.keyBytes);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.expiryDate ^ this.expiryDate >>> 32);
        result = 31 * result + Arrays.hashCode(this.keyBytes);
        result = 31 * result + this.keyId;
        return result;
    }

    public boolean equals(Object right) {
        if (this == right) {
            return true;
        }
        if (right == null || this.getClass() != right.getClass()) {
            return false;
        }
        DelegationKey r = (DelegationKey)right;
        return this.keyId == r.keyId && this.expiryDate == r.expiryDate && Arrays.equals(this.keyBytes, r.keyBytes);
    }
}

