/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.runnable;

import java.util.Date;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.AbstractTaskInstanceFactory;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskInstanceFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class FailedRecoverTaskInstanceFactory
extends AbstractTaskInstanceFactory<FailedRecoverTaskInstanceBuilder> {
    @Autowired
    private TaskInstanceDao taskInstanceDao;

    @Override
    public FailedRecoverTaskInstanceBuilder builder() {
        return new FailedRecoverTaskInstanceBuilder(this);
    }

    @Override
    @Transactional
    public TaskInstance createTaskInstance(FailedRecoverTaskInstanceBuilder builder) {
        TaskInstance needRecoverTaskInstance = builder.needRecoverTaskInstance;
        TaskInstance taskInstance = this.cloneTaskInstance(needRecoverTaskInstance);
        taskInstance.setId(null);
        taskInstance.setState(TaskExecutionStatus.SUBMITTED_SUCCESS);
        taskInstance.setHost(null);
        taskInstance.setVarPool(null);
        taskInstance.setSubmitTime(new Date());
        taskInstance.setLogPath(null);
        taskInstance.setExecutePath(null);
        this.taskInstanceDao.insert((Object)taskInstance);
        needRecoverTaskInstance.setFlag(Flag.NO);
        this.taskInstanceDao.updateById((Object)needRecoverTaskInstance);
        return taskInstance;
    }

    public static class FailedRecoverTaskInstanceBuilder
    implements ITaskInstanceFactory.ITaskInstanceBuilder {
        private final FailedRecoverTaskInstanceFactory failedRecoverTaskInstanceFactory;
        private TaskInstance needRecoverTaskInstance;

        public FailedRecoverTaskInstanceBuilder(FailedRecoverTaskInstanceFactory failedRecoverTaskInstanceFactory) {
            this.failedRecoverTaskInstanceFactory = failedRecoverTaskInstanceFactory;
        }

        public FailedRecoverTaskInstanceBuilder withTaskInstance(TaskInstance needRecoverTaskInstance) {
            this.needRecoverTaskInstance = needRecoverTaskInstance;
            return this;
        }

        @Override
        public TaskInstance build() {
            return this.failedRecoverTaskInstanceFactory.createTaskInstance(this);
        }
    }
}

