/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.workflow.trigger;

import java.util.Date;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceRecoverFailureTasksRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceRecoverFailureTasksResponse;
import org.apache.dolphinscheduler.server.master.engine.workflow.trigger.AbstractWorkflowInstanceTrigger;
import org.springframework.stereotype.Component;

@Component
public class WorkflowInstanceRecoverFailureTaskTrigger
extends AbstractWorkflowInstanceTrigger<WorkflowInstanceRecoverFailureTasksRequest, WorkflowInstanceRecoverFailureTasksResponse> {
    @Override
    protected WorkflowInstance constructWorkflowInstance(WorkflowInstanceRecoverFailureTasksRequest workflowInstanceRecoverFailureTasksRequest) {
        WorkflowInstance workflowInstance = this.getWorkflowInstance(workflowInstanceRecoverFailureTasksRequest.getWorkflowInstanceId());
        workflowInstance.setStateWithDesc(WorkflowExecutionStatus.SUBMITTED_SUCCESS, CommandType.START_FAILURE_TASK_PROCESS.name());
        workflowInstance.setRunTimes(workflowInstance.getRunTimes() + 1);
        workflowInstance.setRestartTime(new Date());
        workflowInstance.setEndTime(null);
        return workflowInstance;
    }

    @Override
    protected Command constructTriggerCommand(WorkflowInstanceRecoverFailureTasksRequest workflowInstanceRecoverFailureTasksRequest, WorkflowInstance workflowInstance) {
        return Command.builder().commandType(CommandType.START_FAILURE_TASK_PROCESS).workflowDefinitionCode(workflowInstance.getWorkflowDefinitionCode().longValue()).workflowDefinitionVersion(workflowInstance.getWorkflowDefinitionVersion()).workflowInstanceId(workflowInstance.getId().intValue()).executorId(workflowInstanceRecoverFailureTasksRequest.getUserId().intValue()).startTime(new Date()).updateTime(new Date()).build();
    }

    @Override
    protected WorkflowInstanceRecoverFailureTasksResponse onTriggerSuccess(WorkflowInstance workflowInstance) {
        return WorkflowInstanceRecoverFailureTasksResponse.success();
    }
}

