/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1beta1UserInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="TokenReviewStatus is the result of the token authentication request.")
public class V1beta1TokenReviewStatus {
    public static final String SERIALIZED_NAME_AUDIENCES = "audiences";
    @SerializedName(value="audiences")
    private List<String> audiences = null;
    public static final String SERIALIZED_NAME_AUTHENTICATED = "authenticated";
    @SerializedName(value="authenticated")
    private Boolean authenticated;
    public static final String SERIALIZED_NAME_ERROR = "error";
    @SerializedName(value="error")
    private String error;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private V1beta1UserInfo user;

    public V1beta1TokenReviewStatus audiences(List<String> audiences) {
        this.audiences = audiences;
        return this;
    }

    public V1beta1TokenReviewStatus addAudiencesItem(String audiencesItem) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.add(audiencesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Audiences are audience identifiers chosen by the authenticator that are compatible with both the TokenReview and token. An identifier is any identifier in the intersection of the TokenReviewSpec audiences and the token's audiences. A client of the TokenReview API that sets the spec.audiences field should validate that a compatible audience identifier is returned in the status.audiences field to ensure that the TokenReview server is audience aware. If a TokenReview returns an empty status.audience field where status.authenticated is \"true\", the token is valid against the audience of the Kubernetes API server.")
    public List<String> getAudiences() {
        return this.audiences;
    }

    public void setAudiences(List<String> audiences) {
        this.audiences = audiences;
    }

    public V1beta1TokenReviewStatus authenticated(Boolean authenticated) {
        this.authenticated = authenticated;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Authenticated indicates that the token was associated with a known user.")
    public Boolean getAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(Boolean authenticated) {
        this.authenticated = authenticated;
    }

    public V1beta1TokenReviewStatus error(String error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Error indicates that the token couldn't be checked")
    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public V1beta1TokenReviewStatus user(V1beta1UserInfo user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1beta1UserInfo getUser() {
        return this.user;
    }

    public void setUser(V1beta1UserInfo user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1TokenReviewStatus v1beta1TokenReviewStatus = (V1beta1TokenReviewStatus)o;
        return Objects.equals(this.audiences, v1beta1TokenReviewStatus.audiences) && Objects.equals(this.authenticated, v1beta1TokenReviewStatus.authenticated) && Objects.equals(this.error, v1beta1TokenReviewStatus.error) && Objects.equals(this.user, v1beta1TokenReviewStatus.user);
    }

    public int hashCode() {
        return Objects.hash(this.audiences, this.authenticated, this.error, this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1TokenReviewStatus {\n");
        sb.append("    audiences: ").append(this.toIndentedString(this.audiences)).append("\n");
        sb.append("    authenticated: ").append(this.toIndentedString(this.authenticated)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

