/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.SsisExecutionCredential;
import com.azure.resourcemanager.datafactory.models.SsisExecutionParameter;
import com.azure.resourcemanager.datafactory.models.SsisLogLocation;
import com.azure.resourcemanager.datafactory.models.SsisPackageLocation;
import com.azure.resourcemanager.datafactory.models.SsisPropertyOverride;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class ExecuteSsisPackageActivityTypeProperties {
    @JsonProperty(value="packageLocation", required=true)
    private SsisPackageLocation packageLocation;
    @JsonProperty(value="runtime")
    private Object runtime;
    @JsonProperty(value="loggingLevel")
    private Object loggingLevel;
    @JsonProperty(value="environmentPath")
    private Object environmentPath;
    @JsonProperty(value="executionCredential")
    private SsisExecutionCredential executionCredential;
    @JsonProperty(value="connectVia", required=true)
    private IntegrationRuntimeReference connectVia;
    @JsonProperty(value="projectParameters")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, SsisExecutionParameter> projectParameters;
    @JsonProperty(value="packageParameters")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, SsisExecutionParameter> packageParameters;
    @JsonProperty(value="projectConnectionManagers")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, Map<String, SsisExecutionParameter>> projectConnectionManagers;
    @JsonProperty(value="packageConnectionManagers")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, Map<String, SsisExecutionParameter>> packageConnectionManagers;
    @JsonProperty(value="propertyOverrides")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, SsisPropertyOverride> propertyOverrides;
    @JsonProperty(value="logLocation")
    private SsisLogLocation logLocation;
    private static final ClientLogger LOGGER = new ClientLogger(ExecuteSsisPackageActivityTypeProperties.class);

    public SsisPackageLocation packageLocation() {
        return this.packageLocation;
    }

    public ExecuteSsisPackageActivityTypeProperties withPackageLocation(SsisPackageLocation packageLocation) {
        this.packageLocation = packageLocation;
        return this;
    }

    public Object runtime() {
        return this.runtime;
    }

    public ExecuteSsisPackageActivityTypeProperties withRuntime(Object runtime) {
        this.runtime = runtime;
        return this;
    }

    public Object loggingLevel() {
        return this.loggingLevel;
    }

    public ExecuteSsisPackageActivityTypeProperties withLoggingLevel(Object loggingLevel) {
        this.loggingLevel = loggingLevel;
        return this;
    }

    public Object environmentPath() {
        return this.environmentPath;
    }

    public ExecuteSsisPackageActivityTypeProperties withEnvironmentPath(Object environmentPath) {
        this.environmentPath = environmentPath;
        return this;
    }

    public SsisExecutionCredential executionCredential() {
        return this.executionCredential;
    }

    public ExecuteSsisPackageActivityTypeProperties withExecutionCredential(SsisExecutionCredential executionCredential) {
        this.executionCredential = executionCredential;
        return this;
    }

    public IntegrationRuntimeReference connectVia() {
        return this.connectVia;
    }

    public ExecuteSsisPackageActivityTypeProperties withConnectVia(IntegrationRuntimeReference connectVia) {
        this.connectVia = connectVia;
        return this;
    }

    public Map<String, SsisExecutionParameter> projectParameters() {
        return this.projectParameters;
    }

    public ExecuteSsisPackageActivityTypeProperties withProjectParameters(Map<String, SsisExecutionParameter> projectParameters) {
        this.projectParameters = projectParameters;
        return this;
    }

    public Map<String, SsisExecutionParameter> packageParameters() {
        return this.packageParameters;
    }

    public ExecuteSsisPackageActivityTypeProperties withPackageParameters(Map<String, SsisExecutionParameter> packageParameters) {
        this.packageParameters = packageParameters;
        return this;
    }

    public Map<String, Map<String, SsisExecutionParameter>> projectConnectionManagers() {
        return this.projectConnectionManagers;
    }

    public ExecuteSsisPackageActivityTypeProperties withProjectConnectionManagers(Map<String, Map<String, SsisExecutionParameter>> projectConnectionManagers) {
        this.projectConnectionManagers = projectConnectionManagers;
        return this;
    }

    public Map<String, Map<String, SsisExecutionParameter>> packageConnectionManagers() {
        return this.packageConnectionManagers;
    }

    public ExecuteSsisPackageActivityTypeProperties withPackageConnectionManagers(Map<String, Map<String, SsisExecutionParameter>> packageConnectionManagers) {
        this.packageConnectionManagers = packageConnectionManagers;
        return this;
    }

    public Map<String, SsisPropertyOverride> propertyOverrides() {
        return this.propertyOverrides;
    }

    public ExecuteSsisPackageActivityTypeProperties withPropertyOverrides(Map<String, SsisPropertyOverride> propertyOverrides) {
        this.propertyOverrides = propertyOverrides;
        return this;
    }

    public SsisLogLocation logLocation() {
        return this.logLocation;
    }

    public ExecuteSsisPackageActivityTypeProperties withLogLocation(SsisLogLocation logLocation) {
        this.logLocation = logLocation;
        return this;
    }

    public void validate() {
        if (this.packageLocation() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property packageLocation in model ExecuteSsisPackageActivityTypeProperties"));
        }
        this.packageLocation().validate();
        if (this.executionCredential() != null) {
            this.executionCredential().validate();
        }
        if (this.connectVia() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property connectVia in model ExecuteSsisPackageActivityTypeProperties"));
        }
        this.connectVia().validate();
        if (this.projectParameters() != null) {
            this.projectParameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.packageParameters() != null) {
            this.packageParameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.projectConnectionManagers() != null) {
            this.projectConnectionManagers().values().forEach(e -> {
                if (e != null) {
                    e.values().forEach(e1 -> {
                        if (e1 != null) {
                            e1.validate();
                        }
                    });
                }
            });
        }
        if (this.packageConnectionManagers() != null) {
            this.packageConnectionManagers().values().forEach(e -> {
                if (e != null) {
                    e.values().forEach(e1 -> {
                        if (e1 != null) {
                            e1.validate();
                        }
                    });
                }
            });
        }
        if (this.propertyOverrides() != null) {
            this.propertyOverrides().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.logLocation() != null) {
            this.logLocation().validate();
        }
    }
}

